/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.textile.core.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.internal.wikitext.textile.core.Textile;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.QuoteAttributes;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;

public class QuoteBlock
extends Block {
    private static final int LINE_REMAINDER_GROUP = 10;
    private static final int CITATION_GROUP = 9;
    private static final int EXTENDED_GROUP = 8;
    static final Pattern startPattern = Pattern.compile("bq(\\(+)?(\\)+)?(\\<|\\>|\\=|\\<\\>)?(?:(?:\\(([^#\\)]+)?(?:#([^\\)]+))?\\))|(?:\\{([^\\}]+)\\})|(?:\\[([^\\]]+)\\])){0,3}\\.(\\.)?(?::(https?://[^\\s]*))?\\s+(.*)");
    private boolean extended;
    private boolean paraOpen;
    private int blockLineCount = 0;
    private Matcher matcher;

    public int processLineContent(String line, int offset) {
        if (this.blockLineCount == 0) {
            QuoteAttributes attributes = new QuoteAttributes();
            Textile.configureAttributes((Attributes)attributes, this.matcher, 1, true);
            attributes.setCitation(this.matcher.group(9));
            offset = this.matcher.start(10);
            this.extended = this.matcher.group(8) != null;
            this.builder.beginBlock(DocumentBuilder.BlockType.QUOTE, (Attributes)attributes);
            this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
            this.paraOpen = true;
        }
        if (this.markupLanguage.isEmptyLine(line)) {
            if (!this.extended) {
                this.setClosed(true);
                return 0;
            }
            if (this.paraOpen) {
                this.builder.endBlock();
                this.paraOpen = false;
            }
            return 0;
        }
        if (this.extended && Textile.explicitBlockBegins(line, offset)) {
            this.setClosed(true);
            return offset;
        }
        if (this.blockLineCount != 0) {
            if (this.paraOpen) {
                this.builder.lineBreak();
            } else {
                this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
                this.paraOpen = true;
            }
        }
        ++this.blockLineCount;
        this.getMarkupLanguage().emitMarkupLine(this.getParser(), this.state, line, offset);
        return -1;
    }

    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        if (lineOffset == 0) {
            this.matcher = startPattern.matcher(line);
            return this.matcher.matches();
        }
        this.matcher = null;
        return false;
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            if (this.paraOpen) {
                this.builder.endBlock();
                this.paraOpen = false;
            }
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }
}

