/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.makefile.gnu;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Stack;
import java.util.StringTokenizer;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.makefile.IDirective;
import org.eclipse.cdt.make.core.makefile.IMakefile;
import org.eclipse.cdt.make.core.makefile.IMakefileReaderProvider;
import org.eclipse.cdt.make.core.makefile.gnu.IGNUMakefile;
import org.eclipse.cdt.make.internal.core.makefile.AbstractMakefile;
import org.eclipse.cdt.make.internal.core.makefile.BadDirective;
import org.eclipse.cdt.make.internal.core.makefile.Command;
import org.eclipse.cdt.make.internal.core.makefile.Comment;
import org.eclipse.cdt.make.internal.core.makefile.DefaultRule;
import org.eclipse.cdt.make.internal.core.makefile.Directive;
import org.eclipse.cdt.make.internal.core.makefile.EmptyLine;
import org.eclipse.cdt.make.internal.core.makefile.IgnoreRule;
import org.eclipse.cdt.make.internal.core.makefile.InferenceRule;
import org.eclipse.cdt.make.internal.core.makefile.MacroDefinition;
import org.eclipse.cdt.make.internal.core.makefile.MakefileReader;
import org.eclipse.cdt.make.internal.core.makefile.PosixRule;
import org.eclipse.cdt.make.internal.core.makefile.PreciousRule;
import org.eclipse.cdt.make.internal.core.makefile.Rule;
import org.eclipse.cdt.make.internal.core.makefile.SccsGetRule;
import org.eclipse.cdt.make.internal.core.makefile.SilentRule;
import org.eclipse.cdt.make.internal.core.makefile.SpecialRule;
import org.eclipse.cdt.make.internal.core.makefile.SuffixesRule;
import org.eclipse.cdt.make.internal.core.makefile.Target;
import org.eclipse.cdt.make.internal.core.makefile.Util;
import org.eclipse.cdt.make.internal.core.makefile.gnu.Conditional;
import org.eclipse.cdt.make.internal.core.makefile.gnu.DefineVariable;
import org.eclipse.cdt.make.internal.core.makefile.gnu.DeleteOnErrorRule;
import org.eclipse.cdt.make.internal.core.makefile.gnu.Else;
import org.eclipse.cdt.make.internal.core.makefile.gnu.Endef;
import org.eclipse.cdt.make.internal.core.makefile.gnu.Endif;
import org.eclipse.cdt.make.internal.core.makefile.gnu.ExportAllVariablesRule;
import org.eclipse.cdt.make.internal.core.makefile.gnu.ExportVariable;
import org.eclipse.cdt.make.internal.core.makefile.gnu.GNUMakefileUtil;
import org.eclipse.cdt.make.internal.core.makefile.gnu.GNUTargetRule;
import org.eclipse.cdt.make.internal.core.makefile.gnu.Ifdef;
import org.eclipse.cdt.make.internal.core.makefile.gnu.Ifeq;
import org.eclipse.cdt.make.internal.core.makefile.gnu.Ifndef;
import org.eclipse.cdt.make.internal.core.makefile.gnu.Ifneq;
import org.eclipse.cdt.make.internal.core.makefile.gnu.Include;
import org.eclipse.cdt.make.internal.core.makefile.gnu.IntermediateRule;
import org.eclipse.cdt.make.internal.core.makefile.gnu.LowResolutionTimeRule;
import org.eclipse.cdt.make.internal.core.makefile.gnu.NotParallelRule;
import org.eclipse.cdt.make.internal.core.makefile.gnu.OverrideDefine;
import org.eclipse.cdt.make.internal.core.makefile.gnu.OverrideVariable;
import org.eclipse.cdt.make.internal.core.makefile.gnu.PhonyRule;
import org.eclipse.cdt.make.internal.core.makefile.gnu.SecondaryRule;
import org.eclipse.cdt.make.internal.core.makefile.gnu.StaticTargetRule;
import org.eclipse.cdt.make.internal.core.makefile.gnu.TargetVariable;
import org.eclipse.cdt.make.internal.core.makefile.gnu.UnExport;
import org.eclipse.cdt.make.internal.core.makefile.gnu.VPath;
import org.eclipse.cdt.make.internal.core.makefile.gnu.VariableDefinition;
import org.eclipse.cdt.make.internal.core.makefile.posix.PosixMakefileUtil;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;

public class GNUMakefile
extends AbstractMakefile
implements IGNUMakefile {
    public static String PATH_SEPARATOR = System.getProperty("path.separator", ":");
    public static String FILE_SEPARATOR = System.getProperty("file.separator", "/");
    String[] includeDirectories = new String[0];
    IDirective[] builtins = null;
    private IMakefileReaderProvider makefileReaderProvider;

    public GNUMakefile() {
        super(null);
    }

    public IMakefileReaderProvider getMakefileReaderProvider() {
        return this.makefileReaderProvider;
    }

    public void parse(String filePath, Reader reader) throws IOException {
        this.parse(URIUtil.toURI((String)filePath), new MakefileReader(reader));
    }

    public void parse(URI fileURI, IMakefileReaderProvider makefileReaderProvider) throws IOException {
        MakefileReader reader;
        this.makefileReaderProvider = makefileReaderProvider;
        if (makefileReaderProvider == null) {
            try {
                reader = new MakefileReader(new InputStreamReader(EFS.getStore((URI)fileURI).openInputStream(0, null)));
            }
            catch (CoreException e) {
                MakeCorePlugin.log(e);
                throw new IOException(e.getMessage());
            }
        } else {
            reader = new MakefileReader(makefileReaderProvider.getReader(fileURI));
        }
        this.parse(fileURI, reader);
    }

    public void parse(URI filePath, Reader reader) throws IOException {
        this.parse(filePath, new MakefileReader(reader));
    }

    protected void parse(URI fileURI, MakefileReader reader) throws IOException {
        String line;
        Rule[] rules = null;
        Stack<Directive> conditions = new Stack<Directive>();
        Stack<VariableDefinition> defines = new Stack<VariableDefinition>();
        int startLine = 0;
        int endLine = 0;
        this.clearDirectives();
        this.setFileURI(fileURI);
        while ((line = reader.readLine()) != null) {
            int i;
            int i2;
            int pound;
            startLine = endLine + 1;
            endLine = reader.getLineNumber();
            if (GNUMakefileUtil.isEndef(line)) {
                if (!defines.empty()) {
                    VariableDefinition def = (VariableDefinition)defines.pop();
                    def.setEndLine(endLine);
                }
                Endef endef = new Endef(this);
                endef.setLines(startLine, endLine);
                this.addDirective(conditions, endef);
                continue;
            }
            if (GNUMakefileUtil.isDefine(line)) {
                VariableDefinition def = this.parseVariableDefinition(line);
                def.setLines(startLine, endLine);
                this.addDirective(conditions, def);
                defines.push(def);
                continue;
            }
            if (GNUMakefileUtil.isOverrideDefine(line)) {
                VariableDefinition oDef = this.parseVariableDefinition(line);
                oDef.setLines(startLine, endLine);
                this.addDirective(conditions, oDef);
                defines.push(oDef);
                continue;
            }
            if (!defines.empty()) {
                VariableDefinition def = (VariableDefinition)defines.peek();
                StringBuffer sb = def.getValue();
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(line);
                continue;
            }
            if (PosixMakefileUtil.isCommand(line)) {
                Command cmd = new Command(this, line);
                cmd.setLines(startLine, endLine);
                if (!conditions.empty()) {
                    this.addDirective(conditions, cmd);
                    continue;
                }
                if (rules != null) {
                    int i3 = 0;
                    while (i3 < rules.length) {
                        rules[i3].addDirective(cmd);
                        rules[i3].setEndLine(endLine);
                        ++i3;
                    }
                    continue;
                }
            }
            if ((pound = Util.indexOfComment(line)) != -1) {
                Comment cmt = new Comment(this, line.substring(pound + 1));
                cmt.setLines(startLine, endLine);
                if (rules != null) {
                    i2 = 0;
                    while (i2 < rules.length) {
                        rules[i2].addDirective(cmt);
                        rules[i2].setEndLine(endLine);
                        ++i2;
                    }
                } else {
                    this.addDirective(conditions, cmt);
                }
                line = line.substring(0, pound);
                if (Util.isEmptyLine(line)) continue;
            }
            if (Util.isEmptyLine(line)) {
                EmptyLine empty = new EmptyLine(this);
                empty.setLines(startLine, endLine);
                if (rules != null) {
                    i2 = 0;
                    while (i2 < rules.length) {
                        rules[i2].addDirective(empty);
                        rules[i2].setEndLine(endLine);
                        ++i2;
                    }
                    continue;
                }
                this.addDirective(conditions, empty);
                continue;
            }
            rules = null;
            if (GNUMakefileUtil.isElse(line)) {
                Conditional elseDirective = this.parseConditional(line);
                elseDirective.setLines(startLine, endLine);
                if (!conditions.empty()) {
                    Conditional cond = (Conditional)conditions.pop();
                    cond.setEndLine(endLine - 1);
                }
                this.addDirective(conditions, elseDirective);
                conditions.push(elseDirective);
                continue;
            }
            if (GNUMakefileUtil.isEndif(line)) {
                Endif endif = new Endif(this);
                endif.setLines(startLine, endLine);
                if (!conditions.empty()) {
                    Conditional cond = (Conditional)conditions.pop();
                    cond.setEndLine(endLine);
                }
                this.addDirective(conditions, endif);
                continue;
            }
            Directive directive = this.processConditions(line);
            if (directive != null) {
                directive.setLines(startLine, endLine);
                this.addDirective(conditions, directive);
                conditions.push(directive);
                continue;
            }
            directive = this.processGNUDirectives(line);
            if (directive != null) {
                directive.setLines(startLine, endLine);
                this.addDirective(conditions, directive);
                continue;
            }
            SpecialRule special = this.processSpecialRules(line);
            if (special != null) {
                rules = new Rule[]{special};
                special.setLines(startLine, endLine);
                this.addDirective(conditions, special);
                continue;
            }
            if (PosixMakefileUtil.isInferenceRule(line)) {
                InferenceRule irule = this.parseInferenceRule(line);
                irule.setLines(startLine, endLine);
                this.addDirective(conditions, irule);
                rules = new Rule[]{irule};
                continue;
            }
            if (GNUMakefileUtil.isVariableDefinition(line)) {
                VariableDefinition vd = this.parseVariableDefinition(line);
                vd.setLines(startLine, endLine);
                this.addDirective(conditions, vd);
                if (!vd.isTargetSpecific()) continue;
            }
            if (GNUMakefileUtil.isStaticTargetRule(line)) {
                StaticTargetRule[] srules = this.parseStaticTargetRule(line);
                i = 0;
                while (i < srules.length) {
                    srules[i].setLines(startLine, endLine);
                    this.addDirective(conditions, srules[i]);
                    ++i;
                }
                rules = srules;
                continue;
            }
            if (GNUMakefileUtil.isGNUTargetRule(line)) {
                GNUTargetRule[] trules = this.parseGNUTargetRules(line);
                i = 0;
                while (i < trules.length) {
                    trules[i].setLines(startLine, endLine);
                    this.addDirective(conditions, trules[i]);
                    ++i;
                }
                rules = trules;
                continue;
            }
            BadDirective stmt = new BadDirective(this, line);
            stmt.setLines(startLine, endLine);
            this.addDirective(conditions, stmt);
        }
        this.setLines(1, endLine);
    }

    private void addDirective(Stack conditions, Directive directive) {
        if (conditions.empty()) {
            this.addDirective(directive);
        } else {
            Conditional cond = (Conditional)conditions.peek();
            cond.addDirective(directive);
            cond.setEndLine(directive.getEndLine());
        }
    }

    protected Conditional processConditions(String line) {
        Conditional stmt = null;
        if (GNUMakefileUtil.isIfdef(line)) {
            stmt = this.parseConditional(line);
        } else if (GNUMakefileUtil.isIfndef(line)) {
            stmt = this.parseConditional(line);
        } else if (GNUMakefileUtil.isIfeq(line)) {
            stmt = this.parseConditional(line);
        } else if (GNUMakefileUtil.isIfneq(line)) {
            stmt = this.parseConditional(line);
        }
        return stmt;
    }

    protected Directive processGNUDirectives(String line) {
        Directive stmt = null;
        if (GNUMakefileUtil.isUnExport(line)) {
            stmt = this.parseUnExport(line);
        } else if (GNUMakefileUtil.isVPath(line)) {
            stmt = this.parseVPath(line);
        } else if (GNUMakefileUtil.isInclude(line)) {
            stmt = this.parseInclude(line);
        }
        return stmt;
    }

    protected SpecialRule processSpecialRules(String line) {
        SpecialRule stmt = null;
        if (PosixMakefileUtil.isIgnoreRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (PosixMakefileUtil.isPosixRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (PosixMakefileUtil.isPreciousRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (PosixMakefileUtil.isSilentRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (PosixMakefileUtil.isSuffixesRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (PosixMakefileUtil.isDefaultRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (PosixMakefileUtil.isSccsGetRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (GNUMakefileUtil.isPhonyRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (GNUMakefileUtil.isIntermediateRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (GNUMakefileUtil.isSecondaryRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (GNUMakefileUtil.isDeleteOnErrorRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (GNUMakefileUtil.isLowResolutionTimeRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (GNUMakefileUtil.isExportAllVariablesRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (GNUMakefileUtil.isNotParallelRule(line)) {
            stmt = this.parseSpecialRule(line);
        }
        return stmt;
    }

    protected SpecialRule parseSpecialRule(String line) {
        line = line.trim();
        String keyword = null;
        String[] reqs = null;
        SpecialRule special = null;
        int index = Util.indexOf(line, ':');
        if (index != -1) {
            keyword = line.substring(0, index).trim();
            String req = line.substring(index + 1);
            reqs = PosixMakefileUtil.findPrerequisites(req);
        } else {
            keyword = line;
            reqs = new String[]{};
        }
        if (keyword.equals(".IGNORE")) {
            special = new IgnoreRule((Directive)this, reqs);
        } else if (keyword.equals(".POSIX")) {
            special = new PosixRule(this);
        } else if (keyword.equals(".PRECIOUS")) {
            special = new PreciousRule((Directive)this, reqs);
        } else if (keyword.equals(".SILENT")) {
            special = new SilentRule((Directive)this, reqs);
        } else if (keyword.equals(".SUFFIXES")) {
            special = new SuffixesRule((Directive)this, reqs);
        } else if (keyword.equals(".DEFAULT")) {
            special = new DefaultRule((Directive)this, new Command[0]);
        } else if (keyword.equals(".SCCS_GET")) {
            special = new SccsGetRule((Directive)this, new Command[0]);
        } else if (keyword.equals(".PHONY")) {
            special = new PhonyRule((Directive)this, reqs);
        } else if (keyword.equals(".INTERMEDIATE")) {
            special = new IntermediateRule((Directive)this, reqs);
        } else if (keyword.equals(".SECONDARY")) {
            special = new SecondaryRule((Directive)this, reqs);
        } else if (keyword.equals(".DELETE_ON_ERROR")) {
            special = new DeleteOnErrorRule((Directive)this, reqs);
        } else if (keyword.equals(".LOW_RESOLUTION_TIME")) {
            special = new LowResolutionTimeRule((Directive)this, reqs);
        } else if (keyword.equals(".EXPORT_ALL_VARIABLES")) {
            special = new ExportAllVariablesRule((Directive)this, reqs);
        } else if (keyword.equals(".NOTPARALLEL")) {
            special = new NotParallelRule((Directive)this, reqs);
        }
        return special;
    }

    protected Conditional parseConditional(String line) {
        Conditional condition = null;
        line = line.trim();
        String keyword = null;
        int i = 0;
        while (i < line.length()) {
            if (Util.isSpace(line.charAt(i))) {
                keyword = line.substring(0, i);
                line = line.substring(i).trim();
                break;
            }
            ++i;
        }
        if (keyword == null) {
            keyword = line;
        }
        if (keyword.equals("ifdef")) {
            condition = new Ifdef(this, line);
        } else if (keyword.equals("ifndef")) {
            condition = new Ifndef(this, line);
        } else if (keyword.equals("ifeq")) {
            condition = new Ifeq(this, line);
        } else if (keyword.equals("ifneq")) {
            condition = new Ifneq(this, line);
        } else if (keyword.equals("else")) {
            condition = new Else(this);
        }
        return condition;
    }

    protected Include parseInclude(String line) {
        String[] filenames;
        StringTokenizer st = new StringTokenizer(line);
        int count = st.countTokens();
        if (count > 0) {
            filenames = new String[count - 1];
            int i = 0;
            while (i < count) {
                if (i == 0) {
                    st.nextToken();
                } else {
                    filenames[i - 1] = st.nextToken();
                }
                ++i;
            }
        } else {
            filenames = new String[]{};
        }
        return new Include(this, filenames, this.getIncludeDirectories());
    }

    protected VPath parseVPath(String line) {
        String pattern = null;
        StringTokenizer st = new StringTokenizer(line);
        int count = st.countTokens();
        ArrayList<String> dirs = new ArrayList<String>(count);
        if (count > 0) {
            int i = 0;
            while (i < count) {
                if (count == 0) {
                    st.nextToken();
                } else if (count == 1) {
                    pattern = st.nextToken();
                } else if (count == 3) {
                    String delim = " \t\n\r\f" + PATH_SEPARATOR;
                    dirs.add(st.nextToken(delim));
                } else {
                    dirs.add(st.nextToken());
                }
                ++i;
            }
        }
        String[] directories = dirs.toArray(new String[0]);
        if (pattern == null) {
            pattern = new String();
        }
        return new VPath(this, pattern, directories);
    }

    protected UnExport parseUnExport(String line) {
        int i = 0;
        while (i < line.length()) {
            if (Util.isSpace(line.charAt(i))) {
                line = line.substring(i).trim();
                break;
            }
            ++i;
        }
        return new UnExport(this, line);
    }

    protected GNUTargetRule[] parseGNUTargetRules(String line) {
        String[] orderReqs;
        String[] normalReqs;
        String[] targetNames;
        String cmd = null;
        boolean doubleColon = false;
        int index = Util.indexOf(line, ':');
        if (index != -1) {
            int semicolon;
            String target = line.substring(0, index);
            targetNames = PosixMakefileUtil.findTargets(target.trim());
            String req = line.substring(index + 1);
            doubleColon = req.startsWith(":");
            if (doubleColon) {
                req = req.substring(1);
            }
            if ((semicolon = Util.indexOf(req, ';')) != -1) {
                cmd = req.substring(semicolon + 1);
                req = req.substring(0, semicolon);
            }
            String normalReq = null;
            String orderReq = null;
            int pipe = Util.indexOf(req, '|');
            if (pipe != -1) {
                normalReq = req.substring(0, pipe);
                orderReq = req.substring(pipe + 1);
            } else {
                normalReq = req;
                orderReq = "";
            }
            normalReqs = PosixMakefileUtil.findPrerequisites(normalReq.trim());
            orderReqs = PosixMakefileUtil.findPrerequisites(orderReq.trim());
        } else {
            targetNames = PosixMakefileUtil.findTargets(line);
            normalReqs = new String[]{};
            orderReqs = new String[]{};
        }
        GNUTargetRule[] rules = new GNUTargetRule[targetNames.length];
        int i = 0;
        while (i < targetNames.length) {
            rules[i] = new GNUTargetRule(this, new Target(targetNames[i]), doubleColon, normalReqs, orderReqs, new Command[0]);
            if (cmd != null) {
                rules[i].addDirective(new Command(this, cmd));
            }
            ++i;
        }
        return rules;
    }

    protected VariableDefinition parseVariableDefinition(String line) {
        String name;
        int index;
        int i;
        line = line.trim();
        char type = '\u0000';
        boolean isDefine = false;
        boolean isOverride = false;
        boolean isTargetVariable = false;
        boolean isExport = false;
        String targetName = "";
        StringBuffer value = new StringBuffer();
        isTargetVariable = GNUMakefileUtil.isTargetVariable(line);
        if (isTargetVariable) {
            int colon = Util.indexOf(line, ':');
            if (colon != -1) {
                targetName = line.substring(0, colon).trim();
                line = line.substring(colon + 1).trim();
            } else {
                targetName = "";
            }
        }
        if (GNUMakefileUtil.isOverride(line)) {
            isOverride = true;
            i = 0;
            while (i < line.length()) {
                if (Util.isSpace(line.charAt(i))) {
                    line = line.substring(i).trim();
                    break;
                }
                ++i;
            }
        }
        if (GNUMakefileUtil.isDefine(line)) {
            isDefine = true;
            i = 0;
            while (i < line.length()) {
                if (Util.isSpace(line.charAt(i))) {
                    line = line.substring(i).trim();
                    break;
                }
                ++i;
            }
        }
        if (GNUMakefileUtil.isExport(line)) {
            isExport = true;
            i = 0;
            while (i < line.length()) {
                if (Util.isSpace(line.charAt(i))) {
                    line = line.substring(i).trim();
                    break;
                }
                ++i;
            }
        }
        if ((index = line.indexOf(61)) != -1) {
            int separator = index;
            if (index > 0) {
                type = line.charAt(index - 1);
                if (type == ':' || type == '+' || type == '?') {
                    separator = index - 1;
                } else {
                    type = '\u0000';
                }
            }
            name = line.substring(0, separator).trim();
            value.append(line.substring(index + 1).trim());
        } else {
            name = line;
        }
        VariableDefinition vd = isTargetVariable ? new TargetVariable(this, targetName, name, value, isOverride, type) : (isOverride && isDefine ? new OverrideDefine(this, name, value) : (isDefine ? new DefineVariable(this, name, value) : (isOverride ? new OverrideVariable(this, name, value, type) : (isExport ? new ExportVariable(this, name, value, type) : new VariableDefinition(this, name, value, type)))));
        return vd;
    }

    protected StaticTargetRule[] parseStaticTargetRule(String line) {
        String[] prereqPatterns;
        String targetPattern;
        String[] targets;
        int colon = Util.indexOf(line, ':');
        if (colon > 1) {
            String targetLine = line.substring(0, colon).trim();
            targets = PosixMakefileUtil.findTargets(targetLine);
            if ((colon = Util.indexOf(line = line.substring(colon + 1), ':')) != -1) {
                targetPattern = line.substring(0, colon).trim();
                line = line.substring(colon + 1);
                StringTokenizer st = new StringTokenizer(line);
                int count = st.countTokens();
                prereqPatterns = new String[count];
                int i = 0;
                while (i < count) {
                    prereqPatterns[i] = st.nextToken();
                    ++i;
                }
            } else {
                targetPattern = "";
                prereqPatterns = new String[]{};
            }
        } else {
            targets = new String[]{};
            targetPattern = "";
            prereqPatterns = new String[]{};
        }
        StaticTargetRule[] staticRules = new StaticTargetRule[targets.length];
        int i = 0;
        while (i < targets.length) {
            staticRules[i] = new StaticTargetRule(this, new Target(targets[i]), targetPattern, prereqPatterns, new Command[0]);
            ++i;
        }
        return staticRules;
    }

    protected InferenceRule parseInferenceRule(String line) {
        int index = Util.indexOf(line, ':');
        String tgt = index != -1 ? line.substring(0, index) : line;
        return new InferenceRule(this, new Target(tgt));
    }

    public IDirective[] getDirectives(boolean expand) {
        if (!expand) {
            return this.getDirectives();
        }
        IDirective[] dirs = this.getDirectives();
        ArrayList<IDirective> list = new ArrayList<IDirective>(Arrays.asList(dirs));
        int i = 0;
        while (i < dirs.length) {
            if (dirs[i] instanceof Include) {
                Include include = (Include)dirs[i];
                IDirective[] includedMakefiles = include.getDirectives();
                int j = 0;
                while (j < includedMakefiles.length) {
                    IMakefile includedMakefile = (IMakefile)includedMakefiles[j];
                    list.addAll(Arrays.asList(includedMakefile.getDirectives()));
                    ++j;
                }
            }
            ++i;
        }
        return list.toArray(new IDirective[list.size()]);
    }

    public IDirective[] getBuiltins() {
        if (this.builtins == null) {
            String location = "builtin" + File.separator + "gnu.mk";
            if (MakeCorePlugin.getDefault() != null) {
                try {
                    InputStream stream = FileLocator.openStream((Bundle)MakeCorePlugin.getDefault().getBundle(), (IPath)new Path(location), (boolean)false);
                    GNUMakefile gnu = new GNUMakefile();
                    URL url = FileLocator.find((Bundle)MakeCorePlugin.getDefault().getBundle(), (IPath)new Path(location), null);
                    gnu.parse(url.toURI(), (Reader)new InputStreamReader(stream));
                    this.builtins = gnu.getDirectives();
                    int i = 0;
                    while (i < this.builtins.length) {
                        if (this.builtins[i] instanceof MacroDefinition) {
                            ((MacroDefinition)this.builtins[i]).setFromDefault(true);
                        }
                        ++i;
                    }
                }
                catch (IOException e) {
                    MakeCorePlugin.log(e);
                }
                catch (URISyntaxException e) {
                    MakeCorePlugin.log(e);
                }
            }
            if (this.builtins == null) {
                this.builtins = new IDirective[0];
            }
        }
        return this.builtins;
    }

    public void setIncludeDirectories(String[] dirs) {
        this.includeDirectories = dirs;
    }

    public String[] getIncludeDirectories() {
        return this.includeDirectories;
    }
}

