/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.dataprovider;

import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.extension.impl.CDataFactory;
import org.eclipse.cdt.core.settings.model.extension.impl.CDefaultConfigurationDataProvider;
import org.eclipse.cdt.core.settings.model.util.CDataSerializer;
import org.eclipse.cdt.core.settings.model.util.UserAndDiscoveredEntryDataSerializer;
import org.eclipse.cdt.make.internal.core.dataprovider.MakeCDataFactory;
import org.eclipse.cdt.make.internal.core.dataprovider.MakeDiscoveredInfoProcessor;
import org.eclipse.cdt.make.internal.core.scannerconfig.CDataDiscoveredInfoCalculator;
import org.eclipse.cdt.make.internal.core.scannerconfig.CDataDiscoveredInfoProcessor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class MakeConfigurationDataProvider
extends CDefaultConfigurationDataProvider {
    private static final String STORAGE_ID = "makeConfigDataProvider";

    protected CDataFactory getDataFactory() {
        return MakeCDataFactory.getDefault();
    }

    protected CDataSerializer getDataSerializer() {
        return UserAndDiscoveredEntryDataSerializer.getDefault();
    }

    protected String getStorageId() {
        return STORAGE_ID;
    }

    public CConfigurationData applyConfiguration(ICConfigurationDescription des, ICConfigurationDescription baseDescription, CConfigurationData base, IProgressMonitor monitor) throws CoreException {
        CConfigurationData result = super.applyConfiguration(des, baseDescription, base, monitor);
        if (!des.isPreferenceConfiguration()) {
            this.updateDiscoveredInfo(des.getProjectDescription().getProject(), result);
        }
        return result;
    }

    public CConfigurationData loadConfiguration(ICConfigurationDescription des, IProgressMonitor monitor) throws CoreException {
        CConfigurationData result = super.loadConfiguration(des, monitor);
        if (!des.isPreferenceConfiguration()) {
            this.updateDiscoveredInfo(des.getProjectDescription().getProject(), result);
        }
        return result;
    }

    protected void updateDiscoveredInfo(IProject project, CConfigurationData cfgData) {
        MakeConfigurationDataProvider.updateDiscoveredInfo(project, cfgData, this.getInfoCalculator(), this.getInfoProcessor());
    }

    public static void updateDiscoveredInfo(IProject project, CConfigurationData cfgData, CDataDiscoveredInfoCalculator calculator, CDataDiscoveredInfoProcessor processor) {
        CDataDiscoveredInfoCalculator.DiscoveredSettingInfo dsInfo = calculator.getSettingInfos(project, cfgData);
        processor.applyDiscoveredInfo(cfgData, dsInfo);
    }

    protected CDataDiscoveredInfoProcessor getInfoProcessor() {
        return MakeDiscoveredInfoProcessor.getDefault();
    }

    protected CDataDiscoveredInfoCalculator getInfoCalculator() {
        return CDataDiscoveredInfoCalculator.getDefault();
    }
}

