/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.tool.stk600.ui;

import com.atmel.avr32.target.ITarget;
import com.atmel.avr32.tool.stk600.model.CardConfiguration;
import com.atmel.avr32.tool.stk600.model.CardDatabase;
import com.atmel.avr32.tool.stk600.model.McuCard;
import com.atmel.avr32.tool.stk600.model.RoutingCard;
import com.atmel.avr32.tool.stk600.ui.PartTreeContentProvider;
import com.atmel.avr32.tool.stk600.ui.Stk600PartProvider;
import com.atmel.avr32.tool.stk600.ui.Stk600Plugin;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class Stk600PartSelectionDialog
extends TrayDialog {
    private Stk600PartProvider fPartProvider;
    private ITarget fTarget;
    private CardConfiguration[] fCardConfigurations;
    private int fCurrentCardConfigurationIndex;
    private Label fPicture;
    private Label fSocketCardLabel;
    private Label fRoutingCardLabel;
    private Text fSocketCard;
    private Text fRoutingCard;
    private String fSelectedPart;
    private Label fNumAlternative;
    private TreeViewer fTreeViewer;
    private boolean fRestrictedToDetectedCard;
    private Button fPreviousAlternativeButton;
    private Button fNextAlternativeButton;
    private Button fLimitMcusButton;
    private Button fAllMcusButton;

    public Stk600PartSelectionDialog(Shell shell, Stk600PartProvider provider, ITarget target) {
        super(shell);
        this.fPartProvider = provider;
        this.fTarget = target;
    }

    public String getSelectedPart() {
        return this.fSelectedPart;
    }

    protected void cancelPressed() {
        super.cancelPressed();
        this.fSelectedPart = "";
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 2;
        this.addMcuTree(composite);
        this.addStk600Pane(composite);
        this.addDetectButton(composite);
        this.widenMcuSelection();
        this.fTreeViewer.expandAll();
        this.fTreeViewer.collapseAll();
        this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)this.fTarget.getCpu()));
        this.fTreeViewer.setExpandedState((Object)this.fTarget.getCpu(), true);
        this.disableStk600PaneControls();
        return composite;
    }

    private void disableStk600PaneControls() {
        this.fPicture.setImage(this.getUnsupportedCardImage());
        this.fSocketCardLabel.setText("");
        this.fRoutingCardLabel.setText("");
        this.fSocketCard.setText("No MCU selected");
        this.fRoutingCard.setText("No MCU selected");
        this.fSocketCard.setEnabled(false);
        this.fRoutingCard.setEnabled(false);
        this.fNumAlternative.setText("");
        this.fPreviousAlternativeButton.setEnabled(false);
        this.fNextAlternativeButton.setEnabled(false);
    }

    protected boolean isResizable() {
        return true;
    }

    private void addMcuTree(Composite parent) {
        Group group = new Group(parent, 0);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 130;
        group.setLayoutData((Object)gd);
        group.setText("&Supported MCUs:");
        group.setLayout((Layout)new FillLayout(256));
        this.fTreeViewer = new TreeViewer((Composite)group, 4);
        PartTreeContentProvider provider = new PartTreeContentProvider();
        this.fTreeViewer.setContentProvider((IContentProvider)provider);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeSelection selection = (TreeSelection)event.getSelection();
                Stk600PartSelectionDialog.this.updateStk600PaneForSelection(selection.getFirstElement());
            }
        });
        this.fTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (Stk600PartSelectionDialog.this.fSelectedPart != null) {
                    Stk600PartSelectionDialog.this.okPressed();
                }
            }
        });
    }

    private void addStk600Pane(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 128, true, true, 1, 1));
        this.fPicture = new Label(composite, 0);
        this.fPicture.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.fSocketCardLabel = new Label(composite, 0);
        this.fSocketCardLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fSocketCard = new Text(composite, 2056);
        int cardFieldWidth = 120;
        this.fSocketCard.setLayoutData((Object)new GridData(cardFieldWidth, -1));
        this.fRoutingCardLabel = new Label(composite, 0);
        this.fRoutingCardLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        this.fRoutingCard = new Text(composite, 2056);
        this.fRoutingCard.setLayoutData((Object)new GridData(cardFieldWidth, -1));
        this.fNumAlternative = new Label(composite, 16384);
        this.fNumAlternative.setLayoutData((Object)new GridData(4, -1, true, false, 2, 1));
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayoutData((Object)new GridData(0x1000000, -1, true, false, 2, 1));
        buttonComposite.setLayout((Layout)new FillLayout());
        this.fPreviousAlternativeButton = new Button(buttonComposite, 8);
        this.fPreviousAlternativeButton.setText("&Previous");
        this.fNextAlternativeButton = new Button(buttonComposite, 8);
        this.fNextAlternativeButton.setText("&Next");
        this.fPreviousAlternativeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Stk600PartSelectionDialog stk600PartSelectionDialog = Stk600PartSelectionDialog.this;
                stk600PartSelectionDialog.fCurrentCardConfigurationIndex = stk600PartSelectionDialog.fCurrentCardConfigurationIndex - 1;
                if (Stk600PartSelectionDialog.this.fCurrentCardConfigurationIndex == 0) {
                    Stk600PartSelectionDialog.this.fPreviousAlternativeButton.setEnabled(false);
                    Stk600PartSelectionDialog.this.fNextAlternativeButton.setEnabled(Stk600PartSelectionDialog.this.fCurrentCardConfigurationIndex < Stk600PartSelectionDialog.this.fCardConfigurations.length);
                }
                Stk600PartSelectionDialog.this.displayCurrentCardConfiguration();
            }
        });
        this.fNextAlternativeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Stk600PartSelectionDialog stk600PartSelectionDialog = Stk600PartSelectionDialog.this;
                stk600PartSelectionDialog.fCurrentCardConfigurationIndex = stk600PartSelectionDialog.fCurrentCardConfigurationIndex + 1;
                if (Stk600PartSelectionDialog.this.fCurrentCardConfigurationIndex == Stk600PartSelectionDialog.this.fCardConfigurations.length - 1) {
                    Stk600PartSelectionDialog.this.fNextAlternativeButton.setEnabled(false);
                    Stk600PartSelectionDialog.this.fPreviousAlternativeButton.setEnabled(Stk600PartSelectionDialog.this.fCurrentCardConfigurationIndex > 0);
                }
                Stk600PartSelectionDialog.this.displayCurrentCardConfiguration();
            }
        });
        this.fPreviousAlternativeButton.setEnabled(false);
        this.fNextAlternativeButton.setEnabled(false);
    }

    private void addDetectButton(Composite parent) {
        Group group = new Group(parent, 0);
        GridData gridData = new GridData(4, 4, true, false, 2, 1);
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText("Display MCUs");
        this.fAllMcusButton = new Button((Composite)group, 16);
        this.fAllMcusButton.setText("&All MCUs supported by STK600");
        this.fAllMcusButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Stk600PartSelectionDialog.this.widenMcuSelection();
            }
        });
        this.fLimitMcusButton = new Button((Composite)group, 16);
        this.fLimitMcusButton.setText("&Only MCUs supported by mounted cards");
        this.fLimitMcusButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Stk600PartSelectionDialog.this.detectAndLimitMcuSelection();
            }
        });
        this.fAllMcusButton.setSelection(true);
    }

    protected void updateStk600PaneForMcu(String mcu) {
        this.fSelectedPart = mcu;
        this.fPreviousAlternativeButton.setEnabled(false);
        this.fNextAlternativeButton.setEnabled(false);
        if (this.fRestrictedToDetectedCard) {
            return;
        }
        this.fCardConfigurations = this.getCardConfigurations(mcu);
        if (this.fCardConfigurations.length == 0) {
            this.displayUnsupportedMcu();
        } else {
            if (this.fCardConfigurations.length > 1) {
                this.fNextAlternativeButton.setEnabled(true);
            }
            this.fCurrentCardConfigurationIndex = 0;
            this.displayCurrentCardConfiguration();
        }
    }

    private void displayCardConfiguration(CardConfiguration cardConfiguration) {
        if (cardConfiguration instanceof McuCard) {
            this.displayMcuCard((McuCard)cardConfiguration);
            this.updateNumAlternative();
        } else if (cardConfiguration instanceof RoutingCard) {
            this.displayRoutingCard((RoutingCard)cardConfiguration);
            this.updateNumAlternative();
        } else {
            this.displayUnsupportedMcu();
        }
    }

    private void updateNumAlternative() {
        if (!this.fRestrictedToDetectedCard) {
            this.fNumAlternative.setText("Displaying alternative " + String.valueOf(this.fCurrentCardConfigurationIndex + 1) + " of " + String.valueOf(this.fCardConfigurations.length) + ".");
        }
    }

    private void displayRoutingCard(RoutingCard routingCard) {
        this.fPicture.setImage(this.getRoutingCardImage());
        this.fSocketCardLabel.setText("Socket card:");
        this.fRoutingCard.setText(routingCard.getRcName());
        this.fRoutingCardLabel.setText("Routing card:");
        this.fSocketCard.setText(routingCard.getScName());
        this.fRoutingCard.setEnabled(true);
        this.fSocketCard.setEnabled(true);
    }

    private void displayMcuCard(McuCard mcuCard) {
        this.fPicture.setImage(this.getMcuCardImage());
        this.fRoutingCardLabel.setText("");
        this.fRoutingCard.setText("");
        this.fSocketCardLabel.setText("MCU card:");
        this.fSocketCard.setText(mcuCard.getName());
        this.fSocketCard.setEnabled(true);
    }

    private void displayUnsupportedMcu() {
        this.fRoutingCardLabel.setText("");
        this.fRoutingCard.setText("Unsupported MCU");
        this.fSocketCardLabel.setText("");
        this.fSocketCard.setText("Unsupported MCU");
        this.fPicture.setImage(this.getUnsupportedCardImage());
        this.fNumAlternative.setText("");
        this.fPreviousAlternativeButton.setEnabled(false);
        this.fNextAlternativeButton.setEnabled(false);
    }

    private CardConfiguration[] getCardConfigurations(String mcu) {
        return CardDatabase.getDefault().getCardConfigurations(mcu);
    }

    private void displayCurrentCardConfiguration() {
        this.displayCardConfiguration(this.fCardConfigurations[this.fCurrentCardConfigurationIndex]);
    }

    private Image getRoutingCardImage() {
        return this.getCardImage("IMAGE_ROUTING_CARD");
    }

    private Image getMcuCardImage() {
        return this.getCardImage("IMAGE_MCU_CARD");
    }

    private Image getUnsupportedCardImage() {
        return this.getCardImage("IMAGE_UNSUPPORTED_CARD");
    }

    private Image getCardImage(String filename) {
        return Stk600Plugin.getDefault().getImageRegistry().get(filename);
    }

    protected void detectAndLimitMcuSelection() {
        int[] cards = CardDatabase.getDefault().detectCards(this.fTarget);
        if (cards.length == 0) {
            this.fAllMcusButton.setSelection(true);
            this.fLimitMcusButton.setSelection(false);
            return;
        }
        CardConfiguration cardConfig = CardDatabase.getDefault().getCardConfiguration(cards[0], cards[1]);
        if (cardConfig == null) {
            this.fAllMcusButton.setSelection(true);
            this.fLimitMcusButton.setSelection(false);
            MessageBox mb = new MessageBox(this.getShell(), 33);
            mb.setText("STK600");
            mb.setMessage("No MCUs was supported by the detected cards " + this.hex(cards[0]) + ", " + this.hex(cards[1]));
            mb.open();
            return;
        }
        this.fTreeViewer.setInput((Object)cardConfig);
        this.fRestrictedToDetectedCard = true;
        this.fNumAlternative.setText("");
        this.displayCardConfiguration(cardConfig);
    }

    private String hex(int card) {
        return String.format("0x%02x", card);
    }

    protected void widenMcuSelection() {
        this.fRestrictedToDetectedCard = false;
        this.updateStk600PaneForSelection(this.fTreeViewer.getSelection());
        this.fTreeViewer.setInput((Object)this.fPartProvider);
    }

    private void updateStk600PaneForSelection(Object selectedElement) {
        if (selectedElement instanceof String) {
            this.updateStk600PaneForMcu((String)selectedElement);
        } else {
            this.fSelectedPart = null;
            this.disableStk600PaneControls();
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("STK600 Device Selector");
    }
}

