/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.tool.stk600.model;

import com.atmel.avr32.board.stk600.targetboard.internal.Stk600NodeHandler;
import com.atmel.avr32.target.ITarget;
import com.atmel.avr32.target.ITargetInterface;
import com.atmel.avr32.target.TargetCommandStatus;
import com.atmel.avr32.target.TargetPlugin;
import com.atmel.avr32.tool.stk600.model.CardConfiguration;
import com.atmel.avr32.tool.stk600.model.McuCard;
import com.atmel.avr32.tool.stk600.model.RoutingCard;
import com.atmel.avr32.util.xml.IXMLNodeHandler;
import com.atmel.avr32.util.xml.SAXUtils;
import com.atmel.avr32.util.xml.StackedXMLHandler;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.Bundle;
import org.xml.sax.ContentHandler;

public class CardDatabase {
    private static final String CARD_ID_PATTERN = "^(.*)\\((0x([a-fA-F0-9])+)\\)$";
    private static CardDatabase database;
    private static final Pattern pattern;
    private static final String PLUGIN_ID = "com.atmel.avr32.board.stk600";
    private ArrayList<CardConfiguration> fCardConfigurations;

    static {
        pattern = Pattern.compile(CARD_ID_PATTERN);
    }

    public static CardDatabase getDefault() {
        if (database == null) {
            new CardDatabase();
        }
        return database;
    }

    private CardDatabase() {
        database = this;
        this.fCardConfigurations = new ArrayList();
        this.parseTargetBoardFile();
    }

    public void addCardConfiguration(CardConfiguration card) {
        this.fCardConfigurations.add(card);
    }

    private Integer decodeCardId(String line) {
        try {
            String value;
            Matcher matcher = pattern.matcher(line);
            if (matcher.matches() && (value = matcher.group(2)) != null) {
                return Integer.decode(value);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return 255;
    }

    public int[] detectCards(ITarget target) {
        ITargetInterface targetInterface = TargetPlugin.getDefault().getTargetInterface(target, false);
        targetInterface.setTarget(target);
        return this.detectCards(targetInterface);
    }

    public int[] detectCards(ITargetInterface targetInterface) {
        int scId = 255;
        int rcId = 255;
        TargetCommandStatus status = targetInterface.getStatus();
        if (status.isOK()) {
            String[] lines;
            String result = status.getResult();
            String[] stringArray = lines = this.splitLines(result);
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (line.startsWith("Mounted routing card:")) {
                    rcId = this.decodeCardId(line);
                } else if (line.startsWith("Mounted socket card:")) {
                    scId = this.decodeCardId(line);
                }
                ++n2;
            }
            return new int[]{scId, rcId};
        }
        StatusManager.getManager().handle((IStatus)status, 4);
        return new int[0];
    }

    public String[] getAllParts() {
        HashSet<String> parts = new HashSet<String>();
        for (CardConfiguration card : this.fCardConfigurations) {
            for (String mcu : card.getSupportedMcus()) {
                parts.add(mcu);
            }
        }
        return parts.toArray(new String[parts.size()]);
    }

    public CardConfiguration getCardConfiguration(int socketCardId, int routingCardId) {
        for (CardConfiguration card : this.fCardConfigurations) {
            if (!(routingCardId == 255 ? card instanceof McuCard && ((McuCard)card).getId() == socketCardId : card instanceof RoutingCard && ((RoutingCard)card).getRcId() == routingCardId && ((RoutingCard)card).getScId() == socketCardId)) continue;
            return card;
        }
        return null;
    }

    public CardConfiguration[] getCardConfigurations(String mcu) {
        ArrayList<CardConfiguration> supportedCards = new ArrayList<CardConfiguration>();
        for (CardConfiguration card : this.fCardConfigurations) {
            if (!card.supportsMcu(mcu)) continue;
            supportedCards.add(card);
        }
        return supportedCards.toArray(new CardConfiguration[supportedCards.size()]);
    }

    private void parseTargetBoardFile() {
        try {
            InputStream byteStream = FileLocator.openStream((Bundle)Platform.getBundle((String)PLUGIN_ID), (IPath)new Path("targetboard.xml"), (boolean)false);
            StackedXMLHandler handler = new StackedXMLHandler((IXMLNodeHandler)new Stk600NodeHandler(this));
            SAXUtils.parse((InputStream)byteStream, (ContentHandler)handler);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String[] splitLines(String lines) {
        return lines.split("\\n|\\r\\n|\\r");
    }
}

