/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.tool.stk600;

import com.atmel.avr32.target.ILimitingTargetAlgorithmAdapter;
import com.atmel.avr32.target.ITargetInterface;
import com.atmel.avr32.tool.stk600.model.CardDatabase;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class VoltageAdapter
implements ILimitingTargetAlgorithmAdapter {
    public float calculateValue(float value) {
        if ((double)value < 0.8) {
            return 0.0f;
        }
        if (value > 6.0f) {
            return 6.0f;
        }
        return (float)Math.round(value * 10.0f) / 10.0f;
    }

    public IStatus testValue(float value) {
        return Status.OK_STATUS;
    }

    public float getMaximumValue(String id, ITargetInterface targetInterface) {
        CardDatabase cardDatabase = CardDatabase.getDefault();
        int[] cards = cardDatabase.detectCards(targetInterface);
        if (cards.length > 0) {
            return cardDatabase.getCardConfiguration(cards[0], cards[1]).getVtgMax();
        }
        return 0.0f;
    }
}

