/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.board.stk600.targetboard.internal;

import com.atmel.avr32.tool.stk600.model.CardConfiguration;
import com.atmel.avr32.tool.stk600.model.CardDatabase;
import com.atmel.avr32.tool.stk600.model.McuCard;
import com.atmel.avr32.tool.stk600.model.RoutingCard;
import com.atmel.avr32.util.xml.IXMLNodeHandler;
import com.atmel.avr32.util.xml.XMLNodeHandler;
import java.util.ArrayList;
import org.xml.sax.SAXException;

public class RoutingCardNodeHandler
extends XMLNodeHandler {
    private CardDatabase fCardDatabase;
    private WorkingRoutingCard fRoutingCard;

    public RoutingCardNodeHandler(CardDatabase cardDatabase) {
        this.fCardDatabase = cardDatabase;
        this.fRoutingCard = new WorkingRoutingCard();
    }

    public void endElement(String name) throws SAXException {
        if (name.equalsIgnoreCase("card")) {
            this.fCardDatabase.addCardConfiguration(this.fRoutingCard.createCardConfiguration());
        }
    }

    public IXMLNodeHandler startElement(String name) throws SAXException {
        if (name.equalsIgnoreCase("rc_id")) {
            return new ValueNodeHandler(){

                public void endElement(String name) throws SAXException {
                    RoutingCardNodeHandler.this.fRoutingCard.setRcId(this.takeCharactersAsInteger());
                }
            };
        }
        if (name.equalsIgnoreCase("rc_name")) {
            return new ValueNodeHandler(){

                public void endElement(String name) throws SAXException {
                    RoutingCardNodeHandler.this.fRoutingCard.setRcName(this.takeCharacters());
                }
            };
        }
        if (name.equalsIgnoreCase("sc_id")) {
            return new ValueNodeHandler(){

                public void endElement(String name) throws SAXException {
                    RoutingCardNodeHandler.this.fRoutingCard.setScId(this.takeCharactersAsInteger());
                }
            };
        }
        if (name.equalsIgnoreCase("sc_name")) {
            return new ValueNodeHandler(){

                public void endElement(String name) throws SAXException {
                    RoutingCardNodeHandler.this.fRoutingCard.setScName(this.takeCharacters());
                }
            };
        }
        if (name.equalsIgnoreCase("vtg_max")) {
            return new ValueNodeHandler(){

                public void endElement(String name) throws SAXException {
                    RoutingCardNodeHandler.this.fRoutingCard.setVtgMax(this.takeCharactersAsFloat());
                }
            };
        }
        if (name.equalsIgnoreCase("name")) {
            return new ValueNodeHandler(){

                public void endElement(String name) throws SAXException {
                    RoutingCardNodeHandler.this.fRoutingCard.addTargetName(this.takeCharacters());
                }
            };
        }
        return this;
    }

    public abstract class ValueNodeHandler
    extends XMLNodeHandler {
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.addCharacters(new String(ch, start, length));
        }
    }

    public class WorkingRoutingCard {
        private int fRcId;
        private String fRcName;
        private int fScId;
        private String fScName;
        private float fVtgMax;
        private ArrayList<String> fTargetNames = new ArrayList();

        public void setRcId(int id) {
            this.fRcId = id;
        }

        public void setRcName(String name) {
            this.fRcName = name;
        }

        public void setScId(int id) {
            this.fScId = id;
        }

        public void setScName(String name) {
            this.fScName = name;
        }

        public void setVtgMax(float vtg) {
            this.fVtgMax = vtg;
        }

        public void addTargetName(String name) {
            this.fTargetNames.add(name);
        }

        public boolean isMcuCard() {
            return this.fRcId == 255;
        }

        public CardConfiguration createCardConfiguration() {
            CardConfiguration card = this.isMcuCard() ? new McuCard(this.fScId, this.fScName, this.fVtgMax) : new RoutingCard(this.fRcId, this.fRcName, this.fScId, this.fScName, this.fVtgMax);
            for (String name : this.fTargetNames) {
                if (!name.startsWith("AT32")) continue;
                card.addMcu(name.substring(4));
            }
            return card;
        }
    }
}

