/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.sf.uc3.bootloader.wizards.configurations.pages.group;

import com.atmel.avr32.sf.uc3.bootloader.core.Crc8;
import com.atmel.avr32.sf.uc3.bootloader.wizards.configurations.pages.group.Messages;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.PlatformUI;

public class UserPageConfigurationWord
extends Composite {
    private static final String HEX_PREFIX = "0x";
    int userPageConfWord;
    private Spinner spinnerIspCondLevel;
    private Button buttonIspCondPin;
    private Label labelUserPageConfWord;
    private Label labelGpioCondPin;
    private Label labelGpioLevel;
    private static final int ISP_IO_COND_BIT = 8;
    private static final int ISP_IO_COND_LEVEL_BIT = 16;
    private static final int ISP_BOOT_KEY_BIT = 17;
    private static final int CONF_WORD_DEFAULT_VALUE = -1835135637;
    private static final int ISP_BOOT_KEY = 18767;
    private File userPageFile;
    private static final FontRegistry fr = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry();

    public File getUserPageFile() {
        return this.userPageFile;
    }

    public UserPageConfigurationWord(Composite parent) {
        super(parent, 0);
        int ncol;
        this.setLayout((Layout)new FillLayout(512));
        Group group = new Group((Composite)this, 16);
        group.setText(Messages.getString("UserPage_GroupTitle"));
        GridLayout gl = new GridLayout();
        gl.numColumns = ncol = 3;
        group.setLayout((Layout)gl);
        Label label1_1 = new Label((Composite)group, 0);
        label1_1.setText(Messages.getString("UserPage_ISP_IO_COND_PIN_Label"));
        label1_1.setToolTipText(Messages.getString("UserPage_ISP_IO_COND_PIN_Tool_Tip"));
        label1_1.pack();
        this.spinnerIspCondLevel = new Spinner((Composite)group, 131072);
        this.spinnerIspCondLevel.setValues(88, 0, 100, 0, 1, 1);
        this.spinnerIspCondLevel.setToolTipText(Messages.getString("UserPage_ISP_IO_COND_PIN_Tool_Tip"));
        this.spinnerIspCondLevel.pack();
        this.labelGpioCondPin = new Label((Composite)group, 0);
        this.labelGpioCondPin.pack();
        Label label2_1 = new Label((Composite)group, 0);
        label2_1.setText(Messages.getString("UserPage_ISP_IO_COND_LEVEL_Label"));
        label2_1.setToolTipText(Messages.getString("UserPage_ISP_IO_COND_LEVEL_Tool_Tip"));
        label2_1.pack();
        this.buttonIspCondPin = new Button((Composite)group, 32);
        this.buttonIspCondPin.setToolTipText(Messages.getString("UserPage_ISP_IO_COND_LEVEL_Tool_Tip"));
        this.buttonIspCondPin.pack();
        this.labelGpioLevel = new Label((Composite)group, 0);
        this.labelGpioLevel.setText(Messages.getString("UserPage_ISP_IO_COND_LEVEL_High"));
        this.labelGpioLevel.pack();
        Label label4 = new Label((Composite)group, 0);
        label4.setText(Messages.getString("UserPage_Value_Label"));
        label4.pack();
        this.labelUserPageConfWord = new Label((Composite)group, 0);
        this.labelUserPageConfWord.setText(Integer.toHexString(this.userPageConfWord));
        this.labelUserPageConfWord.setFont(fr.get("org.eclipse.jface.textfont"));
        this.labelUserPageConfWord.pack();
        this.setConfWord(-1835135637);
        this.spinnerIspCondLevel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserPageConfigurationWord.this.dialogChanged(e);
            }
        });
        this.buttonIspCondPin.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserPageConfigurationWord.this.dialogChanged(e);
            }
        });
        group.pack();
    }

    private void dialogChanged(SelectionEvent e) {
        this.setConfWord(this.spinnerIspCondLevel.getSelection(), this.buttonIspCondPin.getSelection());
    }

    private void setConfWord(int ispCondLevel, boolean ispCondPin) {
        this.userPageConfWord = -1835139072;
        this.userPageConfWord |= ispCondLevel << 8;
        if (ispCondPin) {
            this.userPageConfWord |= 0x10000;
        }
        this.userPageConfWord |= this.computeCrc8(this.userPageConfWord) & 0xFF;
        this.labelUserPageConfWord.setText(HEX_PREFIX + Integer.toHexString(this.userPageConfWord).toUpperCase());
        this.updateLabel();
    }

    public void setConfWord(int userPageConfWord) {
        this.userPageConfWord = userPageConfWord;
        this.spinnerIspCondLevel.setSelection((userPageConfWord & 0xFF00) >> 8);
        if ((userPageConfWord & 0x10000) == 0) {
            this.buttonIspCondPin.setSelection(false);
        } else {
            this.buttonIspCondPin.setSelection(true);
        }
        userPageConfWord |= this.computeCrc8(userPageConfWord) & 0xFF;
        this.labelUserPageConfWord.setText(HEX_PREFIX + Integer.toHexString(userPageConfWord).toUpperCase());
        this.updateLabel();
    }

    public void setGpioMinMax(int min, int max) {
        this.spinnerIspCondLevel.setMinimum(min);
        this.spinnerIspCondLevel.setMaximum(max);
        this.updateLabel();
    }

    private void updateLabel() {
        this.labelGpioCondPin.setText(MessageFormat.format("From GPIO{0} to GPIO{1}", this.spinnerIspCondLevel.getMinimum(), this.spinnerIspCondLevel.getMaximum()));
        if (this.buttonIspCondPin.getSelection()) {
            this.labelGpioLevel.setText(Messages.getString("UserPage_ISP_IO_COND_LEVEL_High"));
        } else {
            this.labelGpioLevel.setText(Messages.getString("UserPage_ISP_IO_COND_LEVEL_Low"));
        }
        this.labelGpioLevel.pack();
        this.labelGpioCondPin.pack();
    }

    public byte computeCrc8(int fuseBitConfiguration) {
        return Crc8.getCRC8(new byte[]{(byte)(this.userPageConfWord << 0 >> 24 & 0xFF), (byte)(this.userPageConfWord << 8 >> 24 & 0xFF), (byte)(this.userPageConfWord << 16 >> 24 & 0xFF)});
    }

    public byte[] getfuseBitConfiguration() {
        return new byte[]{(byte)(this.userPageConfWord << 0 >> 24 & 0xFF), (byte)(this.userPageConfWord << 8 >> 24 & 0xFF), (byte)(this.userPageConfWord << 16 >> 24 & 0xFF), (byte)(this.userPageConfWord << 24 >> 24 & 0xFF)};
    }

    public void createUserPageFile() {
        try {
            this.userPageFile = File.createTempFile("userConf", ",dat");
            byte[] data = this.getfuseBitConfiguration();
            FileOutputStream fileoutputstream = null;
            try {
                fileoutputstream = new FileOutputStream(this.userPageFile);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            byte[] byArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                try {
                    fileoutputstream.write(b);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
            fileoutputstream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

