/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.sf.uc3.bootloader.wizards.configurations.pages.group;

import com.atmel.avr32.sf.uc3.bootloader.wizards.configurations.pages.group.Messages;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class FuseBitConfiguration
extends Composite {
    private static final String HEX_PREFIX = "0x";
    private static final String EMPTY_STRING = "";
    private static final FontRegistry fr = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry();
    private static final int FUSE_BIT_DEFAULT_VALUE = -524289;
    private static final int ISP_BID_EN_BIT = 29;
    private static final int ISP_IO_COND_EN_BIT = 30;
    private static final int ISP_FORCE_BIT = 31;
    private Button ButtonIspBodEn;
    private Button ButtonIspForce;
    private Button ButtonIspIoCondEn;
    private int FuseBitConfiguration;
    private Label LabelFuseBitConfiguration;

    public FuseBitConfiguration(Composite parent) {
        super(parent, 0);
        int ncol;
        this.setLayout((Layout)new FillLayout(512));
        Group group = new Group((Composite)this, 16);
        group.setText(Messages.getString("FuseBit_GroupTitle"));
        GridLayout gl = new GridLayout();
        gl.numColumns = ncol = 3;
        group.setLayout((Layout)gl);
        Label label1_1 = new Label((Composite)group, 0);
        label1_1.setText(Messages.getString("FuseBit_ISP_BOD_EN_Label"));
        label1_1.setToolTipText(Messages.getString("FuseBit_ISP_BOD_EN_Tool_Tip"));
        label1_1.pack();
        this.ButtonIspBodEn = new Button((Composite)group, 32);
        this.ButtonIspBodEn.setToolTipText(Messages.getString("FuseBit_ISP_BOD_EN_Tool_Tip"));
        this.ButtonIspBodEn.pack();
        Label label1_3 = new Label((Composite)group, 0);
        label1_3.setText(EMPTY_STRING);
        label1_3.pack();
        Label label2_1 = new Label((Composite)group, 0);
        label2_1.setText(Messages.getString("FuseBit_ISP_IO_COND_EN_Label"));
        label2_1.setToolTipText(Messages.getString("FuseBit_ISP_IO_COND_EN_Tool_Tip"));
        label2_1.pack();
        this.ButtonIspIoCondEn = new Button((Composite)group, 32);
        this.ButtonIspIoCondEn.setToolTipText(Messages.getString("FuseBit_ISP_IO_COND_EN_Tool_Tip"));
        this.ButtonIspIoCondEn.pack();
        Label label2_2 = new Label((Composite)group, 0);
        label2_2.setText(EMPTY_STRING);
        label2_2.pack();
        Label label3_1 = new Label((Composite)group, 0);
        label3_1.setText(Messages.getString("FuseBit_ISP_FORCE_Label"));
        label3_1.setToolTipText(Messages.getString("FuseBit_ISP_FORCE_Tool_Tip"));
        label3_1.pack();
        this.ButtonIspForce = new Button((Composite)group, 32);
        this.ButtonIspForce.setToolTipText(Messages.getString("FuseBit_ISP_FORCE_Tool_Tip"));
        this.ButtonIspForce.pack();
        Label label3_2 = new Label((Composite)group, 0);
        label3_2.setText(EMPTY_STRING);
        label3_2.pack();
        Label label4 = new Label((Composite)group, 0);
        label4.setText(Messages.getString("FuseBit_Value_Label"));
        label4.pack();
        this.LabelFuseBitConfiguration = new Label((Composite)group, 0);
        this.LabelFuseBitConfiguration.setText(Integer.toHexString(this.FuseBitConfiguration));
        this.LabelFuseBitConfiguration.setFont(fr.get("org.eclipse.jface.textfont"));
        this.LabelFuseBitConfiguration.pack();
        this.setFuseBit(-524289);
        this.ButtonIspBodEn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FuseBitConfiguration.this.dialogChanged(e);
            }
        });
        this.ButtonIspForce.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FuseBitConfiguration.this.dialogChanged(e);
            }
        });
        this.ButtonIspIoCondEn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FuseBitConfiguration.this.dialogChanged(e);
            }
        });
        group.pack();
    }

    private void dialogChanged(SelectionEvent e) {
        this.setFuseBit(this.ButtonIspBodEn.getSelection(), this.ButtonIspForce.getSelection(), this.ButtonIspIoCondEn.getSelection());
    }

    public int getFuseBit() {
        return this.FuseBitConfiguration;
    }

    public void setFuseBit(boolean IspBodEn, boolean IspForce, boolean IspIoCondEn) {
        this.FuseBitConfiguration = IspBodEn ? (this.FuseBitConfiguration |= 0x20000000) : (this.FuseBitConfiguration &= 0xDFFFFFFF);
        this.FuseBitConfiguration = IspForce ? (this.FuseBitConfiguration |= Integer.MIN_VALUE) : (this.FuseBitConfiguration &= Integer.MAX_VALUE);
        this.FuseBitConfiguration = IspIoCondEn ? (this.FuseBitConfiguration |= 0x40000000) : (this.FuseBitConfiguration &= 0xBFFFFFFF);
        this.LabelFuseBitConfiguration.setText(HEX_PREFIX + Integer.toHexString(this.FuseBitConfiguration).toUpperCase());
    }

    public void setFuseBit(int newFuseBitConfiguration) {
        this.FuseBitConfiguration = newFuseBitConfiguration;
        if ((newFuseBitConfiguration & 0x20000000) == 0) {
            this.ButtonIspBodEn.setSelection(false);
        } else {
            this.ButtonIspBodEn.setSelection(true);
        }
        if ((newFuseBitConfiguration & Integer.MIN_VALUE) == 0) {
            this.ButtonIspForce.setSelection(false);
        } else {
            this.ButtonIspForce.setSelection(true);
        }
        if ((newFuseBitConfiguration & 0x40000000) == 0) {
            this.ButtonIspIoCondEn.setSelection(false);
        } else {
            this.ButtonIspIoCondEn.setSelection(true);
        }
        this.LabelFuseBitConfiguration.setText(HEX_PREFIX + Integer.toHexString(this.FuseBitConfiguration).toUpperCase());
    }
}

