/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.sf.uc3.bootloader.wizards.configurations.pages;

import com.atmel.avr32.sf.uc3.bootloader.core.ILastPage;
import com.atmel.avr32.sf.uc3.bootloader.core.ProgramBootloader;
import com.atmel.avr32.sf.uc3.bootloader.core.Version;
import com.atmel.avr32.sf.uc3.bootloader.wizards.configurations.pages.Messages;
import com.atmel.avr32.sf.uc3.bootloader.wizards.configurations.pages.group.FuseBitConfiguration;
import com.atmel.avr32.sf.uc3.bootloader.wizards.configurations.pages.group.UserPageConfigurationWord;
import com.atmel.avr32.target.ITarget;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public class DfuPage
extends WizardPage
implements ILastPage {
    UserPageConfigurationWord userPageConfWord = null;
    FuseBitConfiguration fusebitConf = null;
    private static final int NUM_TASK = 8;
    private Version version = null;

    public DfuPage() {
        super(Messages.getString("Bootloader_Title"));
        this.setTitle(Messages.getString("Bootloader_Title"));
        this.setDescription(Messages.getString("Bootloader_Description"));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout(512));
        this.userPageConfWord = new UserPageConfigurationWord(composite);
        this.userPageConfWord.setConfWord(this.version.getDefaultUserPage());
        this.userPageConfWord.setGpioMinMax(this.version.getGpioMin(), this.version.getGpioMax());
        this.fusebitConf = new FuseBitConfiguration(composite);
        this.fusebitConf.setFuseBit(this.version.getDefaultGeneralPurposeFuses());
        Link linkDocumentation = new Link(composite, 0);
        linkDocumentation.setText("Use this link to get :<a href=\"http://www.atmel.com/dyn/resources/prod_documents/doc7745.pdf\">AVR32 USB DFU bootloader documentation</a>");
        linkDocumentation.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (DfuPage.this.getShell() != null) {
                    Control c = DfuPage.this.getShell().getDisplay().getFocusControl();
                    while (c != null) {
                        if (c.isListening(28)) {
                            c.notifyListeners(28, event);
                            break;
                        }
                        c = c.getParent();
                    }
                }
            }
        });
        linkDocumentation.pack();
        this.setControl((Control)composite);
    }

    @Override
    public IStatus doFinish(IProgressMonitor monitor, ITarget fTarget) {
        MultiStatus ms = new MultiStatus("com.atmel.avr32.sf.uc3.bootloader", 0, null, null);
        ProgramBootloader programBootloader = new ProgramBootloader(fTarget);
        monitor.setTaskName(Messages.getString("Bootloader_Erase"));
        ms.add(programBootloader.chiperase(monitor));
        if (!ms.isOK()) {
            return ms;
        }
        monitor.setTaskName(Messages.getString("Bootloader_CopyBootloader"));
        ms.add(this.version.copyBootloaderToTmp());
        monitor.worked(1);
        if (!ms.isOK()) {
            return ms;
        }
        monitor.setTaskName(Messages.getString("Bootloader_program"));
        ms.add(programBootloader.programBootloader(monitor, this.version.getImageFile()));
        this.version.getImageFile().delete();
        if (!ms.isOK()) {
            return ms;
        }
        monitor.setTaskName(Messages.getString("Bootloader_WriteUserConfWord"));
        this.userPageConfWord.createUserPageFile();
        monitor.worked(1);
        if (!ms.isOK()) {
            return ms;
        }
        monitor.setTaskName(Messages.getString("Bootloader_WriteUserConfWord"));
        ms.add(programBootloader.programUserPage(monitor, this.userPageConfWord.getUserPageFile()));
        this.userPageConfWord.getUserPageFile().delete();
        if (!ms.isOK()) {
            return ms;
        }
        monitor.setTaskName(Messages.getString("Bootloader_WriteFuseBit"));
        ms.add(programBootloader.programFuseBit(monitor, this.fusebitConf.getFuseBit()));
        if (!ms.isOK()) {
            return ms;
        }
        monitor.setTaskName(Messages.getString("Bootloader_Reset"));
        ms.add(programBootloader.resetTarget(monitor));
        if (!ms.isOK()) {
            return ms;
        }
        monitor.setTaskName(Messages.getString("Bootloader_Run"));
        ms.add(programBootloader.restartTarget(monitor));
        if (!ms.isOK()) {
            return ms;
        }
        return ms;
    }

    @Override
    public void setVersion(Version SelectedVersion) {
        this.version = SelectedVersion;
        if (this.userPageConfWord != null) {
            this.userPageConfWord.setConfWord(this.version.getDefaultUserPage());
            this.userPageConfWord.setGpioMinMax(this.version.getGpioMin(), this.version.getGpioMax());
        }
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("com.atmel.avr32.sf.uc3.bootloader.DfuPageId");
    }

    @Override
    public int getNumTasks() {
        return 8;
    }
}

