/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.sf.uc3.bootloader.wizards;

import com.atmel.avr32.sf.uc3.bootloader.core.BootloaderSelection;
import com.atmel.avr32.sf.uc3.bootloader.core.ILastPage;
import com.atmel.avr32.sf.uc3.bootloader.core.Version;
import com.atmel.avr32.sf.uc3.bootloader.wizards.ImportFormatInnerWizardNode;
import com.atmel.avr32.sf.uc3.bootloader.wizards.Messages;
import com.atmel.avr32.target.ITarget;
import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class SelectionPage
extends WizardSelectionPage {
    ILastPage NextOptionPage = null;
    private static final String XML_PART_DIRECTORY = "resources/xml";
    private static final String DTD_PART_FILE = "bootloader.dtd";
    private static final String XML_PART_FILE = "bootloader.xml";
    private static final String DIALOG_SETTING_BOOT_TYPE = "boottype";
    private static final String DIALOG_SETTING_VERSION = "version";
    private IWizardNode innerWizardNode;
    private BootloaderSelection bootloader;
    Label part;
    Combo bootLoaderType;
    Combo bootVersion;
    ITarget fTarget;

    public SelectionPage(ITarget target) {
        super(Messages.getString("SelectionPage_Title"));
        this.setTitle(Messages.getString("SelectionPage_Title"));
        this.setDescription(Messages.getString("SelectionPage_Description"));
        this.fTarget = target;
        this.setBooloaderList();
    }

    private void setBooloaderList() {
        Bundle bundle = Platform.getBundle((String)"com.atmel.avr32.sf.uc3.bootloader");
        Path pathDTD = new Path(XML_PART_DIRECTORY + File.separator + DTD_PART_FILE);
        Path pathXML = new Path(XML_PART_DIRECTORY + File.separator + XML_PART_FILE);
        URL dtdUrl = FileLocator.find((Bundle)bundle, (IPath)pathDTD, null);
        URL xmlUrl = FileLocator.find((Bundle)bundle, (IPath)pathXML, null);
        this.bootloader = new BootloaderSelection(xmlUrl, dtdUrl);
    }

    public IWizardPage getNextPage() {
        this.saveContents();
        Version SelectedVersion = this.bootloader.getVersion(this.part.getText(), this.bootLoaderType.getText(), this.bootVersion.getText());
        if (this.NextOptionPage != null && this.NextOptionPage.getClass().getName().contentEquals(SelectedVersion.getPageClass())) {
            this.NextOptionPage.setVersion(SelectedVersion);
            return super.getNextPage();
        }
        this.setSelectedNode(null);
        if (this.innerWizardNode != null) {
            this.innerWizardNode = null;
        }
        Class<?> clas = null;
        try {
            System.out.println("SelectionPage.getNextPage()" + SelectedVersion.getPageClass());
            clas = Class.forName(SelectedVersion.getPageClass());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        try {
            this.NextOptionPage = (ILastPage)clas.newInstance();
            this.NextOptionPage.setVersion(SelectedVersion);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        IWizardPage[] optionPages = new IWizardPage[]{(IWizardPage)this.NextOptionPage};
        this.innerWizardNode = new ImportFormatInnerWizardNode((IWizardPage)this, optionPages);
        this.setSelectedNode(this.innerWizardNode);
        return super.getNextPage();
    }

    public void createControl(Composite parent) {
        int ncol;
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = ncol = 2;
        composite.setLayout((Layout)gl);
        new Label(composite, 0).setText("Part:");
        this.part = new Label(composite, 0);
        this.part.setText(this.fTarget.getCpu());
        new Label(composite, 0).setText("Type:");
        this.bootLoaderType = new Combo(composite, 2056);
        this.bootLoaderType.setLayoutData((Object)new GridData(768));
        this.bootLoaderType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectionPage.this.dialogChanged(e);
            }
        });
        new Label(composite, 0).setText("Version:");
        this.bootVersion = new Combo(composite, 2056);
        this.bootVersion.setLayoutData((Object)new GridData(768));
        this.setControl((Control)composite);
        this.initContents();
    }

    private void initContents() {
        IDialogSettings dialogSettings = this.getDialogSettings();
        String lastBootType = dialogSettings.get(DIALOG_SETTING_BOOT_TYPE);
        String lastVersion = dialogSettings.get(DIALOG_SETTING_VERSION);
        String MCUpart = this.fTarget.getCpu();
        String[] bootTypeList = this.bootloader.getBootloaderList(this.fTarget.getCpu());
        if (bootTypeList == null) {
            this.setErrorMessage("MCU Part " + this.part + " can't be programmed.");
            return;
        }
        String[] versionList = this.bootloader.getVersionList(MCUpart, lastBootType);
        if (versionList == null) {
            versionList = this.bootloader.getVersionList(MCUpart, bootTypeList[0]);
            lastBootType = bootTypeList[0];
        }
        if (this.bootloader.getVersion(MCUpart, lastBootType, lastVersion) == null) {
            lastVersion = versionList[0];
        }
        this.part.setText(MCUpart);
        this.bootLoaderType.setItems(bootTypeList);
        this.bootLoaderType.setText(lastBootType);
        this.bootVersion.setItems(versionList);
        this.bootVersion.setText(lastVersion);
        this.setMessage(null);
        this.setErrorMessage(null);
    }

    private void saveContents() {
        IDialogSettings workbenchSettings = this.getDialogSettings();
        workbenchSettings.put(DIALOG_SETTING_BOOT_TYPE, this.bootLoaderType.getText());
        workbenchSettings.put(DIALOG_SETTING_VERSION, this.bootVersion.getText());
    }

    public void dispose() {
        if (this.innerWizardNode != null) {
            this.innerWizardNode.dispose();
            this.innerWizardNode = null;
        }
        super.dispose();
    }

    private void dialogChanged(ModifyEvent e) {
        if ((Combo)e.widget == this.bootLoaderType && !this.bootLoaderType.getText().contentEquals("")) {
            String[] VersionList = this.bootloader.getVersionList(this.part.getText(), this.bootLoaderType.getText());
            this.bootVersion.removeAll();
            this.bootVersion.setItems(VersionList);
            this.bootVersion.setText(VersionList[0]);
        }
    }

    public boolean canFlipToNextPage() {
        return this.getErrorMessage() == null;
    }

    public ILastPage getLastOptionPage() {
        return this.NextOptionPage;
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("com.atmel.avr32.sf.uc3.bootloader.SelectionPageId");
    }
}

