/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.sf.uc3.bootloader.wizards;

import java.util.ArrayList;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Point;

public abstract class AbstractInnerWizardNode
implements IWizardNode {
    protected static final Object LOCK = new Object();
    protected Wizard innerWizard;
    protected IWizardPage[] pagesAfterWizard;

    public AbstractInnerWizardNode(IWizardPage pageAfterWizard) {
        this(new IWizardPage[]{pageAfterWizard});
    }

    public AbstractInnerWizardNode(IWizardPage[] pagesAfterWizard) {
        this.pagesAfterWizard = pagesAfterWizard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IWizard getWizard() {
        Object object = LOCK;
        synchronized (object) {
            if (this.innerWizard == null) {
                this.innerWizard = this.createAndFillWizard();
                if (this.pagesAfterWizard != null) {
                    int i = 0;
                    while (i < this.pagesAfterWizard.length) {
                        this.innerWizard.addPage(this.pagesAfterWizard[i]);
                        ++i;
                    }
                }
            }
            return this.innerWizard;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isContentCreated() {
        Object object = LOCK;
        synchronized (object) {
            return this.innerWizard != null;
        }
    }

    public Point getExtent() {
        return new Point(-1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = LOCK;
        synchronized (object) {
            this.pagesAfterWizard = null;
            if (this.innerWizard != null) {
                this.innerWizard.dispose();
                this.innerWizard = null;
            }
        }
    }

    public abstract Wizard createAndFillWizard();

    public static IWizardPage[] getAllFollowingPages(IWizard wizard, IWizardPage page) {
        ArrayList<IWizardPage> pages = new ArrayList<IWizardPage>();
        IWizardPage next = wizard.getNextPage(page);
        while (next != null) {
            pages.add(next);
            next = wizard.getNextPage(next);
        }
        IWizardPage[] pageArray = new IWizardPage[pages.size()];
        return pages.toArray(pageArray);
    }
}

