/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.sf.uc3.bootloader.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class Version {
    private int fDefaultUserPage;
    private int fDefaultGeneralPurposeFuses;
    private String fFileName;
    private int fGpioMax;
    private int fGpioMin;
    private File fImageFile;
    private String fLocation;
    private String fPageClass;
    private String fPart;

    public IStatus copyBootloaderToTmp() {
        Bundle bundle = Platform.getBundle((String)"com.atmel.avr32.sf.uc3.bootloader");
        Path p = new Path(String.valueOf(this.getLocation()) + '/' + this.getFilename());
        try {
            this.fImageFile = File.createTempFile(this.fFileName, ".bin");
            InputStream is = FileLocator.openStream((Bundle)bundle, (IPath)p, (boolean)false);
            FileOutputStream os = new FileOutputStream(this.fImageFile);
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = is.read(buf)) != -1) {
                os.write(buf, 0, i);
            }
            is.close();
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return new Status(4, "com.atmel.avr32.sf.uc3.bootloader", e.getLocalizedMessage(), null);
        }
        return Status.OK_STATUS;
    }

    public int getDefaultUserPage() {
        return this.fDefaultUserPage;
    }

    public String getFilename() {
        return this.fFileName;
    }

    public int getGpioMax() {
        return this.fGpioMax;
    }

    public int getGpioMin() {
        return this.fGpioMin;
    }

    public File getImageFile() {
        return this.fImageFile;
    }

    public String getLocation() {
        return this.fLocation;
    }

    public String getPageClass() {
        return this.fPageClass;
    }

    public String getPart() {
        return this.fPart;
    }

    public void setDefaultUserPage(String defaultUserPage) {
        this.fDefaultUserPage = (int)Long.parseLong(defaultUserPage, 16);
    }

    public void setFilename(String filename) {
        this.fFileName = filename;
    }

    public void setGpioMax(int gpioMax) {
        this.fGpioMax = gpioMax;
    }

    public void setGpioMin(int gpioMin) {
        this.fGpioMin = gpioMin;
    }

    public void setLocation(String location) {
        this.fLocation = location;
    }

    public void setPageClass(String pageClass) {
        this.fPageClass = pageClass;
    }

    public void setPart(String part) {
        this.fPart = part;
    }

    public int getDefaultGeneralPurposeFuses() {
        return this.fDefaultGeneralPurposeFuses;
    }

    public void setDefaultGeneralPurposeFuses(String fDefaultGeneralPurposeFuses) {
        this.fDefaultGeneralPurposeFuses = (int)Long.parseLong(fDefaultGeneralPurposeFuses, 16);
    }
}

