/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.sf.uc3.bootloader.core;

import com.atmel.avr32.sf.uc3.bootloader.core.AdapterInterface;
import com.atmel.avr32.sf.uc3.bootloader.core.Messages;
import com.atmel.avr32.target.AbstractAdapterInterface;
import com.atmel.avr32.target.ITarget;
import com.atmel.avr32.target.ToolRegistry;
import com.atmel.avr32.target.tool.model.Tool;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunch;

public class ProgramBootloader
extends AdapterInterface {
    private static final String AVR32PROGRAM = "avr32program";
    private static final String EMPTY = "";
    private static final String RS232 = "rs232";
    private static final String USB_OPTION = "USB";
    private static final String USB_OPTION_SERIAL = "USB:";
    ITarget fTarget;

    public ProgramBootloader(ITarget target) {
        this.fTarget = target;
    }

    private void buildCommandOptions(ArrayList<String> commandline) {
        if (this.fTarget.getConnectionType().equals(RS232)) {
            commandline.add("-c" + this.fTarget.getComport());
        } else if (this.fTarget.getSerial().equals(EMPTY)) {
            commandline.add("-c");
            commandline.add(USB_OPTION);
        } else {
            commandline.add("-c");
            commandline.add(USB_OPTION_SERIAL + this.fTarget.getSerial());
        }
        Tool tool = ToolRegistry.getTool((String)this.fTarget.getAdapterName());
        commandline.add("-p" + tool.getId());
        commandline.add("--part");
        commandline.add(this.fTarget.getCpu());
    }

    public IStatus chiperase(IProgressMonitor monitor) {
        monitor.setTaskName(Messages.ProgramBootloader_ChipErase);
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(AVR32PROGRAM);
        this.buildCommandOptions(commandLine);
        commandLine.add("chiperase");
        IStatus status = this.createProcess(commandLine, true, null, (IProgressMonitor)new NullProgressMonitor());
        monitor.worked(1);
        return status;
    }

    public IStatus resetTarget(IProgressMonitor monitor) {
        monitor.setTaskName(Messages.ProgramBootloader_Reset);
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(AVR32PROGRAM);
        this.buildCommandOptions(commandLine);
        commandLine.add("reset");
        IStatus status = this.createProcess(commandLine, true, null, (IProgressMonitor)new NullProgressMonitor());
        monitor.worked(1);
        return status;
    }

    protected IStatus createProcess(ArrayList<String> args, boolean wait, ILaunch launch, IProgressMonitor monitor) {
        ArrayList<String> envp = new ArrayList<String>();
        Map<String, String> vars = System.getenv();
        for (String string : vars.keySet()) {
            envp.add(String.valueOf(string) + "=" + vars.get(string));
        }
        if (wait) {
            return this.createProcess(args, AbstractAdapterInterface.WaitMode.WAIT, launch, monitor);
        }
        return this.createProcess(args, AbstractAdapterInterface.WaitMode.NO_WAIT, launch, monitor);
    }

    public IStatus programBootloader(IProgressMonitor monitor, File file) {
        ArrayList<String> commandLine = new ArrayList<String>();
        monitor.setTaskName(Messages.ProgramBootloader_Bootloader);
        commandLine.add(AVR32PROGRAM);
        this.buildCommandOptions(commandLine);
        commandLine.add("program");
        commandLine.add("-finternal@0x80000000,512Kb");
        commandLine.add("-cxtal");
        commandLine.add("-e");
        commandLine.add("-v");
        commandLine.add("-O0x80000000");
        commandLine.add("-Fbin");
        commandLine.add(file.getAbsolutePath());
        monitor.worked(1);
        IStatus status = this.createProcess(commandLine, true, null, (IProgressMonitor)new NullProgressMonitor());
        monitor.worked(1);
        return status;
    }

    public IStatus programFuseBit(IProgressMonitor monitor, int fuseBit) {
        ArrayList<String> commandLine = new ArrayList<String>();
        monitor.setTaskName(Messages.ProgramBootloader_FuseBit);
        commandLine.add(AVR32PROGRAM);
        this.buildCommandOptions(commandLine);
        commandLine.add("writefuses");
        commandLine.add("-finternal@0x80000000,512Kb");
        commandLine.add("gp=0x" + Integer.toHexString(fuseBit));
        IStatus status = this.createProcess(commandLine, true, null, (IProgressMonitor)new NullProgressMonitor());
        monitor.worked(1);
        return status;
    }

    public IStatus programUserPage(IProgressMonitor monitor, File userPageFile) {
        ArrayList<String> commandLine = new ArrayList<String>();
        monitor.setTaskName(Messages.ProgramBootloader_UserPage);
        commandLine.add(AVR32PROGRAM);
        this.buildCommandOptions(commandLine);
        commandLine.add("program");
        commandLine.add("-finternal@0x80000000,512Kb");
        commandLine.add("-cxtal");
        commandLine.add("-e");
        commandLine.add("-v");
        commandLine.add("-O0x808001FC");
        commandLine.add("-Fbin");
        commandLine.add(userPageFile.getAbsolutePath());
        IStatus status = this.createProcess(commandLine, true, null, (IProgressMonitor)new NullProgressMonitor());
        monitor.worked(1);
        return status;
    }

    public IStatus restartTarget(IProgressMonitor monitor) {
        monitor.setTaskName(Messages.ProgramBootloader_Run);
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(AVR32PROGRAM);
        this.buildCommandOptions(commandLine);
        commandLine.add("run");
        IStatus status = this.createProcess(commandLine, true, null, (IProgressMonitor)new NullProgressMonitor());
        monitor.worked(1);
        return status;
    }
}

