/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.sf.uc3.bootloader.core;

import com.atmel.avr32.sf.uc3.bootloader.core.Version;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ParseXml
extends DefaultHandler {
    private static final String DTD_PART_FILE = "ressources/xml/bootloader.dtd";
    private static final String BOOTLOADER = "BOOTLOADER";
    private static final String PART = "PART";
    private static final String GPIO_MIN = "GPIO_MIN";
    private static final String GPIO_MAX = "GPIO_MAX";
    private static final String BOOTLOADER_FAMILY = "BOOTLOADER_FAMILY";
    private static final String VERSION = "VERSION";
    private static final String LOCATION = "LOCATION";
    private static final String FILENAME = "FILENAME";
    private static final String PAGE_CLASS = "PAGE_CLASS";
    private static final String USER_PAGE_DEFAULT = "USER_PAGE_DEFAULT";
    private static final String GP_FUSE_DEFAULT = "GP_FUSE_DEFAULT";
    private SAXParser parser = null;
    private URL xmlUrl = null;
    private URL dtdUrl = null;
    private HashMap<String, HashMap<String, HashMap<String, Version>>> partlist;
    private HashMap<String, HashMap<String, Version>> bootlist;
    private HashMap<String, Version> versionlist;
    private Version version;
    private String currentPart;
    String currentString = "";
    int currentGpioMin;
    int currentGpioMax;

    public ParseXml(URL url) {
        this.getParser();
        this.xmlUrl = url;
        try {
            this.dtdUrl = new File(DTD_PART_FILE).toURI().toURL();
        }
        catch (MalformedURLException e) {
            this.showError(e.getMessage());
        }
    }

    public ParseXml(File xmlFilePath) {
        this.getParser();
        try {
            this.xmlUrl = xmlFilePath.toURI().toURL();
            this.dtdUrl = new File(DTD_PART_FILE).toURI().toURL();
        }
        catch (MalformedURLException e) {
            this.showError(e.getMessage());
        }
    }

    public ParseXml(URL xmlLocation, URL dtdLocation) {
        this.getParser();
        this.xmlUrl = xmlLocation;
        this.dtdUrl = dtdLocation;
    }

    private SAXParser getParser() {
        if (this.parser == null) {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setValidating(true);
                this.parser = factory.newSAXParser();
                this.parser.getXMLReader().setEntityResolver(this);
            }
            catch (FactoryConfigurationError e) {
                this.showError(e.getMessage());
            }
            catch (SAXException e) {
                this.showError(e.getMessage());
            }
            catch (ParserConfigurationException e) {
                this.showError(e.getMessage());
            }
        }
        return this.parser;
    }

    public void parse() {
        try {
            this.parser.parse(this.xmlUrl.openStream(), (DefaultHandler)this);
        }
        catch (SAXException e) {
            this.showError(e.getMessage());
        }
        catch (IOException e) {
            this.showError(e.getMessage());
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.showError(e.getMessage());
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        return new InputSource(this.dtdUrl.toExternalForm());
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currentString = new String(ch, start, length);
    }

    private void showError(String error) {
        MessageDialog dialog = new MessageDialog(Display.getDefault().getActiveShell(), "XML Parser Error", null, error, 1, new String[]{"Ok"}, 0);
        dialog.open();
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (name.equals(BOOTLOADER)) {
            this.partlist = new HashMap();
        } else if (name.equals(PART)) {
            this.bootlist = new HashMap();
            this.currentPart = attributes.getValue("NAME");
            this.partlist.put(this.currentPart, this.bootlist);
        } else if (name.equals(BOOTLOADER_FAMILY)) {
            this.versionlist = new HashMap();
            this.bootlist.put(attributes.getValue("NAME"), this.versionlist);
        } else if (name.equals(VERSION)) {
            this.version = new Version();
            this.version.setPart(this.currentPart);
            this.version.setGpioMax(this.currentGpioMax);
            this.version.setGpioMin(this.currentGpioMin);
            this.versionlist.put(attributes.getValue("NUM"), this.version);
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (name.equals(LOCATION)) {
            this.version.setLocation(this.currentString);
        } else if (name.equals(FILENAME)) {
            this.version.setFilename(this.currentString);
        } else if (name.equals(PAGE_CLASS)) {
            this.version.setPageClass(this.currentString);
        } else if (name.equals(USER_PAGE_DEFAULT)) {
            this.version.setDefaultUserPage(this.currentString);
        } else if (name.equals(GP_FUSE_DEFAULT)) {
            this.version.setDefaultGeneralPurposeFuses(this.currentString);
        } else if (name.equals(GPIO_MIN)) {
            this.currentGpioMin = Integer.parseInt(this.currentString, 10);
        } else if (name.equals(GPIO_MAX)) {
            this.currentGpioMax = Integer.parseInt(this.currentString, 10);
        }
    }

    public String toString() {
        String outString = "";
        for (String part : this.partlist.keySet()) {
            outString = String.valueOf(outString) + "\npart:" + part;
            for (String bootloaderType : this.partlist.get(part).keySet()) {
                outString = String.valueOf(outString) + "\n\tbootloader:" + bootloaderType;
                for (String version : this.partlist.get(part).get(bootloaderType).keySet()) {
                    outString = String.valueOf(outString) + "\n\t\tversion:" + version;
                    Version sVersion = this.partlist.get(part).get(bootloaderType).get(version);
                    outString = String.valueOf(outString) + "\n\t\t\tlocation:" + sVersion.getLocation();
                    outString = String.valueOf(outString) + "\n\t\t\tfilename:" + sVersion.getFilename();
                    outString = String.valueOf(outString) + "\n\t\t\tjava_page:" + sVersion.getPageClass();
                    outString = String.valueOf(outString) + "\n\t\t\tmin_gpio:" + sVersion.getGpioMin();
                    outString = String.valueOf(outString) + "\n\t\t\tmax_gpio:" + sVersion.getGpioMax();
                }
            }
        }
        return outString;
    }

    public HashMap<String, HashMap<String, HashMap<String, Version>>> getPartlist() {
        return this.partlist;
    }

    public static void main(String[] args) {
        System.out.println(System.getenv("APPDATA"));
        File xmlDeviceFile = new File("resources/xml/bootloader.xml");
        ParseXml xmlDevice = new ParseXml(xmlDeviceFile);
        xmlDevice.parse();
        System.out.println(xmlDevice.toString());
        System.out.println(System.getenv("APPDATA"));
    }
}

