/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.sf.uc3.bootloader.core;

import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public final class DebugConsole
extends MessageConsole {
    public static final String CONSOLE_NAME = "Bootloader debug Console";
    private static MessageConsoleStream out = null;
    private static DebugConsole debugConsole = null;

    private DebugConsole() {
        super(CONSOLE_NAME, null);
        out = this.newMessageStream();
        Display d = Display.getCurrent();
        if (d == null) {
            d = PlatformUI.createDisplay();
        }
        out.setColor(d.getSystemColor(9));
    }

    public static void print(String message) {
        if (DebugConsole.getConsole(CONSOLE_NAME) != null) {
            out.print(message);
        } else {
            System.out.print(message);
        }
    }

    public static void println(String message) {
        if (DebugConsole.getConsole(CONSOLE_NAME) != null) {
            out.println(message);
        } else {
            System.out.println(message);
        }
    }

    public static void println() {
        if (DebugConsole.getConsole(CONSOLE_NAME) != null) {
            out.println();
        } else {
            System.out.println();
        }
    }

    public static DebugConsole getConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        if (plugin != null) {
            IConsoleManager consoleManager = plugin.getConsoleManager();
            IConsole[] consoles = consoleManager.getConsoles();
            int i = 0;
            while (i < consoles.length) {
                if (name.equals(consoles[i].getName())) {
                    debugConsole = (DebugConsole)consoles[i];
                    break;
                }
                ++i;
            }
            if (debugConsole == null) {
                debugConsole = new DebugConsole();
                consoleManager.addConsoles(new IConsole[]{debugConsole});
            }
        }
        return debugConsole;
    }

    public static void displayConsole(IConsole myConsole) {
        IWorkbenchPage page;
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (windows.length > 0 && (page = windows[0].getActivePage()) != null) {
            String id = "org.eclipse.ui.console.ConsoleView";
            try {
                IConsoleView view = (IConsoleView)page.showView(id);
                view.display(myConsole);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    public static void displayConsole() {
        DebugConsole console = DebugConsole.getConsole(CONSOLE_NAME);
        DebugConsole.displayConsole((IConsole)console);
    }

    protected void dispose() {
        super.dispose();
    }

    public static void addConsole() {
        DebugConsole debugConsole = DebugConsole.getConsole(CONSOLE_NAME);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{debugConsole});
    }
}

