/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.sf.uc3.bootloader.core;

import com.atmel.avr32.sf.uc3.bootloader.core.ParseXml;
import com.atmel.avr32.sf.uc3.bootloader.core.Version;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;

public class BootloaderSelection {
    HashMap<String, HashMap<String, HashMap<String, Version>>> partList;

    public BootloaderSelection(URL xmlLocation) {
        ParseXml xmlDevice = new ParseXml(xmlLocation);
        xmlDevice.parse();
        this.partList = xmlDevice.getPartlist();
    }

    public BootloaderSelection(URL xmlLocation, URL dtdLocation) {
        ParseXml xmlDevice = new ParseXml(xmlLocation, dtdLocation);
        xmlDevice.parse();
        this.partList = xmlDevice.getPartlist();
    }

    public String[] getPartList() {
        Object[] arrayPartList = this.partList.keySet().toArray(new String[this.partList.size()]);
        Arrays.sort(arrayPartList);
        return arrayPartList;
    }

    public String[] getBootloaderList(String part) {
        if (!this.partList.containsKey(part)) {
            return null;
        }
        Object[] arrayBootList = this.partList.get(part).keySet().toArray(new String[this.partList.get(part).size()]);
        Arrays.sort(arrayBootList);
        return arrayBootList;
    }

    public String[] getVersionList(String part, String bootloader) {
        if (!this.partList.containsKey(part)) {
            return null;
        }
        if (!this.partList.get(part).containsKey(bootloader)) {
            return null;
        }
        String[] arrayVersionList = this.partList.get(part).get(bootloader).keySet().toArray(new String[this.partList.get(part).get(bootloader).size()]);
        Arrays.sort(arrayVersionList, Collections.reverseOrder());
        return arrayVersionList;
    }

    public Version getVersion(String part, String bootloader, String version) {
        if (!this.partList.containsKey(part)) {
            return null;
        }
        if (!this.partList.get(part).containsKey(bootloader)) {
            return null;
        }
        if (!this.partList.get(part).get(bootloader).containsKey(version)) {
            return null;
        }
        return this.partList.get(part).get(bootloader).get(version);
    }

    public static void main(String[] args) {
        URL xmlUrl = null;
        try {
            xmlUrl = new File("ressources/xml/bootloader.xml").toURI().toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        BootloaderSelection bootloaderList = new BootloaderSelection(xmlUrl);
        String[] stringArray = bootloaderList.getPartList();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            System.out.println("Part:" + part);
            String[] stringArray2 = bootloaderList.getBootloaderList(part);
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String bootloader = stringArray2[n4];
                System.out.println("\t\tbootloader:" + bootloader);
                String[] stringArray3 = bootloaderList.getVersionList(part, bootloader);
                int n5 = stringArray3.length;
                int n6 = 0;
                while (n6 < n5) {
                    String version = stringArray3[n6];
                    System.out.println("\t\t\tversion:" + version);
                    Version sVersion = bootloaderList.getVersion(part, bootloader, version);
                    System.out.println("\t\t\t\tpart:" + sVersion.getPart());
                    System.out.println("\t\t\t\tlocation:" + sVersion.getLocation());
                    System.out.println("\t\t\t\tfilename:" + sVersion.getFilename());
                    System.out.println("\t\t\t\tjava_page:" + sVersion.getPageClass());
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }
}

