/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.internal.ide;

import com.atmel.avr32.internal.ide.Messages;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IStartup;

public class JREChecker
implements IStartup {
    private static final String[] BAD_JRES = new String[]{"Free Software Foundation, Inc."};
    private static final String REGEXP = "\\.";
    private static final String COLON = ": ";
    private static final char NEWLINE = '\n';
    private static final String JAVA_SPECIFICATION_VERSION = "java.specification.version";
    private static final String JAVA_VM_VENDOR = "java.vm.vendor";

    public static void main(String[] args) {
        System.out.println(System.getProperty(JAVA_VM_VENDOR));
        System.out.println(System.getProperty("java.vm.name"));
    }

    private int versionInfo(String program, StringBuffer message, int major, int minor) {
        if (message != null) {
            message.append('\n');
            message.append(program);
            message.append(COLON);
        }
        String vendor = System.getProperty(JAVA_VM_VENDOR);
        int x = 0;
        while (x < BAD_JRES.length) {
            if (BAD_JRES[x].equals(vendor)) {
                message.append(MessageFormat.format(Messages.JREChecker_Unsupported, System.getProperty("java.vm.name"), vendor));
                return 1;
            }
            ++x;
        }
        String version = System.getProperty(JAVA_SPECIFICATION_VERSION);
        int majorv = Integer.parseInt(version.split(REGEXP)[0]);
        int minorv = Integer.parseInt(version.split(REGEXP)[1]);
        if (message != null) {
            message.append(MessageFormat.format(Messages.JREChecker_Found, version));
        }
        if (majorv == major && minorv < minor || majorv < major) {
            if (message != null) {
                message.append(MessageFormat.format(Messages.JREChecker_Need, new Integer(major), new Integer(minor)));
            }
            return 1;
        }
        if (message != null) {
            message.append(Messages.JREChecker_OK);
        }
        return 0;
    }

    private static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    private void errorMessage(final String title, final String message) {
        JREChecker.getStandardDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = JREChecker.getStandardDisplay().getActiveShell();
                if (shell == null) {
                    shell = new Shell(JREChecker.getStandardDisplay());
                }
                MessageDialog.openError((Shell)shell, (String)title, (String)message);
            }
        });
    }

    public void earlyStartup() {
        if (System.getProperty("no-environment-check") != null) {
            System.out.println("\"no-environment-check\" specified, not running JRE check");
            return;
        }
        StringBuffer message = new StringBuffer();
        int errors = this.versionInfo(Messages.JREChecker_JRE_Label, message, 1, 5);
        if (errors > 0) {
            message.append(Messages.JREChecker_JRE_Warning);
            this.errorMessage(Messages.JREChecker_Title, message.toString());
        }
    }
}

