/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.internal;

import com.atmel.avr32.managedbuilder.ManagedbuildPlugin;
import java.util.List;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.ScannerInfoTypes;
import org.eclipse.cdt.make.internal.core.scannerconfig2.DefaultRunSIProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;

public class SpecsRunSIProvider
extends DefaultRunSIProvider {
    private static final String NAME = "name";
    private static final String OPTIONS = "options";
    private static final String PARTS_EXTENSIONPOINT_ID = "com.atmel.avr32.target.parts";

    private static IConfigurationElement getConfigurationElement(String partName) {
        IConfigurationElement[] points;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(PARTS_EXTENSIONPOINT_ID);
        IConfigurationElement[] iConfigurationElementArray = points = extensionPoint.getConfigurationElements();
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute(NAME).equals(partName)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    private static String getToolchainOption(String partName) {
        return SpecsRunSIProvider.getConfigurationElement(partName).getAttribute(OPTIONS);
    }

    protected boolean initialize() {
        boolean rc = super.initialize();
        if (rc) {
            String targetFile = "dummy";
            IProject project = this.resource.getProject();
            try {
                boolean partFound = false;
                if (project.hasNature("org.eclipse.cdt.core.ccnature")) {
                    targetFile = "specs.cpp";
                } else if (project.hasNature("org.eclipse.cdt.core.cnature")) {
                    targetFile = "specs.c";
                }
                String part = ManagedbuildPlugin.getProjectMCU((IProject)project);
                int i = 0;
                while (i < this.fCompileArguments.length) {
                    this.fCompileArguments[i] = this.fCompileArguments[i].replaceAll("\\$\\{plugin_state_location\\}", MakeCorePlugin.getWorkingDirectory().toString());
                    this.fCompileArguments[i] = this.fCompileArguments[i].replaceAll("\\$\\{specs_file\\}", targetFile);
                    if (part != null) {
                        if (this.fCompileArguments[i].indexOf("${part}") > -1) {
                            partFound = true;
                        }
                        this.fCompileArguments[i] = this.fCompileArguments[i].replaceAll("\\$\\{part\\}", part.toLowerCase());
                    }
                    ++i;
                }
                if (!partFound) {
                    String[] rv = new String[this.fCompileArguments.length + 1];
                    System.arraycopy(this.fCompileArguments, 0, rv, 1, this.fCompileArguments.length);
                    this.fCompileArguments = rv;
                    this.fCompileArguments[0] = SpecsRunSIProvider.getToolchainOption(part);
                }
            }
            catch (CoreException e) {
                MakeCorePlugin.log((IStatus)e.getStatus());
                rc = false;
            }
        }
        return rc;
    }

    protected String[] prepareArguments(boolean isDefaultCommand) {
        if (this.collector == null) {
            return this.fCompileArguments;
        }
        List tso = this.collector.getCollectedScannerInfo((Object)this.resource.getProject(), ScannerInfoTypes.TARGET_SPECIFIC_OPTION);
        if (tso == null || tso.size() == 0) {
            return this.fCompileArguments;
        }
        String[] rv = null;
        int nTokens = 0;
        if (this.fCompileArguments != null && this.fCompileArguments.length > 0) {
            nTokens = this.fCompileArguments.length;
            rv = new String[nTokens + tso.size()];
            System.arraycopy(this.fCompileArguments, 0, rv, 0, nTokens);
        } else {
            rv = new String[tso.size()];
        }
        int i = 0;
        while (i < tso.size()) {
            rv[nTokens + i] = (String)tso.get(i);
            ++i;
        }
        return rv;
    }
}

