/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.internal;

import com.atmel.avr32.debug.IRegisterWatch;
import com.atmel.avr32.debug.IRegisterWatchListener;
import com.atmel.avr32.debug.internal.Messages;
import com.atmel.avr32.managedbuilder.ManagedbuildPlugin;
import com.atmel.avr32.target.PartRegistry;
import com.atmel.avr32.target.debug.IWatchable;
import com.atmel.avr32.target.part.model.Bitfield;
import com.atmel.avr32.target.part.model.BitfieldInstance;
import com.atmel.avr32.target.part.model.IModelInfo;
import com.atmel.avr32.target.part.model.Part;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.event.ICDIDestroyedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.event.ICDIResumedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDISuspendedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.command.Command;
import org.eclipse.cdt.debug.mi.core.command.MIDataReadMemory;
import org.eclipse.cdt.debug.mi.core.command.MIDataWriteMemory;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSet;
import org.eclipse.cdt.debug.mi.core.command.MIGDBShow;
import org.eclipse.cdt.debug.mi.core.output.MIDataReadMemoryInfo;
import org.eclipse.cdt.debug.mi.core.output.MIMemory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.core.ILaunch;

public class RegisterWatch
implements ICDIEventListener,
IRegisterWatch {
    private final ArrayList<IWatchable> watchedRegisters = new ArrayList();
    private final ArrayList<IWatchable> removedRegisters = new ArrayList();
    private boolean fSuspended;
    private final ListenerList listeners = new ListenerList();
    private ICDISession fSession;
    private Part fPart;
    private ILaunch fLaunch;
    private IProject fProject;

    public RegisterWatch() {
    }

    public RegisterWatch(ILaunch launch, IProject project, ICDISession session) {
        this.fLaunch = launch;
        this.setCDISession(session);
        this.setProject(project);
    }

    @Override
    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    @Override
    public void addRegisterWatch(IWatchable register) {
        if (this.watchedRegisters.contains(register)) {
            return;
        }
        register.clearValue();
        this.watchedRegisters.add(register);
        if (this.fSession != null && this.fSuspended) {
            this.updateWatchedRegisters(register);
        }
    }

    @Override
    public void removeRegisterWatch(IWatchable register) {
        this.watchedRegisters.remove(register);
        this.removedRegisters.add(register);
    }

    @Override
    public void addRegisterWatchListener(IRegisterWatchListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public boolean mayChangeValues() {
        if (this.getCDISession() == null) {
            return false;
        }
        return this.fSuspended;
    }

    @Override
    public void setRegisterValue(IWatchable watchable, long value) {
        MISession miSession = this.getMISession();
        try {
            if (watchable.isSystemRegister()) {
                if (watchable instanceof Bitfield) {
                    Bitfield field = (Bitfield)watchable;
                    long current = this.getSysregValue(miSession, watchable.getAddress());
                    long mask = (1 << field.getSize()) - 1 << field.getNumber();
                    value = current & (mask ^ 0xFFFFFFFFFFFFFFFFL) | value << field.getNumber();
                }
                MIGDBSet cmd = miSession.getCommandFactory().createMIGDBSet(new String[]{"sysreg", String.valueOf(String.valueOf(watchable.getAddress())) + "=0x" + Long.toHexString(value)});
                miSession.postCommand((Command)cmd);
            } else {
                if (watchable instanceof BitfieldInstance) {
                    Bitfield field = ((BitfieldInstance)watchable).getBitfield();
                    long current = this.getRegisterValue(miSession, watchable.getAddress());
                    long mask = (1 << field.getSize()) - 1 << field.getNumber();
                    value = current & (mask ^ 0xFFFFFFFFFFFFFFFFL) | value << field.getNumber();
                }
                MIDataWriteMemory cmd = miSession.getCommandFactory().createMIDataWriteMemory(0L, "0x" + Long.toHexString(watchable.getAddress()), 0, 4, "0x" + Long.toHexString(value));
                miSession.postCommand((Command)cmd);
            }
            this.updateWatchedRegisters(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void removeRegisterWatchListener(IRegisterWatchListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void handleDebugEvents(ICDIEvent[] events) {
        ICDIEvent[] iCDIEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            ICDIEvent event = iCDIEventArray[n2];
            if (event.getSource() instanceof Target) {
                if (event instanceof ICDIDestroyedEvent) {
                    this.setCDISession(null);
                    for (IWatchable watchable : this.watchedRegisters) {
                        watchable.resetValue();
                    }
                    for (IWatchable watchable : this.removedRegisters) {
                        watchable.resetValue();
                    }
                    this.removedRegisters.clear();
                } else {
                    if (this.fSession == null) {
                        return;
                    }
                    if (event instanceof ICDISuspendedEvent) {
                        if (!this.fSuspended) {
                            this.fSuspended = true;
                            this.updateWatchedRegisters(null);
                        }
                    } else if (event instanceof ICDIResumedEvent) {
                        this.fSuspended = false;
                        for (IWatchable watchable : this.watchedRegisters) {
                            watchable.clearValue();
                        }
                        for (IWatchable watchable : this.removedRegisters) {
                            watchable.clearValue();
                        }
                        this.removedRegisters.clear();
                    }
                }
            }
            ++n2;
        }
    }

    private void updateWatchedRegisters(IWatchable added) {
        ArrayList<IWatchable> watchables;
        if (!this.fSuspended) {
            return;
        }
        HashMap<Long, ArrayList<IWatchable>> watchedSysregs = new HashMap<Long, ArrayList<IWatchable>>();
        HashMap<Long, ArrayList<IWatchable>> watchedMemory = new HashMap<Long, ArrayList<IWatchable>>();
        for (IWatchable w : this.watchedRegisters) {
            if (w.isSystemRegister()) {
                this.addToWatchList(watchedSysregs, w);
                continue;
            }
            this.addToWatchList(watchedMemory, w);
        }
        MISession miSession = this.getMISession();
        for (Long address : watchedSysregs.keySet()) {
            watchables = watchedSysregs.get(address);
            this.updateWatchedRegister(miSession, watchables, added);
        }
        for (Long address : watchedMemory.keySet()) {
            watchables = watchedMemory.get(address);
            this.updateWatchedRegister(miSession, watchables, added);
        }
    }

    private void addToWatchList(HashMap<Long, ArrayList<IWatchable>> watchlist, IWatchable w) {
        ArrayList<Object> set = watchlist.get(w.getAddress());
        if (set != null) {
            set.add(w);
        } else {
            set = new ArrayList();
            set.add(w);
            watchlist.put(w.getAddress(), set);
        }
    }

    private void updateWatchedRegister(MISession miSession, ArrayList<IWatchable> relatedWatchables, IWatchable added) {
        IWatchable register = relatedWatchables.get(0);
        long newValue = this.updateWatchedRegister(miSession, register);
        for (IWatchable w : relatedWatchables) {
            w.gotValue();
            if (w.equals(added)) {
                w.setValue(newValue);
                this.notifyListeners(w, IRegisterWatchListener.EventType.CHANGED);
                continue;
            }
            if (w.testValue(newValue)) {
                w.setValue(newValue);
                w.setChanged(true);
                this.notifyListeners(w, IRegisterWatchListener.EventType.CHANGED);
                continue;
            }
            if (added != null) continue;
            w.setChanged(false);
            this.notifyListeners(w, IRegisterWatchListener.EventType.ADDED);
        }
    }

    private long updateWatchedRegister(MISession miSession, IWatchable register) {
        if (register.isSystemRegister()) {
            return this.getSysregValue(miSession, register.getAddress());
        }
        return this.getRegisterValue(miSession, register.getAddress());
    }

    private long getRegisterValue(MISession miSession, long address) {
        MIDataReadMemory cmd = miSession.getCommandFactory().createMIDataReadMemory(0L, String.valueOf(address), 0, 4, 1, 1, null);
        try {
            if (!miSession.isTerminated()) {
                miSession.postCommand((Command)cmd);
                MIDataReadMemoryInfo info = cmd.getMIDataReadMemoryInfo();
                Assert.isTrue((info.getMemories().length == 1 ? 1 : 0) != 0, (String)"Should only get one memory read for watched register.");
                MIMemory memory = info.getMemories()[0];
                Assert.isTrue((address == Long.parseLong(memory.getAddress().substring(2), 16) ? 1 : 0) != 0, (String)"Response memory address did not match register queried.");
                return memory.getData()[0];
            }
        }
        catch (MIException mIException) {}
        return 0L;
    }

    private long getSysregValue(MISession miSession, long address) {
        MIGDBShow cmd = miSession.getCommandFactory().createMIGDBShow(new String[]{"sysreg", "0x" + Long.toHexString(address)});
        try {
            miSession.postCommand((Command)cmd);
            String response = cmd.getMIGDBShowInfo().toString();
            String[] strs = response.split(" *= *");
            Assert.isTrue((strs.length == 2 ? 1 : 0) != 0, (String)("Unexpected response to show sysreg: " + response));
            String number = strs[1].substring(2, strs[1].indexOf("\\"));
            return Long.parseLong(number, 16);
        }
        catch (MIException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    @Override
    public MISession getMISession() {
        ICDITarget[] targets = this.fSession.getTargets();
        Assert.isTrue((targets.length == 1 ? 1 : 0) != 0, (String)("Unexpected number of targets: " + targets.length));
        ICDITarget target = targets[0];
        if (target instanceof Target) {
            return ((Target)target).getMISession();
        }
        return null;
    }

    private void notifyListeners(IWatchable register, IRegisterWatchListener.EventType type) {
        int a = 0;
        while (a < this.listeners.size()) {
            ((IRegisterWatchListener)this.listeners.getListeners()[a]).registerUpdated(register, type);
            ++a;
        }
    }

    @Override
    public ICDISession getCDISession() {
        return this.fSession;
    }

    private void setCDISession(ICDISession session) {
        try {
            if (session == null && this.fSession != null) {
                this.fSession.getEventManager().removeEventListener((ICDIEventListener)this);
                this.fSession = null;
            } else {
                this.fSession = session;
                this.fSession.getEventManager().addEventListener((ICDIEventListener)this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public IWatchable getWatchable(long address) {
        return (IWatchable)this.fPart.findNode((IModelInfo)this.fPart, address);
    }

    @Override
    public Part getPart() {
        return this.fPart;
    }

    public String toString() {
        if (this.getCDISession() == null) {
            return Messages.RegisterWatch_DefaultName;
        }
        return this.getLaunch().getLaunchConfiguration().toString();
    }

    @Override
    public IProject getProject() {
        return this.fProject;
    }

    @Override
    public void setProject(IProject project) {
        this.fProject = project;
        String name = ManagedbuildPlugin.getProjectMCU((IProject)project);
        this.fPart = PartRegistry.getPart((String)name);
    }
}

