/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.internal;

import com.atmel.avr32.target.launch.ErrorStreamConsumer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IFlushableStreamMonitor;
import org.eclipse.debug.core.model.IStreamMonitor;

public class OutputStreamMonitor
implements IFlushableStreamMonitor {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private InputStream fStream;
    private ListenerList fListeners = new ListenerList();
    private StringBuffer fContents;
    private Thread fThread;
    private static final int BUFFER_SIZE = 8192;
    private boolean fKilled = false;
    private long lastSleep;
    private String fEncoding;

    public OutputStreamMonitor(InputStream stream, String encoding) {
        this.fStream = new BufferedInputStream(stream, 8192);
        this.fEncoding = encoding;
        this.fContents = new StringBuffer();
    }

    public synchronized void addListener(IStreamListener listener) {
        this.fListeners.add((Object)listener);
    }

    protected void close() {
        if (this.fThread != null) {
            Thread thread = this.fThread;
            this.fThread = null;
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
            this.fListeners = new ListenerList();
        }
    }

    private void fireStreamAppended(String text) {
        this.getNotifier().notifyAppend(text);
    }

    public synchronized String getContents() {
        return this.fContents.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read() {
        this.lastSleep = System.currentTimeMillis();
        StringBuffer buffer = new StringBuffer();
        long currentTime = this.lastSleep;
        byte[] bytes = new byte[8192];
        int read = 0;
        while (read >= 0) {
            block14: {
                try {
                    if (this.fKilled) break;
                    read = this.fStream.read(bytes);
                    if (read <= 0) break block14;
                    String text = this.fEncoding != null ? new String(bytes, 0, read, this.fEncoding) : new String(bytes, 0, read);
                    OutputStreamMonitor outputStreamMonitor = this;
                    synchronized (outputStreamMonitor) {
                        this.fContents.append(text);
                        buffer.append(text);
                        while (buffer.indexOf(LINE_SEPARATOR) > -1) {
                            this.fireStreamAppended(buffer.substring(0, buffer.indexOf(LINE_SEPARATOR) + LINE_SEPARATOR.length()));
                            buffer.delete(0, buffer.indexOf(LINE_SEPARATOR) + LINE_SEPARATOR.length());
                            buffer.trimToSize();
                        }
                    }
                }
                catch (IOException ioe) {
                    if (!this.fKilled) {
                        DebugPlugin.log((Throwable)ioe);
                    }
                    return;
                }
                catch (NullPointerException e) {
                    if (!this.fKilled && this.fThread != null) {
                        DebugPlugin.log((Throwable)e);
                    }
                    return;
                }
            }
            if ((currentTime = System.currentTimeMillis()) - this.lastSleep <= 1000L) continue;
            this.lastSleep = currentTime;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            this.fStream.close();
        }
        catch (IOException e) {
            DebugPlugin.log((Throwable)e);
        }
    }

    protected void kill() {
        this.fKilled = true;
    }

    public synchronized void removeListener(IStreamListener listener) {
        this.fListeners.remove((Object)listener);
    }

    protected void startMonitoring() {
        if (this.fThread == null) {
            this.fThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    OutputStreamMonitor.this.read();
                }
            }, "Start monitoring");
            this.fThread.setDaemon(true);
            this.fThread.setPriority(1);
            this.fThread.start();
        }
    }

    public synchronized void setBuffered(boolean buffer) {
    }

    public synchronized void flushContents() {
    }

    public synchronized boolean isBuffered() {
        return true;
    }

    private ContentNotifier getNotifier() {
        return new ContentNotifier();
    }

    class ContentNotifier
    implements ISafeRunnable {
        private IStreamListener fListener;
        private String fText;

        ContentNotifier() {
        }

        public void handleException(Throwable exception) {
            DebugPlugin.log((Throwable)exception);
        }

        private String filter(String text) {
            StringBuffer result;
            block9: {
                result = new StringBuffer();
                StringReader sr = new StringReader(text);
                try {
                    try {
                        int p = 10;
                        int c = sr.read();
                        while (c != -1) {
                            if (p == 10 && c == 37) {
                                while (c != 10 && c != -1) {
                                    c = sr.read();
                                }
                            } else {
                                result.append((char)c);
                            }
                            p = c;
                            c = sr.read();
                        }
                        sr.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        sr.close();
                        sr.close();
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    sr.close();
                    throw throwable;
                }
                sr.close();
            }
            return result.toString();
        }

        public void run() throws Exception {
            if (this.fListener instanceof ErrorStreamConsumer) {
                this.fListener.streamAppended(this.fText, (IStreamMonitor)OutputStreamMonitor.this);
            } else {
                this.fListener.streamAppended(this.filter(this.fText), (IStreamMonitor)OutputStreamMonitor.this);
            }
        }

        public void notifyAppend(String text) {
            if (text == null) {
                return;
            }
            this.fText = text;
            Object[] copiedListeners = OutputStreamMonitor.this.fListeners.getListeners();
            int i = 0;
            while (i < copiedListeners.length) {
                this.fListener = (IStreamListener)copiedListeners[i];
                SafeRunner.run((ISafeRunnable)this);
                ++i;
            }
            this.fListener = null;
            this.fText = null;
        }
    }
}

