/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector3;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollectorCleaner;
import org.eclipse.cdt.make.core.scannerconfig.InfoContext;
import org.eclipse.cdt.make.core.scannerconfig.ScannerInfoTypes;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredPathInfo;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredScannerInfoStore;
import org.eclipse.cdt.make.internal.core.scannerconfig.ScannerConfigUtil;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.CygpathTranslator;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class AVR32ScannerInfoCollector
implements IScannerInfoCollector3,
IScannerInfoCollectorCleaner {
    static final String PROPERTY_OS_NAME = "os.name";
    static final String PROPERTY_OS_VALUE = "windows";
    public static final String COLLECTOR_ID = "com.atmel.avr32.debug.PerProjectSICollector";
    private IProject project;
    private InfoContext context;
    private boolean isBuiltinConfig = false;
    private Map<ScannerInfoTypes, List<String>> discoveredSI = new HashMap<ScannerInfoTypes, List<String>>();
    private List<String> sumDiscoveredIncludes = new ArrayList<String>();
    private Map<?, ?> sumDiscoveredSymbols = new LinkedHashMap();
    private boolean scPersisted = false;

    public synchronized void contributeToScannerConfig(Object resource, Map scannerInfo) {
        String errorMessage = null;
        if (resource == null) {
            errorMessage = "resource is null";
        } else if (!(resource instanceof IResource)) {
            errorMessage = "resource is not an IResource";
        } else if (((IResource)resource).getProject() == null) {
            errorMessage = "project is null";
        } else if (!((IResource)resource).getProject().equals((Object)this.project)) {
            errorMessage = "wrong project";
        }
        if (errorMessage != null) {
            TraceUtil.outputError((String)"PerProjectSICollector.contributeToScannerConfig : ", (String)errorMessage);
            return;
        }
        if (this.scPersisted) {
            this.discoveredSI.clear();
            this.scPersisted = false;
        }
        if (AVR32ScannerInfoCollector.isWindows()) {
            List includes = (List)scannerInfo.get(ScannerInfoTypes.INCLUDE_PATHS);
            List translatedIncludes = CygpathTranslator.translateIncludePaths((IProject)this.project, (List)includes);
            ListIterator pathIter = translatedIncludes.listIterator();
            while (pathIter.hasNext()) {
                String convertedPath = (String)pathIter.next();
                if (!convertedPath.startsWith("/")) continue;
                pathIter.remove();
            }
            scannerInfo.put(ScannerInfoTypes.INCLUDE_PATHS, translatedIncludes);
        }
        try {
            if (this.project.hasNature("org.eclipse.cdt.core.cnature") || this.project.hasNature("org.eclipse.cdt.core.ccnature")) {
                for (Object name : scannerInfo.keySet()) {
                    ScannerInfoTypes siType = (ScannerInfoTypes)name;
                    List delta = (List)scannerInfo.get(siType);
                    List<String> discovered = this.discoveredSI.get(siType);
                    if (discovered == null) {
                        discovered = new ArrayList<String>(delta);
                        this.discoveredSI.put(siType, discovered);
                        continue;
                    }
                    boolean addSorted = !this.isBuiltinConfig && siType.equals(ScannerInfoTypes.INCLUDE_PATHS);
                    this.contribute(discovered, delta, addSorted);
                }
            }
        }
        catch (CoreException e) {
            MakeCorePlugin.log((Throwable)e);
        }
    }

    public static boolean isWindows() {
        return System.getProperty(PROPERTY_OS_NAME).toLowerCase().startsWith(PROPERTY_OS_VALUE);
    }

    public void setInfoContext(InfoContext context) {
        this.context = context;
        this.project = context.getProject();
    }

    public void setProject(IProject project) {
        this.project = project;
        this.context = new InfoContext(project);
    }

    private boolean contribute(List<String> discovered, List<String> delta, boolean ordered) {
        if (delta == null || delta.isEmpty()) {
            return false;
        }
        return this.addItemsWithOrder(discovered, delta, ordered);
    }

    private boolean addItemsWithOrder(List<String> sumIncludes, List<String> includes, boolean ordered) {
        if (includes.isEmpty()) {
            return false;
        }
        boolean addedIncludes = false;
        int insertionPoint = ordered ? 0 : sumIncludes.size();
        for (String item : includes) {
            int pos = sumIncludes.indexOf(item);
            if (pos >= 0) {
                if (!ordered) continue;
                insertionPoint = pos + 1;
                continue;
            }
            sumIncludes.add(insertionPoint++, item);
            addedIncludes = true;
        }
        return addedIncludes;
    }

    public synchronized void updateScannerConfiguration(IProgressMonitor monitor) throws CoreException {
        IDiscoveredPathManager.IDiscoveredPathInfo pathInfo;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((pathInfo = MakeCorePlugin.getDefault().getDiscoveryManager().getDiscoveredInfo(this.project, this.context)) instanceof IDiscoveredPathManager.IPerProjectDiscoveredPathInfo) {
            IDiscoveredPathManager.IPerProjectDiscoveredPathInfo projectPathInfo = (IDiscoveredPathManager.IPerProjectDiscoveredPathInfo)pathInfo;
            monitor.beginTask(MakeMessages.getString((String)"ScannerInfoCollector.Processing"), 100);
            if (pathInfo != null) {
                monitor.subTask(MakeMessages.getString((String)"ScannerInfoCollector.Processing"));
                if (this.scannerConfigNeedsUpdate(projectPathInfo)) {
                    monitor.worked(50);
                    monitor.subTask(String.valueOf(MakeMessages.getString((String)"ScannerInfoCollector.Updating")) + this.project.getName());
                    try {
                        ArrayList<IProject> resourceDelta = new ArrayList<IProject>(1);
                        resourceDelta.add(this.project);
                        MakeCorePlugin.getDefault().getDiscoveryManager().updateDiscoveredInfo(this.context, pathInfo, this.context.isDefaultContext(), resourceDelta);
                        monitor.worked(50);
                    }
                    catch (CoreException e) {
                        MakeCorePlugin.log((Throwable)e);
                    }
                }
            }
            monitor.done();
            this.scPersisted = true;
        }
    }

    private boolean scannerConfigNeedsUpdate(IDiscoveredPathManager.IPerProjectDiscoveredPathInfo discPathInfo) {
        boolean addedIncludes = this.includePathsNeedUpdate(discPathInfo);
        boolean addedSymbols = this.definedSymbolsNeedUpdate(discPathInfo);
        return addedIncludes | addedSymbols;
    }

    private boolean includePathsNeedUpdate(IDiscoveredPathManager.IPerProjectDiscoveredPathInfo discPathInfo) {
        boolean addedIncludes = false;
        this.deleteAllSymbols((IResource)this.project);
        List<String> discoveredIncludes = this.discoveredSI.get(ScannerInfoTypes.INCLUDE_PATHS);
        if (discoveredIncludes != null) {
            LinkedHashMap<String, Boolean> newPersistedIncludes;
            addedIncludes = this.addItemsWithOrder(this.sumDiscoveredIncludes, discoveredIncludes, true);
            List finalSumIncludes = CygpathTranslator.translateIncludePaths((IProject)this.project, this.sumDiscoveredIncludes);
            LinkedHashMap<String, Boolean> persistedIncludes = discPathInfo.getIncludeMap();
            persistedIncludes.clear();
            ArrayList<String> persistedKeyList = new ArrayList<String>(persistedIncludes.keySet());
            addedIncludes = this.addItemsWithOrder(persistedKeyList, finalSumIncludes, true);
            if (addedIncludes) {
                newPersistedIncludes = new LinkedHashMap<String, Boolean>(persistedKeyList.size());
                for (String include : persistedKeyList) {
                    if (persistedIncludes.containsKey(include)) {
                        newPersistedIncludes.put(include, (Boolean)persistedIncludes.get(include));
                        continue;
                    }
                    newPersistedIncludes.put(include, new Path(include).toFile().exists() ? Boolean.FALSE : Boolean.TRUE);
                }
            } else {
                newPersistedIncludes = persistedIncludes;
            }
            discPathInfo.setIncludeMap((LinkedHashMap)newPersistedIncludes);
        }
        return addedIncludes;
    }

    private boolean definedSymbolsNeedUpdate(IDiscoveredPathManager.IPerProjectDiscoveredPathInfo discPathInfo) {
        boolean addedSymbols = false;
        this.deleteAllSymbols((IResource)this.project);
        List<String> discoveredSymbols = this.discoveredSI.get(ScannerInfoTypes.SYMBOL_DEFINITIONS);
        if (discoveredSymbols != null) {
            addedSymbols = ScannerConfigUtil.scAddSymbolsList2SymbolEntryMap(this.sumDiscoveredSymbols, discoveredSymbols, (boolean)true);
            LinkedHashMap persistedSymbols = discPathInfo.getSymbolMap();
            persistedSymbols.clear();
            LinkedHashMap candidateSymbols = new LinkedHashMap(persistedSymbols);
            addedSymbols |= ScannerConfigUtil.scAddSymbolEntryMap2SymbolEntryMap(candidateSymbols, this.sumDiscoveredSymbols);
            discPathInfo.setSymbolMap(candidateSymbols);
        }
        return addedSymbols;
    }

    public List<?> getCollectedScannerInfo(Object resource, ScannerInfoTypes type) {
        List<String> rv = null;
        String errorMessage = null;
        if (resource == null) {
            errorMessage = "resource is null";
        } else if (!(resource instanceof IResource)) {
            errorMessage = "resource is not an IResource";
        } else if (((IResource)resource).getProject() == null) {
            errorMessage = "project is null";
        } else if (((IResource)resource).getProject() != this.project) {
            errorMessage = "wrong project";
        }
        if (errorMessage != null) {
            TraceUtil.outputError((String)"PerProjectSICollector.getCollectedScannerInfo : ", (String)errorMessage);
        } else if (this.project.equals((Object)((IResource)resource).getProject())) {
            rv = this.discoveredSI.get(type);
        }
        return rv;
    }

    public void deleteAllPaths(IResource resource) {
        IProject project = resource.getProject();
        if (project != null && project.equals((Object)this.project)) {
            this.sumDiscoveredIncludes.clear();
        }
    }

    public void deleteAllSymbols(IResource resource) {
        IProject project = resource.getProject();
        if (project != null && project.equals((Object)this.project)) {
            this.sumDiscoveredSymbols.clear();
        }
    }

    public void deletePath(IResource resource, String path) {
        IProject project = resource.getProject();
        if (project != null && project.equals((Object)this.project)) {
            this.sumDiscoveredIncludes.remove(path);
        }
    }

    public void deleteSymbol(IResource resource, String symbol) {
        IProject project = resource.getProject();
        if (project != null && project.equals((Object)this.project)) {
            ScannerConfigUtil.removeSymbolEntryValue((String)symbol, this.sumDiscoveredSymbols);
        }
    }

    public void deleteAll(IResource resource) {
        this.deleteAllPaths(resource);
        this.deleteAllSymbols(resource);
    }

    public IDiscoveredPathManager.IDiscoveredPathInfo createPathInfoObject() {
        DiscoveredPathInfo pathInfo = new DiscoveredPathInfo(this.project);
        try {
            DiscoveredScannerInfoStore.getInstance().loadDiscoveredScannerInfoFromState(this.project, this.context, (IDiscoveredPathManager.IDiscoveredScannerInfoSerializable)pathInfo);
        }
        catch (CoreException e) {
            MakeCorePlugin.log((Throwable)e);
        }
        return pathInfo;
    }
}

