/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug.internal;

import com.atmel.avr32.managedbuilder.WindowsBuildPathResolver;
import org.eclipse.cdt.debug.mi.core.GDBServerCDIDebugger2;
import org.eclipse.cdt.debug.mi.core.IGDBServerMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;

public class AVR32GDBServerDebugger
extends GDBServerCDIDebugger2 {
    private static final String MINGW_COMMAND_FACTORY = "com.atmel.avr32.debug.MinGWCommandFactory";
    private static final String LINUX_COMMAND_FACTORY = "org.eclipse.cdt.debug.mi.core.standardLinuxCommandFactory";

    protected String[] getTargetParams(ILaunchConfiguration config, boolean tcpConnection) throws CoreException {
        String remote = null;
        if (tcpConnection) {
            remote = config.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_HOST, "invalid");
            remote = String.valueOf(remote) + ":";
            remote = String.valueOf(remote) + config.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_PORT, "invalid");
        } else {
            remote = config.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_DEV, "invalid");
        }
        return new String[]{"extended-remote", remote};
    }

    protected CommandFactory getCommandFactory(ILaunchConfiguration config) throws CoreException {
        String factoryId = WindowsBuildPathResolver.isWindows() ? MINGW_COMMAND_FACTORY : LINUX_COMMAND_FACTORY;
        CommandFactory factory = MIPlugin.getDefault().getCommandFactoryManager().getCommandFactory(factoryId);
        String miVersion = this.getMIVersion(config);
        if (factory != null) {
            factory.setMIVersion(miVersion);
        }
        return factory != null ? factory : new CommandFactory(miVersion);
    }

    protected IPath getGDBPath(ILaunch launch) throws CoreException {
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        String gdb = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
        return new Path(WindowsBuildPathResolver.getPath((String)gdb));
    }
}

