/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug;

import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class PropertyTester
extends org.eclipse.core.expressions.PropertyTester {
    private static final String PROJECT_TYPE = "ProjectType";
    private static final String AVR32PROJECT_TYPE = "AVR32ProjectType";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof IResource && property.equals(PROJECT_TYPE)) {
            return PropertyTester.isProjectType((IResource)receiver, (String)args[0]);
        }
        if (receiver instanceof IResource && property.equals(AVR32PROJECT_TYPE)) {
            return PropertyTester.isAVR32Project((IResource)receiver);
        }
        return false;
    }

    public static boolean isProjectType(IResource receiver, String projectType) {
        IProject project = receiver.getProject();
        if (ManagedBuildManager.canGetBuildInfo((IResource)project)) {
            IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
            IProjectType type = info.getManagedProject().getProjectType();
            return type != null && type.getBaseId().equals(projectType);
        }
        return true;
    }

    public static boolean isAVR32Project(IResource resource) {
        IProject project = resource.getProject();
        try {
            if (project.exists()) {
                return project.hasNature("com.atmel.avr32.core.nature");
            }
        }
        catch (CoreException coreException) {}
        return false;
    }
}

