/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug;

import com.atmel.avr32.debug.AVR32DebugPlugin;
import com.atmel.avr32.debug.Messages;
import com.atmel.avr32.managedbuilder.ManagedbuildPlugin;
import com.atmel.avr32.target.ITarget;
import com.atmel.avr32.target.TargetPlugin;
import com.atmel.avr32.target.tool.model.TargetInterfaceDescription;
import com.atmel.avr32.util.UtilPlugin;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.mi.core.IGDBServerMILaunchConfigurationConstants;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;

public class DebugUtilities {
    public static String getDefaultGDBPort() {
        Preferences p = TargetPlugin.getDefault().getPluginPreferences();
        return p.getString("com.atmel.avr32.target.DEFAULT_GDB_PORT");
    }

    public static String getDefaultTracePort() {
        Preferences p = TargetPlugin.getDefault().getPluginPreferences();
        return p.getString("com.atmel.avr32.target.DEFAULT_TRACE_PORT");
    }

    public static String getDefaultGDBProxy() {
        Preferences p = TargetPlugin.getDefault().getPluginPreferences();
        return p.getString("com.atmel.avr32.target.DEFAULT_GDBPROXY");
    }

    public static ILaunchConfiguration createStandaloneConfiguration(IBinary bin, ITarget target, String mode) {
        ILaunchConfiguration config = null;
        try {
            ILaunchConfigurationType configType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("com.atmel.avr32.launch.AVR32Application");
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(bin.getElementName()));
            DebugUtilities.initStandaloneConfiguration(bin, target, wc, mode);
            config = wc.doSave();
        }
        catch (CoreException ce) {
            UtilPlugin.error((Object)((Object)ce));
        }
        return config;
    }

    public static void initStandaloneConfiguration(IBinary bin, ITarget target, ILaunchConfigurationWorkingCopy wc, String mode) {
        TargetInterfaceDescription[] tids;
        String interfaceTypeAttribute;
        String mcu;
        wc.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
        wc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", true);
        wc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
        wc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", "org.eclipse.cdt.debug.mi.core.GDBServerCDebugger");
        wc.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_REMOTE_TCP, true);
        wc.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "avr32-gdb");
        wc.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_PORT, DebugUtilities.getDefaultGDBPort());
        wc.setAttribute("AVR32_ATTR_GDB_TRACE_PORT", DebugUtilities.getDefaultTracePort());
        wc.setAttribute("AVR32_ATTR_GDBPROXY", DebugUtilities.getDefaultGDBProxy());
        wc.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_HOST, "localhost");
        wc.setAttribute("AVR32_ATTR_ERASEMETHOD", AVR32DebugPlugin.EraseMethod.ERASE_SECTORS.toString());
        wc.setAttribute("AVR32_ATTR_FILE_RESET", true);
        wc.setAttribute("AVR32_ATTR_FILE_RUN", true);
        wc.setAttribute("AVR32_ATTR_SUPPRESS_PROGRAMMING", false);
        wc.setAttribute("AVR32_ATTR_FILE_VERIFY", false);
        wc.setAttribute("org.eclipse.debug.core.capture_output", false);
        wc.setAttribute("process_factory_id", "com.atmel.avr32.debug.ProcessFactory");
        IProject project = null;
        if (bin != null) {
            wc.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", bin.getResource().getProjectRelativePath().toString());
            wc.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", bin.getCProject().getElementName());
            String base = MessageFormat.format(Messages.DebugUtilities_ConfigurationName, bin.getCProject().getElementName());
            wc.rename(DebugUtilities.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(base));
            project = bin.getResource().getProject();
            wc.setMappedResources((IResource[])new IProject[]{project});
        }
        if (target == null) {
            target = TargetPlugin.getTargetManager().getDefaultTarget();
        }
        if (!(project == null || (mcu = ManagedbuildPlugin.getProjectMCU(project)) == null || target != null && mcu.equals(target.getCpu()))) {
            ITarget[] iTargetArray = TargetPlugin.getTargetManager().getTargets();
            int n = iTargetArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITarget t = iTargetArray[n2];
                if (mcu.equals(t.getCpu())) {
                    target = t;
                    break;
                }
                ++n2;
            }
        }
        if (target != null) {
            wc.setAttribute("AVR32_ATTR_STK_ID", target.getId());
        }
        Assert.isTrue((mode.equals("debug") || mode.equals("run") ? 1 : 0) != 0, (String)(String.valueOf(Messages.DebugUtilities_UnknownLaunchMode) + mode));
        String string = interfaceTypeAttribute = mode.equals("debug") ? "AVR32_ATTR_DEBUG_INTERFACE" : "AVR32_ATTR_RUN_INTERFACE";
        if (target != null && (tids = TargetPlugin.getDefault().getTargetInterfaces(target, mode)).length > 0) {
            wc.setAttribute(interfaceTypeAttribute, tids[0].getId());
        }
    }

    protected static ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    public static void findBinaries(IResource selection, List<IBinary> results) {
        if (selection == null) {
            return;
        }
        ICProject cproject = CoreModel.getDefault().create(selection.getProject());
        if (cproject != null) {
            try {
                IBinary[] bins = cproject.getBinaryContainer().getBinaries();
                int j = 0;
                while (j < bins.length) {
                    if (bins[j].isExecutable()) {
                        results.add(bins[j]);
                    }
                    ++j;
                }
            }
            catch (CModelException cModelException) {}
        }
    }

    public static void findBinaries(Object[] selection, List<IBinary> results, IProgressMonitor pm) throws InterruptedException {
        int nElements = selection.length;
        pm.beginTask("Looking for executables", nElements);
        try {
            SubProgressMonitor sub = new SubProgressMonitor(pm, 1);
            int i = 0;
            while (i < nElements) {
                ICProject cproject;
                IResource r;
                if (selection[i] instanceof IAdaptable && (r = (IResource)((IAdaptable)selection[i]).getAdapter(IResource.class)) != null && (cproject = CoreModel.getDefault().create(r.getProject())) != null) {
                    try {
                        IBinary[] bins = cproject.getBinaryContainer().getBinaries();
                        int j = 0;
                        while (j < bins.length) {
                            if (bins[j].isExecutable()) {
                                results.add(bins[j]);
                            }
                            ++j;
                        }
                    }
                    catch (CModelException cModelException) {}
                }
                if (pm.isCanceled()) {
                    throw new InterruptedException();
                }
                sub.done();
                ++i;
            }
        }
        finally {
            pm.done();
        }
    }
}

