/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.utils.spawner.ProcessFactory;

public class AVR32NM {
    private static Pattern normal_pattern = null;
    private static Pattern single_pattern = null;
    private List<AddressNamePair> text_symbols;
    private List<AddressNamePair> bss_symbols;
    private List<AddressNamePair> data_symbols;
    private List<AddressNamePair> combined_symbols;
    private long stack_start = 0L;
    private long stack_end = 0L;

    private void parseOutput(InputStream stream) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        if (normal_pattern == null) {
            normal_pattern = Pattern.compile("^(\\S+)\\s+(\\S+)\\s+([AaTtBbDd])\\s+(\\S+)");
        }
        if (single_pattern == null) {
            single_pattern = Pattern.compile("^(\\S+)\\s+([AaTtBbDd])\\s+(\\S+)");
        }
        while ((line = reader.readLine()) != null) {
            Matcher normal_matcher = normal_pattern.matcher(line);
            Matcher single_matcher = single_pattern.matcher(line);
            try {
                if (normal_matcher.matches()) {
                    char type = normal_matcher.group(3).charAt(0);
                    String name = normal_matcher.group(4);
                    long address = Long.parseLong(normal_matcher.group(1), 16);
                    long size = Long.parseLong(normal_matcher.group(2), 16);
                    AddressNamePair val = new AddressNamePair(name, address, size);
                    switch (type) {
                        case 'T': 
                        case 't': {
                            this.text_symbols.add(val);
                            break;
                        }
                        case 'B': 
                        case 'b': {
                            this.bss_symbols.add(val);
                            this.combined_symbols.add(val);
                            break;
                        }
                        case 'D': 
                        case 'd': {
                            this.data_symbols.add(val);
                            this.combined_symbols.add(val);
                        }
                    }
                }
                if (!single_matcher.matches()) continue;
                String name = single_matcher.group(3);
                long address = Long.parseLong(single_matcher.group(1), 16);
                if (name.equals("_stack")) {
                    this.stack_start = address;
                }
                if (!name.equals("_estack")) continue;
                this.stack_end = address;
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        }
    }

    public AVR32NM(String file) throws IOException {
        this.init("avr32-nm", new String[]{"-C", "-n", "-a", "-S", file});
    }

    protected void init(String command, String[] params) throws IOException {
        try {
            String[] args = new String[params.length + 1];
            args[0] = command;
            System.arraycopy(params, 0, args, 1, params.length);
            this.text_symbols = new ArrayList<AddressNamePair>();
            this.data_symbols = new ArrayList<AddressNamePair>();
            this.bss_symbols = new ArrayList<AddressNamePair>();
            this.combined_symbols = new ArrayList<AddressNamePair>();
            Process process = ProcessFactory.getFactory().exec(args);
            this.parseOutput(process.getInputStream());
            process.destroy();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AddressNamePair[] getTextSymbols() {
        return this.text_symbols.toArray(new AddressNamePair[0]);
    }

    public AddressNamePair[] getDataSymbols() {
        return this.data_symbols.toArray(new AddressNamePair[0]);
    }

    public AddressNamePair[] getBSSSymbols() {
        return this.bss_symbols.toArray(new AddressNamePair[0]);
    }

    public AddressNamePair[] getCombinedSymbols() {
        return this.combined_symbols.toArray(new AddressNamePair[0]);
    }

    public long getStackStart() {
        return this.stack_start;
    }

    public long getStackEnd() {
        return this.stack_end;
    }

    public class AddressNamePair {
        public String name;
        public long address;
        public long size;

        public AddressNamePair(String n, long a, long s) {
            this.name = n;
            this.address = a;
            this.size = s;
        }

        public String toString() {
            return String.valueOf(this.name) + "@" + Long.toHexString(this.address);
        }
    }
}

