/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.debug;

import com.atmel.avr32.debug.IRegisterWatch;
import com.atmel.avr32.debug.internal.RegisterWatch;
import com.atmel.avr32.target.ITarget;
import com.atmel.avr32.target.TargetPlugin;
import java.util.HashMap;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class AVR32DebugPlugin
extends AbstractUIPlugin {
    public static final String ID_LAUNCH_PARTICIPANTS = "com.atmel.avr32.debug.launchParticipants";
    public static final String AVR32_ATTR_ADDRESS = "AVR32_ATTR_ADDRESS";
    public static final String AVR32_ATTR_DEBUG_INTERFACE = "AVR32_ATTR_DEBUG_INTERFACE";
    public static final String AVR32_ATTR_EXEPATH = "AVR32_ATTR_EXEPATH";
    public static final String AVR32_ATTR_FILE_NAME = "org.eclipse.cdt.launch.PROGRAM_NAME";
    public static final String AVR32_ATTR_GDB_TRACE_PORT = "AVR32_ATTR_GDB_TRACE_PORT";
    public static final String AVR32_ATTR_GDBPROXY = "AVR32_ATTR_GDBPROXY";
    public static final String AVR32_ATTR_OFFSET = "AVR32_ATTR_OFFSET";
    public static final String AVR32_ATTR_POST_FUSES = "AVR32_ATTR_POST_FUSES";
    public static final String AVR32_ATTR_PRE_FUSES = "AVR32_ATTR_PRE_FUSES";
    public static final String AVR32_ATTR_PROJECT_NAME = "org.eclipse.cdt.launch.PROJECT_ATTR";
    public static final String AVR32_ATTR_REMOTE_PATH = "AVR32_ATTR_REMOTE_PATH";
    public static final String AVR32_ATTR_RESET = "AVR32_ATTR_FILE_RESET";
    public static final String AVR32_ATTR_RESETVECTOR = "AVR32_ATTR_RESETVECTOR";
    public static final String AVR32_ATTR_SUPPRESS_PROGRAMMING = "AVR32_ATTR_SUPPRESS_PROGRAMMING";
    public static final String AVR32_ATTR_RUN = "AVR32_ATTR_FILE_RUN";
    public static final String AVR32_ATTR_RUN_INTERFACE = "AVR32_ATTR_RUN_INTERFACE";
    public static final String AVR32_ATTR_STK_ID = "AVR32_ATTR_STK_ID";
    public static final String AVR32_ATTR_VERBOSE = "AVR32_ATTR_VERBOSE";
    public static final String AVR32_ATTR_VERIFY = "AVR32_ATTR_FILE_VERIFY";
    public static final String AVR32_START_PROXY = "AVR32_ATTR_START_PROXY";
    public static final String AVR32_ATTR_ERASEMETHOD = "AVR32_ATTR_ERASEMETHOD";
    public static final String AVR32_DEFAULT_INTERFACE = "AVR32 Program/GDB-Proxy";
    public static final String AVR32_ATTR_FLASHVAULT = "AVR32_ATTR_FLASHVAULT";
    public static final String AVR32_ATTR_DISABLE_DBG = "AVR32_ATTR_DISABLE_DBG";
    public static final String AVR32_GDB = "avr32-gdb";
    public static final String AVR32_LINUX_GDB = "avr32-linux-gdb";
    public static final String AVR32_LINUX_LIB_PROJECT_TYPE = "avr32linux.managedbuild.target.gnu.lib";
    public static final String AVR32_LINUX_PROJECT_TYPE = "avr32linux.managedbuild.target.gnu.exe";
    public static final String AVR32_LINUX_SO_PROJECT_TYPE = "avr32linux.managedbuild.target.gnu.so";
    public static final String AVR32_PROJECT_TYPE = "avr32.managedbuild.target.gnu.exe";
    private static HashMap<ILaunch, IRegisterWatch> fRegisterWatches;
    private static IRegisterWatch fWatchManager;
    public static final String GDBSERVER_ID = "org.eclipse.cdt.debug.mi.core.GDBServerCDebugger";
    public static final String ID_LAUNCH_AVR32APPLICATION = "com.atmel.avr32.launch.AVR32Application";
    public static final String ID_LAUNCH_AVR32LINUXAPPLICATION = "com.atmel.avr32.launch.AVR32LinuxApplication";
    public static final String ID_LAUNCHFACTORY = "com.atmel.avr32.debug.ProcessFactory";
    public static final String NATURE_ID = "com.atmel.avr32.core.nature";
    private static AVR32DebugPlugin plugin;
    public static final String PLUGIN_ID = "com.atmel.avr32.debug";
    @Deprecated
    public static final String PROJECT_TARGET_CPU = "AVR32_PROJECT_TARGET_CPU";
    @Deprecated
    public static final String PROJECT_TYPE = "AVR32_PROJECT_TYPE";
    public static final String REGISTERS_NEWVALUE_PREF = "AVR32_REGISTERS_NEWVALUE";
    public static final String REGISTERS_READONLY_PREF = "AVR32_REGISTERS_READONLY";
    private HashMap<ILaunch, ITarget> fLaunches;
    private LaunchListener fLaunchListener;
    public static final String AVR32_ATTR_AUX_PORT_OVERRIDE = "AVR32_AUX_PORT_OVERRIDE";
    public static final String AVR32_ATTR_AUX_PORT_CONFIGURATION = "AVR32_AUX_PORT_CONFIGURATION";

    public static AVR32DebugPlugin getDefault() {
        if (plugin == null) {
            plugin = new AVR32DebugPlugin();
        }
        return plugin;
    }

    public static IRegisterWatch getRegisterWatch() {
        if (fWatchManager == null) {
            fWatchManager = new RegisterWatch();
        }
        return fWatchManager;
    }

    public AVR32DebugPlugin() {
        plugin = this;
        fRegisterWatches = new HashMap();
        this.fLaunches = new HashMap();
    }

    public void addRegisterWatch(IRegisterWatch watch, ILaunch launch) {
        fRegisterWatches.put(launch, watch);
    }

    public IRegisterWatch getRegisterWatch(ILaunch launch) {
        return fRegisterWatches.get(launch);
    }

    public IRegisterWatch[] getRegisterWatches() {
        return fRegisterWatches.values().toArray(new IRegisterWatch[fRegisterWatches.size()]);
    }

    public void removeRegisterWatch(ILaunch launch) {
        fRegisterWatches.remove(launch);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public void addLaunchListener(ILaunch launch, ITarget target) {
        if (this.fLaunchListener == null) {
            this.fLaunchListener = new LaunchListener();
            DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this.fLaunchListener);
        }
        this.fLaunches.put(launch, target);
    }

    public static enum EraseMethod {
        ERASE_NONE,
        ERASE_SECTORS,
        ERASE_CHIP;

    }

    private class LaunchListener
    implements ILaunchesListener2 {
        private LaunchListener() {
        }

        public void launchesTerminated(ILaunch[] launches) {
            this.freeTarget(launches);
        }

        public void launchesAdded(ILaunch[] launches) {
        }

        public void launchesChanged(ILaunch[] launches) {
        }

        public void launchesRemoved(ILaunch[] launches) {
            this.freeTarget(launches);
        }

        private void freeTarget(ILaunch[] launches) {
            ILaunch[] iLaunchArray = launches;
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                if (AVR32DebugPlugin.this.fLaunches.containsKey(launch)) {
                    TargetPlugin.getTargetManager().releaseTarget((ITarget)AVR32DebugPlugin.this.fLaunches.get(launch));
                    AVR32DebugPlugin.getDefault().removeRegisterWatch(launch);
                    AVR32DebugPlugin.this.fLaunches.remove(launch);
                }
                ++n2;
            }
        }
    }

    public static enum TraceBufferControl {
        DISABLE_TRACE,
        ENTER_DEBUG_MODE,
        OVERWRITE_BUFFER,
        READOUT_AND_CONTINUE;

    }

    public static enum TraceMethod {
        AUX_TRACE,
        STREAMING_AUX_TRACE,
        NANO_TRACE;

    }
}

