/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.io.File;
import java.math.BigInteger;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMixedInstruction;
import org.eclipse.cdt.debug.core.model.IAsmInstruction;
import org.eclipse.cdt.debug.core.model.IDisassemblySourceLine;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;

public class DisassemblySourceLine
extends CDebugElement
implements IDisassemblySourceLine {
    private BigInteger fBaseElement;
    private ICDIMixedInstruction fCDIMixedInstruction;

    public DisassemblySourceLine(CDebugTarget target, BigInteger baseElement, ICDIMixedInstruction mixedInstruction) {
        super(target);
        this.fBaseElement = baseElement;
        this.fCDIMixedInstruction = mixedInstruction;
    }

    public File getFile() {
        String name = this.fCDIMixedInstruction.getFileName();
        if (name != null && name.length() > 0) {
            return new File(name);
        }
        return null;
    }

    public IAsmInstruction[] getInstructions() {
        return null;
    }

    public int getLineNumber() {
        return this.fCDIMixedInstruction.getLineNumber();
    }

    public BigInteger getBaseAddress() {
        return this.fBaseElement;
    }

    public String toString() {
        return String.valueOf(this.fCDIMixedInstruction.getFileName()) + ' ' + this.getLineNumber();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IDisassemblySourceLine)) {
            return false;
        }
        IDisassemblySourceLine other = (IDisassemblySourceLine)obj;
        if (!this.getFile().equals(other.getFile())) {
            return false;
        }
        return this.getLineNumber() == other.getLineNumber();
    }
}

