/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.executables;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.CProjectDescriptionEvent;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionListener;
import org.eclipse.cdt.debug.core.executables.Executable;
import org.eclipse.cdt.debug.core.executables.ExecutablesManager;
import org.eclipse.cdt.debug.core.executables.IExecutableProvider;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;

public class StandardExecutableProvider
implements IResourceChangeListener,
ICProjectDescriptionListener,
IExecutableProvider {
    private ArrayList<Executable> executables = new ArrayList();

    public StandardExecutableProvider() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        CoreModel.getDefault().getProjectDescriptionManager().addCProjectDescriptionListener((ICProjectDescriptionListener)this, 17);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta[] projects;
        IResourceDelta[] iResourceDeltaArray = projects = event.getDelta().getAffectedChildren();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta projectDelta = iResourceDeltaArray[n2];
            if ((projectDelta.getFlags() & 0x4000) != 0 && projectDelta.getKind() == 4) {
                ExecutablesManager.getExecutablesManager().scheduleRefresh(this, 0L);
                return;
            }
            ++n2;
        }
        try {
            final StandardExecutableProvider provider = this;
            event.getDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    IResource deltaResource;
                    if ((delta.getKind() == 1 || delta.getKind() == 2) && (deltaResource = delta.getResource()) != null) {
                        boolean refresh = false;
                        if (delta.getKind() == 2 && deltaResource instanceof IProject) {
                            refresh = true;
                        } else {
                            IPath resourcePath = delta.getResource().getLocation();
                            if (resourcePath != null && Executable.isExecutableFile(resourcePath)) {
                                refresh = true;
                            }
                        }
                        if (refresh) {
                            ExecutablesManager.getExecutablesManager().scheduleRefresh(provider, 0L);
                            return false;
                        }
                    }
                    return true;
                }
            });
        }
        catch (CoreException coreException) {}
    }

    public void handleEvent(CProjectDescriptionEvent event) {
        boolean refresh = false;
        int eventType = event.getEventType();
        if (eventType == 16) {
            ICProjectDescription newDesc = event.getNewCProjectDescription();
            ICProjectDescription oldDesc = event.getOldCProjectDescription();
            if (oldDesc != null && newDesc != null) {
                String oldConfigName;
                String newConfigName = newDesc.getActiveConfiguration().getName();
                refresh = !newConfigName.equals(oldConfigName = oldDesc.getActiveConfiguration().getName());
            } else if (newDesc != null && oldDesc == null) {
                refresh = true;
            }
        }
        if (refresh) {
            ExecutablesManager.getExecutablesManager().scheduleRefresh(this, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Executable[] getExecutables(IProgressMonitor monitor) {
        ArrayList<Executable> arrayList = this.executables;
        synchronized (arrayList) {
            this.executables.clear();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject[] projects = root.getProjects();
            monitor.beginTask("Checking C/C++ Projects", projects.length);
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                block11: {
                    IProject project = iProjectArray[n2];
                    if (monitor.isCanceled()) break;
                    try {
                        if (!CoreModel.hasCNature((IProject)project)) break block11;
                        CModelManager manager = CModelManager.getDefault();
                        ICProject cproject = manager.create(project);
                        try {
                            IBinary[] binaries;
                            IBinary[] iBinaryArray = binaries = cproject.getBinaryContainer().getBinaries();
                            int n3 = binaries.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IBinary binary = iBinaryArray[n4];
                                if (binary.isExecutable() || binary.isSharedLib()) {
                                    IPath exePath = binary.getResource().getLocation();
                                    if (exePath == null) {
                                        exePath = binary.getPath();
                                    }
                                    Executable exe = new Executable(exePath, project, binary.getResource());
                                    this.executables.add(exe);
                                }
                                ++n4;
                            }
                        }
                        catch (CModelException cModelException) {}
                    }
                    catch (Exception e) {
                        DebugPlugin.log((Throwable)e);
                    }
                }
                monitor.worked(1);
                ++n2;
            }
            monitor.done();
        }
        return this.executables.toArray(new Executable[this.executables.size()]);
    }

    public int getPriority() {
        return 50;
    }

    public IStatus removeExecutable(Executable executable, IProgressMonitor monitor) {
        IResource exeResource = executable.getResource();
        if (exeResource != null) {
            if (exeResource.isLinked()) {
                try {
                    exeResource.delete(true, monitor);
                }
                catch (CoreException e) {
                    DebugPlugin.log((Throwable)e);
                }
            }
            return Status.OK_STATUS;
        }
        return new Status(2, "org.eclipse.cdt.debug.core", "Can't remove " + executable.getName() + ": it is built by project \"" + executable.getProject().getName() + "\"");
    }
}

