/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IPreferenceFilter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.preferences.PreferenceTransferElement;
import org.eclipse.ui.internal.preferences.PreferenceTransferManager;
import org.eclipse.ui.internal.wizards.preferences.PreferencesMessages;

public abstract class WizardPreferencesPage
extends WizardPage
implements Listener,
IOverwriteQuery {
    protected Combo destinationNameField;
    private Button destinationBrowseButton;
    private Button overwriteExistingFilesCheckbox;
    protected Table transfersTable;
    protected Text text;
    private Composite buttonComposite;
    private Button allButton;
    protected Button chooseImportsButton;
    private Group group;
    private static final String STORE_DESTINATION_NAMES_ID = "WizardPreferencesExportPage1.STORE_DESTINATION_NAMES_ID";
    private static final String STORE_OVERWRITE_EXISTING_FILES_ID = "WizardPreferencesExportPage1.STORE_OVERWRITE_EXISTING_FILES_ID";
    private static final String TRANSFER_ALL_PREFERENCES_ID = "WizardPreferencesExportPage1.EXPORT_ALL_PREFERENCES_ID";
    private Hashtable imageTable;
    private PreferenceTransferElement[] transfers;
    private String currentMessage;
    private static final String STORE_DESTINATION_ID = null;
    protected static final int COMBO_HISTORY_LENGTH = 5;

    protected WizardPreferencesPage(String pageName) {
        super(pageName);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        GridData buttonData = new GridData(768);
        button.setLayoutData((Object)buttonData);
        button.setData((Object)new Integer(id));
        button.setText(label);
        if (defaultButton) {
            Shell shell = parent.getShell();
            if (shell != null) {
                shell.setDefaultButton(button);
            }
            button.setFocus();
        }
        return button;
    }

    protected void addDestinationItem(String value) {
        this.destinationNameField.add(value);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.createTransferArea(composite);
        this.restoreWidgetValues();
        if (!(this.validDestination() && this.validateOptionsGroup() && this.validateSourceGroup())) {
            this.setPageComplete(false);
        }
        this.setPreferenceTransfers();
        this.setControl((Control)composite);
        this.giveFocusToDestination();
        Dialog.applyDialogFont((Control)composite);
    }

    protected abstract void createTransferArea(Composite var1);

    protected boolean validateDestinationGroup() {
        if (!this.validDestination()) {
            this.currentMessage = this.getInvalidDestinationMessage();
            return false;
        }
        return true;
    }

    protected abstract String getInvalidDestinationMessage();

    private String getNoOptionsMessage() {
        return PreferencesMessages.WizardPreferencesPage_noOptionsSelected;
    }

    protected boolean validDestination() {
        File file = new File(this.getDestinationValue());
        return file.getPath().length() > 0 && !file.isDirectory();
    }

    protected void setPreferenceTransfers() {
        PreferenceTransferElement[] transfers = this.getTransfers();
        this.transfersTable.removeAll();
        int i = 0;
        while (i < transfers.length) {
            PreferenceTransferElement element = transfers[i];
            this.createItem(element, this.transfersTable);
            ++i;
        }
    }

    protected PreferenceTransferElement[] getTransfers() {
        if (this.transfers == null) {
            this.transfers = PreferenceTransferManager.getPreferenceTransfers();
        }
        return this.transfers;
    }

    private void createItem(PreferenceTransferElement element, Table table) {
        TableItem item = new TableItem(table, 32);
        item.setText(element.getName());
        item.setData((Object)element);
        ImageDescriptor descriptor = element.getImageDescriptor();
        Image image = null;
        if (descriptor != null) {
            Hashtable images = this.getImageTable();
            image = (Image)images.get(descriptor);
            if (image == null) {
                image = descriptor.createImage();
                images.put(descriptor, image);
            }
            item.setImage(image);
        }
    }

    private Hashtable getImageTable() {
        if (this.imageTable == null) {
            this.imageTable = new Hashtable(10);
        }
        return this.imageTable;
    }

    protected void createTransfersList(Composite composite) {
        this.allButton = new Button(composite, 16);
        this.allButton.setText(this.getAllButtonText());
        this.chooseImportsButton = new Button(composite, 16);
        this.chooseImportsButton.setText(this.getChooseButtonText());
        this.group = new Group(composite, 0);
        this.group.setText(PreferencesMessages.WizardPreferencesExportPage1_preferences);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        this.group.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        this.group.setLayout((Layout)layout);
        this.transfersTable = new Table((Composite)this.group, 2080);
        this.transfersTable.setLayoutData((Object)new GridData(1808));
        Label description = new Label((Composite)this.group, 0);
        description.setLayoutData((Object)new GridData(768));
        description.setText(PreferencesMessages.WizardPreferences_description);
        this.text = new Text((Composite)this.group, 2632);
        this.text.setLayoutData((Object)new GridData(1808));
        SelectionListener selection = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget == WizardPreferencesPage.this.transfersTable) {
                    this.updateState(e);
                    this.updateDescription();
                }
                WizardPreferencesPage.this.updatePageCompletion();
            }

            private void updateState(SelectionEvent e) {
                if (((TableItem)e.item).getChecked()) {
                    WizardPreferencesPage.this.allButton.setSelection(false);
                    WizardPreferencesPage.this.chooseImportsButton.setSelection(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            private void updateDescription() {
                if (WizardPreferencesPage.this.transfersTable.getSelectionCount() > 0) {
                    TableItem item = WizardPreferencesPage.this.transfersTable.getSelection()[0];
                    WizardPreferencesPage.this.text.setText(((PreferenceTransferElement)item.getData()).getDescription());
                } else {
                    WizardPreferencesPage.this.text.setText("");
                }
            }
        };
        this.transfersTable.addSelectionListener(selection);
        this.chooseImportsButton.addSelectionListener(selection);
        this.allButton.addSelectionListener(selection);
        this.addSelectionButtons((Composite)this.group);
    }

    protected abstract String getChooseButtonText();

    protected abstract String getAllButtonText();

    private void addSelectionButtons(Composite composite) {
        Font parentFont = composite.getFont();
        this.buttonComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(512);
        data.grabExcessHorizontalSpace = true;
        this.buttonComposite.setLayoutData((Object)data);
        this.buttonComposite.setFont(parentFont);
        Button selectButton = this.createButton(this.buttonComposite, 18, PreferencesMessages.SelectionDialog_selectLabel, false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardPreferencesPage.this.setAllChecked(true);
                WizardPreferencesPage.this.updatePageCompletion();
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        selectButton.setFont(parentFont);
        Button deselectButton = this.createButton(this.buttonComposite, 19, PreferencesMessages.SelectionDialog_deselectLabel, false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardPreferencesPage.this.setAllChecked(false);
                WizardPreferencesPage.this.updatePageCompletion();
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
        deselectButton.setFont(parentFont);
    }

    protected void setAllChecked(boolean bool) {
        TableItem[] items = this.transfersTable.getItems();
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            item.setChecked(bool);
            ++i;
        }
    }

    protected void createDestinationGroup(Composite parent) {
        Composite destinationSelectionGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        destinationSelectionGroup.setLayout((Layout)layout);
        destinationSelectionGroup.setLayoutData((Object)new GridData(272));
        Label dest = new Label(destinationSelectionGroup, 0);
        dest.setText(this.getDestinationLabel());
        this.destinationNameField = new Combo(destinationSelectionGroup, 2052);
        this.destinationNameField.addListener(24, (Listener)this);
        this.destinationNameField.addListener(13, (Listener)this);
        GridData data = new GridData(768);
        this.destinationNameField.setLayoutData((Object)data);
        this.destinationBrowseButton = new Button(destinationSelectionGroup, 8);
        this.destinationBrowseButton.setText(PreferencesMessages.PreferencesExport_browse);
        this.destinationBrowseButton.setLayoutData((Object)new GridData(256));
        this.destinationBrowseButton.addListener(13, (Listener)this);
        new Label(parent, 0);
    }

    protected void createOptionsGroup(Composite parent) {
        Composite optionsGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        optionsGroup.setLayout((Layout)layout);
        optionsGroup.setLayoutData((Object)new GridData(768));
        this.overwriteExistingFilesCheckbox = new Button(optionsGroup, 16416);
        this.overwriteExistingFilesCheckbox.setText(PreferencesMessages.ExportFile_overwriteExisting);
    }

    protected boolean ensureDirectoryExists(File directory) {
        if (!directory.exists()) {
            if (!this.queryYesNoQuestion(PreferencesMessages.PreferencesExport_createTargetDirectory)) {
                return false;
            }
            if (!directory.mkdirs()) {
                MessageDialog.open((int)1, (Shell)this.getContainer().getShell(), (String)PreferencesMessages.PreferencesExport_error, (String)PreferencesMessages.PreferencesExport_directoryCreationError, (int)0x10000000);
                return false;
            }
        }
        return true;
    }

    protected boolean queryYesNoQuestion(String message) {
        MessageDialog dialog = new MessageDialog(this.getContainer().getShell(), PreferencesMessages.Question, null, message, 0, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0){

            protected int getShellStyle() {
                return super.getShellStyle() | 0x10000000;
            }
        };
        return dialog.open() == 0;
    }

    protected boolean ensureTargetIsValid(File file) {
        File parent;
        if (file.exists()) {
            String msg;
            if (!this.getOverwriteExisting() && !this.queryYesNoQuestion(msg = NLS.bind((String)PreferencesMessages.WizardPreferencesExportPage1_overwrite, (Object)file.getAbsolutePath()))) {
                return false;
            }
            file.delete();
        } else if (!file.isDirectory() && (parent = file.getParentFile()) != null) {
            file.getParentFile().mkdirs();
        }
        return true;
    }

    protected void saveWidgetValues() {
        this.internalSaveWidgetValues();
    }

    public boolean finish() {
        this.saveWidgetValues();
        IPreferenceFilter[] transfers = null;
        transfers = this.getTransferAll() ? new IPreferenceFilter[]{new IPreferenceFilter(){

            public String[] getScopes() {
                return new String[]{"instance", "configuration"};
            }

            public Map getMapping(String scope) {
                return null;
            }
        }} : this.getFilters();
        boolean success = this.transfer(transfers);
        if (success) {
            this.saveWidgetValues();
        }
        return success;
    }

    protected IPreferenceFilter[] getFilters() {
        IPreferenceFilter[] filters = null;
        PreferenceTransferElement[] transferElements = this.getPreferenceTransferElements();
        if (transferElements != null) {
            filters = new IPreferenceFilter[transferElements.length];
            int j = 0;
            while (j < transferElements.length) {
                PreferenceTransferElement element = transferElements[j];
                try {
                    filters[j] = element.getFilter();
                }
                catch (CoreException e) {
                    WorkbenchPlugin.log(e.getMessage(), e);
                }
                ++j;
            }
        } else {
            filters = new IPreferenceFilter[]{};
        }
        return filters;
    }

    protected PreferenceTransferElement[] getPreferenceTransferElements() {
        TableItem[] items = this.transfersTable.getItems();
        ArrayList<Object> transferList = new ArrayList<Object>();
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            if (item.getChecked()) {
                transferList.add(item.getData());
            }
            ++i;
        }
        PreferenceTransferElement[] transferElements = new PreferenceTransferElement[transferList.size()];
        i = 0;
        Iterator iter = transferList.iterator();
        while (iter.hasNext()) {
            transferElements[i] = (PreferenceTransferElement)iter.next();
            ++i;
        }
        return transferElements;
    }

    protected abstract boolean transfer(IPreferenceFilter[] var1);

    public void setPageComplete() {
        boolean complete = true;
        if (!this.determinePageCompletion()) {
            complete = false;
        }
        super.setPageComplete(complete);
    }

    protected boolean determinePageCompletion() {
        boolean complete;
        boolean bl = complete = this.validateSourceGroup() && this.validateDestinationGroup() && this.validateOptionsGroup();
        if (complete) {
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(this.currentMessage);
        }
        return complete;
    }

    protected boolean validateOptionsGroup() {
        if (this.chooseImportsButton.getSelection()) {
            TableItem[] items = this.transfersTable.getItems();
            int i = 0;
            while (i < items.length) {
                TableItem item = items[i];
                if (item.getChecked()) {
                    return true;
                }
                ++i;
            }
            this.currentMessage = this.getNoOptionsMessage();
            return false;
        }
        return true;
    }

    protected boolean validateSourceGroup() {
        return true;
    }

    protected abstract String getDestinationLabel();

    protected String getDestinationValue() {
        return this.destinationNameField.getText().trim();
    }

    protected void giveFocusToDestination() {
        this.destinationNameField.setFocus();
    }

    protected void handleDestinationBrowseButtonPressed() {
        FileDialog dialog = new FileDialog(this.getContainer().getShell(), this.getFileDialogStyle());
        dialog.setText(this.getFileDialogTitle());
        dialog.setFilterPath(this.getDestinationValue());
        dialog.setFilterExtensions(new String[]{"*.epf", "*.*"});
        String selectedFileName = dialog.open();
        if (selectedFileName != null) {
            this.setDestinationValue(selectedFileName);
        }
    }

    protected abstract String getFileDialogTitle();

    protected abstract int getFileDialogStyle();

    public void handleEvent(Event e) {
        Widget source = e.widget;
        if (source == this.destinationBrowseButton) {
            this.handleDestinationBrowseButtonPressed();
        }
        this.updatePageCompletion();
    }

    protected void updatePageCompletion() {
        boolean pageComplete = this.determinePageCompletion();
        this.setPageComplete(pageComplete);
        if (pageComplete) {
            this.setMessage(null);
        }
    }

    protected void internalSaveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(STORE_DESTINATION_NAMES_ID);
            if (directoryNames == null) {
                directoryNames = new String[]{};
            }
            directoryNames = this.addToHistory(directoryNames, this.getDestinationValue());
            settings.put(STORE_DESTINATION_NAMES_ID, directoryNames);
            String current = this.getDestinationValue();
            if (current != null && !current.equals("")) {
                settings.put(STORE_DESTINATION_ID, current);
            }
            if (this.overwriteExistingFilesCheckbox != null) {
                settings.put(STORE_OVERWRITE_EXISTING_FILES_ID, this.overwriteExistingFilesCheckbox.getSelection());
            }
            settings.put(TRANSFER_ALL_PREFERENCES_ID, this.allButton.getSelection());
        }
    }

    protected String[] addToHistory(String[] history, String newEntry) {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(history));
        this.addToHistory(l, newEntry);
        String[] r = new String[l.size()];
        l.toArray(r);
        return r;
    }

    protected void addToHistory(List history, String newEntry) {
        history.remove(newEntry);
        history.add(0, newEntry);
        if (history.size() > 5) {
            history.remove(5);
        }
    }

    protected void restoreWidgetValues() {
        String[] directoryNames;
        IDialogSettings settings = this.getDialogSettings();
        boolean all = true;
        if (settings != null && (directoryNames = settings.getArray(STORE_DESTINATION_NAMES_ID)) != null) {
            this.setDestinationValue(directoryNames[0]);
            int i = 0;
            while (i < directoryNames.length) {
                this.addDestinationItem(directoryNames[i]);
                ++i;
            }
            String current = settings.get(STORE_DESTINATION_ID);
            if (current != null) {
                this.setDestinationValue(current);
            }
            if (this.overwriteExistingFilesCheckbox != null) {
                this.overwriteExistingFilesCheckbox.setSelection(settings.getBoolean(STORE_OVERWRITE_EXISTING_FILES_ID));
            }
            all = settings.getBoolean(TRANSFER_ALL_PREFERENCES_ID);
        }
        if (all) {
            this.allButton.setSelection(true);
        } else {
            this.chooseImportsButton.setSelection(true);
        }
    }

    private boolean getOverwriteExisting() {
        return this.overwriteExistingFilesCheckbox.getSelection();
    }

    private boolean getTransferAll() {
        return this.allButton.getSelection();
    }

    protected void setDestinationValue(String value) {
        this.destinationNameField.setText(value);
    }

    public void dispose() {
        super.dispose();
        if (this.imageTable == null) {
            return;
        }
        Iterator i = this.imageTable.values().iterator();
        while (i.hasNext()) {
            ((Image)i.next()).dispose();
        }
        this.imageTable = null;
        this.transfers = null;
    }

    protected boolean allowNewContainerName() {
        return true;
    }

    public String queryOverwrite(String pathString) {
        Path path = new Path(pathString);
        String messageString = path.getFileExtension() == null || path.segmentCount() < 2 ? NLS.bind((String)PreferencesMessages.WizardDataTransfer_existsQuestion, (Object)pathString) : NLS.bind((String)PreferencesMessages.WizardDataTransfer_overwriteNameAndPathQuestion, (Object)path.lastSegment(), (Object)path.removeLastSegments(1).toOSString());
        final MessageDialog dialog = new MessageDialog(this.getContainer().getShell(), PreferencesMessages.Question, null, messageString, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL}, 0){

            protected int getShellStyle() {
                return super.getShellStyle() | 0x10000000;
            }
        };
        String[] response = new String[]{"YES", "ALL", "NO", "NOALL", "CANCEL"};
        this.getControl().getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
        return dialog.getReturnCode() < 0 ? "CANCEL" : response[dialog.getReturnCode()];
    }
}

