/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Platform;

public class CssUtil {
    private static final String cssLink1 = "<link rel=\"stylesheet\" href=\"../content/PLUGINS_ROOT";
    private static final String cssLink2 = "\" type=\"text/css\"></link>\n";

    private static String replaceParameters(String input) {
        int index = input.indexOf("${os}");
        if (index < 0) {
            return input;
        }
        String result = String.valueOf(input.substring(0, index)) + Platform.getOS() + input.substring(index + "${os}".length());
        return CssUtil.replaceParameters(result);
    }

    public static String[] getCssFilenames(String filenames) {
        if (filenames == null) {
            return new String[0];
        }
        StringTokenizer tok = new StringTokenizer(filenames, ",");
        String[] result = new String[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            result[i] = CssUtil.replaceParameters(tok.nextToken().trim());
            ++i;
        }
        return result;
    }

    public static void addCssFiles(String preference, List list) {
        String topicCssPath = Platform.getPreferencesService().getString("org.eclipse.help.base", preference, "", null);
        String[] cssFiles = CssUtil.getCssFilenames(topicCssPath);
        int i = 0;
        while (i < cssFiles.length) {
            list.add(cssFiles[i]);
            ++i;
        }
    }

    public static String createCssIncludes(List cssFiles) {
        StringBuffer script = new StringBuffer();
        Iterator iter = cssFiles.iterator();
        while (iter.hasNext()) {
            String cssPath = (String)iter.next();
            script.append(cssLink1);
            script.append(cssPath);
            script.append(cssLink2);
        }
        return script.toString();
    }
}

