/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.tool.simulator;

import com.atmel.avr32.target.AbstractAdapterInterface;
import com.atmel.avr32.target.FuseRegisterSettings;
import com.atmel.avr32.target.ITarget;
import com.atmel.avr32.target.ITargetInterface;
import com.atmel.avr32.target.Target;
import com.atmel.avr32.target.TargetCommandStatus;
import com.atmel.avr32.target.TargetPlugin;
import com.atmel.avr32.target.ToolRegistry;
import com.atmel.avr32.target.tool.model.Clock;
import com.atmel.avr32.target.tool.model.Tool;
import com.atmel.avr32.target.tool.model.Voltage;
import com.atmel.avr32.target.ui.TargetAction;
import com.atmel.avr32.tool.simulator.Messages;
import com.atmel.avr32.util.UtilPlugin;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.eclipse.cdt.debug.mi.core.IGDBServerMILaunchConfigurationConstants;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;

public class SimulatorAdapter
extends AbstractAdapterInterface
implements ITargetInterface {
    public static final String INTERFACE_ID = "AVR32 Simulator";
    private LaunchOptions options;

    private int getGDBPort() {
        Preferences p = TargetPlugin.getDefault().getPluginPreferences();
        return p.getInt("com.atmel.avr32.target.DEFAULT_GDB_PORT");
    }

    private int getTracePort() {
        Preferences p = TargetPlugin.getDefault().getPluginPreferences();
        return p.getInt("com.atmel.avr32.target.DEFAULT_TRACE_PORT");
    }

    private String getGDbProxy() {
        Preferences p = TargetPlugin.getDefault().getPluginPreferences();
        return p.getString("com.atmel.avr32.target.DEFAULT_GDBPROXY");
    }

    public TargetCommandStatus execute(TargetAction action, IProgressMonitor monitor) {
        Assert.isNotNull((Object)this.getTarget(), (String)Messages.SimulatorAdapter_NullTargetError);
        return new TargetCommandStatus(4, "com.atmel.avr32.tool.simulator", Messages.SimulatorAdapter_NotApplicable, null);
    }

    public IStatus launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) {
        Assert.isNotNull((Object)this.getTarget(), (String)Messages.SimulatorAdapter_NullTargetError);
        int ticks = 200;
        if (mode.equals("debug")) {
            ticks = 350;
        }
        monitor.beginTask(Messages.SimulatorAdapter_Launching, ticks);
        if (!mode.equals("debug")) {
            return new Status(4, "com.atmel.avr32.tool.simulator", Messages.SimulatorAdapter_SimOnlyInDebugSession);
        }
        monitor.subTask(Messages.SimulatorAdapter_LaunchingGDBProxy);
        IStatus status = this.gdbproxy(configuration, launch, monitor);
        monitor.worked(50);
        monitor.done();
        return status;
    }

    public IStatus list(IProgressMonitor monitor) {
        if (TargetPlugin.getTargetManager().getTarget(INTERFACE_ID, "0") == null) {
            String[] parts;
            Target simTarget = new Target(INTERFACE_ID, "0");
            simTarget.setAdapterName(INTERFACE_ID);
            simTarget.setBoardName(INTERFACE_ID);
            Tool simTool = ToolRegistry.getTool((String)INTERFACE_ID);
            if (simTool != null && (parts = simTool.getSupportedParts()).length > 0) {
                simTarget.setCpu(parts[0]);
            }
            TargetPlugin.getTargetManager().addTarget((ITarget)simTarget);
        }
        return Status.OK_STATUS;
    }

    private IStatus gdbproxy(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) {
        TargetCommandStatus status;
        String[] proxy;
        try {
            configuration.getAttribute("AVR32_ATTR_STK_ID", 0);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return new Status(4, "com.atmel.avr32.tool.simulator", 0, Messages.SimulatorAdapter_BadTargetError, (Throwable)e);
        }
        this.options = new LaunchOptions(configuration);
        ArrayList<String> commandline = new ArrayList<String>();
        String[] stringArray = proxy = this.options.gdbproxy.split(" ");
        int n = proxy.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            commandline.add(string);
            ++n2;
        }
        commandline.add("-t");
        commandline.add(String.valueOf(this.options.proxyhost) + ":" + this.options.proxytraceport);
        commandline.add("-a");
        commandline.add(String.valueOf(this.options.proxyhost) + ":" + this.options.proxyport);
        commandline.add("-s");
        commandline.add(this.getTarget().getCpu());
        IFile exec = ResourcesPlugin.getWorkspace().getRoot().getProject(this.options.project).getFile(this.options.file);
        commandline.add("-F");
        commandline.add(exec.getLocation().toOSString());
        if (!this.options.resetvector) {
            commandline.add("-p" + this.options.offset);
        }
        if (this.options.verbose) {
            commandline.add("-d");
        }
        if ((status = this.createProcess(commandline, AbstractAdapterInterface.WaitMode.NO_WAIT, launch, monitor)).isOK()) {
            int count = 0;
            while (count++ < 10) {
                try {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {}
                    UtilPlugin.debug((Object)(String.valueOf(Messages.SimulatorAdapter_PingingGDBProxy) + this.options.proxyhost + ":" + this.options.proxytraceport));
                    Socket skt = new Socket(this.options.proxyhost, Integer.parseInt(this.options.proxytraceport));
                    skt.close();
                    return status;
                }
                catch (UnknownHostException e) {
                    this.terminate(launch);
                    return new Status(4, "com.atmel.avr32.tool.simulator", 0, Messages.SimulatorAdapter_GDBProxyError, (Throwable)e);
                }
                catch (IOException iOException) {}
            }
            return new Status(4, "com.atmel.avr32.tool.simulator", 0, Messages.SimulatorAdapter_GDBProxyCommError, null);
        }
        return status;
    }

    private void terminate(ILaunch launch) {
        try {
            launch.terminate();
        }
        catch (DebugException e1) {
            e1.printStackTrace();
        }
    }

    public IStatus applyClockFrequency(Clock clock) {
        return Status.CANCEL_STATUS;
    }

    public IStatus readVoltages(Voltage[] voltages) {
        return Status.CANCEL_STATUS;
    }

    public IStatus setClockFrequency(Clock clock) {
        return Status.CANCEL_STATUS;
    }

    public IStatus applyVoltages(Voltage[] voltages) {
        return Status.CANCEL_STATUS;
    }

    public IStatus applyFuseSettings(FuseRegisterSettings fuses, IProgressMonitor monitor) {
        return Status.CANCEL_STATUS;
    }

    public IStatus readFuseSettings(FuseRegisterSettings fuses, IProgressMonitor monitor) {
        return Status.CANCEL_STATUS;
    }

    private class LaunchOptions {
        private static final String DEFAULT_HOST = "localhost";
        private static final String EMPTY_STRING = "";
        boolean verbose = true;
        boolean resetvector = true;
        String file = "";
        String project = "";
        String offset = "";
        String gdbproxy = "";
        String proxyhost = "";
        String proxyport = "";
        String proxytraceport = "";

        public LaunchOptions(ILaunchConfiguration configuration) {
            try {
                this.resetvector = configuration.getAttribute("AVR32_ATTR_RESETVECTOR", true);
                this.file = configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", EMPTY_STRING);
                this.project = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", EMPTY_STRING);
                this.offset = configuration.getAttribute("AVR32_ATTR_OFFSET", EMPTY_STRING);
                this.verbose = configuration.getAttribute("AVR32_ATTR_VERBOSE", false);
                this.gdbproxy = configuration.getAttribute("AVR32_ATTR_GDBPROXY", SimulatorAdapter.this.getGDbProxy());
                this.proxytraceport = configuration.getAttribute("AVR32_ATTR_GDB_TRACE_PORT", String.valueOf(SimulatorAdapter.this.getTracePort()));
                this.proxyport = configuration.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_PORT, String.valueOf(SimulatorAdapter.this.getGDBPort()));
                this.proxyhost = configuration.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_HOST, DEFAULT_HOST);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }
}

