/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.ui.editor;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.DefaultTextHover;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.mylyn.internal.wikitext.ui.editor.assist.AnchorCompletionProcessor;
import org.eclipse.mylyn.internal.wikitext.ui.editor.assist.MarkupTemplateCompletionProcessor;
import org.eclipse.mylyn.internal.wikitext.ui.editor.assist.MultiplexingContentAssistProcessor;
import org.eclipse.mylyn.internal.wikitext.ui.editor.outline.QuickOutlinePopupDialog;
import org.eclipse.mylyn.internal.wikitext.ui.editor.reconciler.MarkupMonoReconciler;
import org.eclipse.mylyn.internal.wikitext.ui.editor.reconciler.MarkupValidationReconcilingStrategy;
import org.eclipse.mylyn.internal.wikitext.ui.editor.reconciler.MultiReconcilingStrategy;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.FastMarkupPartitioner;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.MarkupDamagerRepairer;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.MarkupTokenScanner;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineItem;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineParser;
import org.eclipse.mylyn.wikitext.ui.viewer.AbstractTextSourceViewerConfiguration;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.texteditor.HippieProposalProcessor;

public class MarkupSourceViewerConfiguration
extends AbstractTextSourceViewerConfiguration {
    private ITokenScanner scanner;
    private MarkupTemplateCompletionProcessor completionProcessor;
    private AnchorCompletionProcessor anchorCompletionProcessor;
    private MarkupLanguage markupLanguage;
    private MarkupValidationReconcilingStrategy markupValidationReconcilingStrategy;
    private IFile file;
    private ITextHover textHover;
    private OutlineItem outline;
    private Font defaultFont = JFaceResources.getDefaultFont();
    private Font defaultMonospaceFont;
    private InformationPresenter informationPresenter;
    private IShowInTarget showInTarget;

    public MarkupSourceViewerConfiguration(IPreferenceStore preferenceStore) {
        super(preferenceStore);
    }

    public ITokenScanner getMarkupScanner() {
        if (this.scanner == null) {
            this.scanner = new MarkupTokenScanner(this.defaultFont, this.defaultMonospaceFont);
        }
        return this.scanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        MarkupDamagerRepairer damagerRepairer = new MarkupDamagerRepairer(this.getMarkupScanner());
        String[] stringArray = FastMarkupPartitioner.ALL_CONTENT_TYPES;
        int n = FastMarkupPartitioner.ALL_CONTENT_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String partitionType = stringArray[n2];
            reconciler.setDamager((IPresentationDamager)damagerRepairer, partitionType);
            reconciler.setRepairer((IPresentationRepairer)damagerRepairer, partitionType);
            ++n2;
        }
        reconciler.setDamager((IPresentationDamager)damagerRepairer, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)damagerRepairer, "__dftl_partition_content_type");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        int n;
        if (this.completionProcessor == null) {
            this.completionProcessor = new MarkupTemplateCompletionProcessor();
            this.completionProcessor.setMarkupLanguage(this.markupLanguage);
        }
        if (this.anchorCompletionProcessor == null && this.outline != null) {
            this.anchorCompletionProcessor = new AnchorCompletionProcessor();
            this.anchorCompletionProcessor.setOutline(this.outline);
        }
        HippieProposalProcessor hippieProcessor = new HippieProposalProcessor();
        MultiplexingContentAssistProcessor processor = new MultiplexingContentAssistProcessor();
        if (this.anchorCompletionProcessor != null) {
            processor.addDelegate(this.anchorCompletionProcessor);
        }
        processor.addDelegate((IContentAssistProcessor)this.completionProcessor);
        processor.addDelegate((IContentAssistProcessor)hippieProcessor);
        IContentAssistProcessor[] processors = this.createContentAssistProcessors();
        if (processors != null) {
            IContentAssistProcessor[] iContentAssistProcessorArray = processors;
            n = processors.length;
            int n2 = 0;
            while (n2 < n) {
                IContentAssistProcessor cap = iContentAssistProcessorArray[n2];
                processor.addDelegate(cap);
                ++n2;
            }
        }
        ContentAssistant assistant = new ContentAssistant();
        assistant.enableAutoActivation(true);
        assistant.enableAutoInsert(true);
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        String[] stringArray = FastMarkupPartitioner.ALL_CONTENT_TYPES;
        int n3 = FastMarkupPartitioner.ALL_CONTENT_TYPES.length;
        n = 0;
        while (n < n3) {
            String partitionType = stringArray[n];
            assistant.setContentAssistProcessor((IContentAssistProcessor)processor, partitionType);
            ++n;
        }
        return assistant;
    }

    protected IContentAssistProcessor[] createContentAssistProcessors() {
        return null;
    }

    public void setMarkupLanguage(MarkupLanguage markupLanguage) {
        this.markupLanguage = markupLanguage;
        if (this.completionProcessor != null) {
            this.completionProcessor.setMarkupLanguage(markupLanguage);
        }
        if (this.markupValidationReconcilingStrategy != null) {
            this.markupValidationReconcilingStrategy.setMarkupLanguage(markupLanguage);
        }
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        Object strategy;
        Object reconciler;
        if (this.markupValidationReconcilingStrategy == null) {
            this.markupValidationReconcilingStrategy = new MarkupValidationReconcilingStrategy(sourceViewer);
            this.markupValidationReconcilingStrategy.setMarkupLanguage(this.markupLanguage);
            this.markupValidationReconcilingStrategy.setResource((IResource)this.file);
        }
        if ((reconciler = super.getReconciler(sourceViewer)) != null) {
            MultiReconcilingStrategy multiStrategy = new MultiReconcilingStrategy();
            String[] stringArray = FastMarkupPartitioner.ALL_CONTENT_TYPES;
            int n = FastMarkupPartitioner.ALL_CONTENT_TYPES.length;
            int n2 = 0;
            while (n2 < n) {
                String contentType = stringArray[n2];
                this.maybeAddReconcilingStrategyForContentType(multiStrategy, (IReconciler)reconciler, contentType);
                ++n2;
            }
            this.maybeAddReconcilingStrategyForContentType(multiStrategy, (IReconciler)reconciler, "__dftl_partition_content_type");
            multiStrategy.add(this.markupValidationReconcilingStrategy);
            strategy = multiStrategy;
        } else {
            strategy = this.markupValidationReconcilingStrategy;
        }
        reconciler = new MarkupMonoReconciler((IReconcilingStrategy)strategy, false);
        reconciler.setIsIncrementalReconciler(false);
        reconciler.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
        reconciler.setDelay(500);
        return reconciler;
    }

    private void maybeAddReconcilingStrategyForContentType(MultiReconcilingStrategy multiStrategy, IReconciler reconciler, String contentType) {
        IReconcilingStrategy reconcilingStrategy = reconciler.getReconcilingStrategy(contentType);
        if (reconcilingStrategy != null && !multiStrategy.contains(reconcilingStrategy)) {
            multiStrategy.add(reconcilingStrategy);
        }
    }

    public void setFile(IFile file) {
        this.file = file;
        if (this.markupValidationReconcilingStrategy != null) {
            this.markupValidationReconcilingStrategy.setResource((IResource)file);
        }
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        if (this.textHover == null) {
            this.textHover = new DefaultTextHover(sourceViewer);
        }
        return this.textHover;
    }

    public IInformationPresenter getOutlineInformationPresenter(ISourceViewer sourceViewer) {
        if (this.informationPresenter == null) {
            String[] contentTypes;
            IInformationControlCreator controlCreator = this.getOutlineInformationControlCreator();
            this.informationPresenter = new InformationPresenter(controlCreator);
            this.informationPresenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            InformationProvider provider = new InformationProvider(controlCreator);
            String[] stringArray = contentTypes = this.getConfiguredContentTypes(sourceViewer);
            int n = contentTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String contentType = stringArray[n2];
                this.informationPresenter.setInformationProvider((IInformationProvider)provider, contentType);
                ++n2;
            }
            this.informationPresenter.setSizeConstraints(60, 20, true, true);
        }
        return this.informationPresenter;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        ArrayList<String> contentTypes = new ArrayList<String>(3);
        contentTypes.addAll(Arrays.asList(FastMarkupPartitioner.ALL_CONTENT_TYPES));
        contentTypes.add("__dftl_partition_content_type");
        return contentTypes.toArray(new String[contentTypes.size()]);
    }

    protected IInformationControlCreator getOutlineInformationControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                QuickOutlinePopupDialog dialog = new QuickOutlinePopupDialog(parent, MarkupSourceViewerConfiguration.this.showInTarget);
                return dialog;
            }
        };
    }

    public void setOutline(OutlineItem outlineModel) {
        this.outline = outlineModel;
        if (this.anchorCompletionProcessor != null) {
            this.anchorCompletionProcessor.setOutline(this.outline);
        }
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(Font defaultFont) {
        this.defaultFont = defaultFont;
    }

    public Font getDefaultMonospaceFont() {
        return this.defaultMonospaceFont;
    }

    public void setDefaultMonospaceFont(Font defaultMonospaceFont) {
        this.defaultMonospaceFont = defaultMonospaceFont;
    }

    public IShowInTarget getShowInTarget() {
        return this.showInTarget;
    }

    public void setShowInTarget(IShowInTarget showInTarget) {
        this.showInTarget = showInTarget;
    }

    private class InformationProvider
    implements IInformationProvider,
    IInformationProviderExtension,
    IInformationProviderExtension2 {
        private final IInformationControlCreator controlCreator;

        public InformationProvider(IInformationControlCreator controlCreator) {
            this.controlCreator = controlCreator;
        }

        @Deprecated
        public String getInformation(ITextViewer textViewer, IRegion subject) {
            return this.getInformation2(textViewer, subject).toString();
        }

        public Object getInformation2(ITextViewer textViewer, IRegion subject) {
            IDocument document;
            if (MarkupSourceViewerConfiguration.this.outline == null && MarkupSourceViewerConfiguration.this.markupLanguage != null && (document = textViewer.getDocument()) != null && document.getLength() > 0) {
                MarkupLanguage language = MarkupSourceViewerConfiguration.this.markupLanguage.clone();
                OutlineParser outlineParser = new OutlineParser();
                outlineParser.setMarkupLanguage(language.clone());
                String markup = document.get();
                OutlineItem outline = outlineParser.parse(markup);
                if (MarkupSourceViewerConfiguration.this.file != null) {
                    outline.setResourcePath(MarkupSourceViewerConfiguration.this.file.getFullPath().toString());
                }
                return outline;
            }
            return MarkupSourceViewerConfiguration.this.outline;
        }

        public IRegion getSubject(ITextViewer textViewer, int offset) {
            return new Region(offset, 0);
        }

        public IInformationControlCreator getInformationPresenterControlCreator() {
            return this.controlCreator;
        }
    }
}

