/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.tool.avr32program.ui;

import com.atmel.avr32.target.ui.ResultDialog;
import com.atmel.avr32.target.ui.TargetAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class CpuInformationTargetAction
extends TargetAction {
    protected Dialog createResultDialog(String title, String message, Shell shell) {
        return new CpuInformationResultDialog(shell, title, message, this.getHelpContextId());
    }

    private class CpuInformationResultDialog
    extends ResultDialog {
        private CpuInformationResultDialog(Shell parentShell, String dialogTitle, String dialogMessage, String helpContextId) {
            super(parentShell, dialogTitle, dialogMessage, helpContextId);
        }

        protected Control createDialogArea(Composite parent) {
            TabFolder tabFolder = new TabFolder(parent, 128);
            tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
            Composite deviceComposite = this.createTab(tabFolder, "Device");
            Composite processorComposite = this.createTab(tabFolder, "Processor");
            State state = State.INITIAL;
            String[] stringArray = this.getMessage().split("[\n\r]+");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                switch (state) {
                    case INITIAL: {
                        if (!line.startsWith("Device information:")) break;
                        state = State.DEVICE_INFO;
                        break;
                    }
                    case DEVICE_INFO: {
                        if (line.startsWith("Processor configuration:")) {
                            state = State.PROC_INFO;
                            break;
                        }
                        if (line.length() <= 0) break;
                        this.addLineToTab(deviceComposite, line);
                        break;
                    }
                    case PROC_INFO: {
                        this.addLineToTab(processorComposite, line);
                    }
                }
                ++n2;
            }
            return parent;
        }

        private void addLineToTab(Composite deviceComposite, String line) {
            String[] strs = line.split("   +");
            if (strs.length == 2) {
                new Label(deviceComposite, 0).setText(strs[0].trim());
                new Label(deviceComposite, 0).setText(strs[1].trim());
            }
        }

        private Composite createTab(TabFolder tabFolder, String title) {
            TabItem tabItem = new TabItem(tabFolder, 0);
            tabItem.setText(title);
            Composite deviceComposite = new Composite((Composite)tabFolder, 0);
            deviceComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            deviceComposite.setLayout((Layout)new GridLayout(2, false));
            tabItem.setControl((Control)deviceComposite);
            return deviceComposite;
        }
    }

    static enum State {
        INITIAL,
        DEVICE_INFO,
        PROC_INFO;

    }
}

