/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.tool.avr32program;

import com.atmel.avr32.target.ITargetInterface;
import com.atmel.avr32.target.TargetCommandStatus;
import com.atmel.avr32.target.TargetJob;
import com.atmel.avr32.target.TargetPlugin;
import com.atmel.avr32.target.ui.TargetAction;
import com.atmel.avr32.target.ui.TargetActionDialog;
import com.atmel.avr32.target.ui.TargetDialogAction;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ExecuteFromAction
extends TargetDialogAction {
    Integer fAddress;
    MenuManager fMenu;
    UsedMap fValues;

    public ExecuteFromAction() {
        this.needsConnection(true);
        this.fValues = new UsedMap(5, 1.0f, true);
    }

    public Integer[] getLastValues() {
        Set values = this.fValues.keySet();
        return values.toArray(new Integer[values.size()]);
    }

    public MenuManager getContents() {
        Integer[] values;
        MenuManager resume = new MenuManager("Resume From");
        if (this.fSelectedTarget == null) {
            return resume;
        }
        resume.add((IAction)this);
        Integer[] integerArray = values = this.getLastValues();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Integer string = integerArray[n2];
            String address = Integer.toHexString(string);
            ExecuteFromAction action = new ExecuteFromAction();
            action.setText("0x" + address);
            action.setAddress(string);
            action.setCommand(this.getCommand());
            action.setOptions(new String[]{"-O", "0x" + address});
            action.setDescription("Resume from address 0x" + address);
            action.setTarget(this.fSelectedTarget);
            resume.add((IAction)action);
            ++n2;
        }
        return resume;
    }

    public void setAddress(Integer address) {
        this.fAddress = address;
    }

    public void run() {
        final ITargetInterface adapter = TargetPlugin.getDefault().getTargetInterface("AVR32 Program/GDB-Proxy");
        adapter.setTarget(this.getTarget());
        if (adapter == null) {
            return;
        }
        if (this.fAddress == null) {
            try {
                TargetActionDialog rd;
                Shell shell = TargetPlugin.getStandardDisplay().getActiveShell();
                if (shell == null) {
                    shell = new Shell(new Display());
                }
                if ((rd = new TargetActionDialog((TargetDialogAction)this, shell)).open() == 1) {
                    return;
                }
                this.fAddress = ((Long)this.getComposite().getOptions()[1]).intValue();
                this.fValues.put(this.fAddress, this.fAddress);
                this.setOptions(new String[]{"-O", "0x" + Integer.toHexString(this.fAddress)});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ExecuteFromAction action = this;
        TargetJob job = new TargetJob(this.getDescription(), (TargetAction)action){
            private final /* synthetic */ TargetAction val$action;
            {
                this.val$action = targetAction;
                super($anonymous0);
            }

            public IStatus run(IProgressMonitor monitor) {
                TargetCommandStatus status = adapter.execute(this.val$action, monitor);
                ExecuteFromAction.this.fAddress = null;
                return status;
            }
        };
        job.setTarget(this.fSelectedTarget);
        job.setPriority(10);
        job.setUser(this.showProgress);
        job.schedule();
    }

    private class UsedMap
    extends LinkedHashMap<Integer, Integer> {
        private static final long serialVersionUID = 1L;
        private static final int MAX_ENTRIES = 5;

        public UsedMap(int initialCapacity, float loadFactor, boolean accessOrder) {
            super(initialCapacity, loadFactor, accessOrder);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 5;
        }
    }
}

