/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.tool.avr32program;

import com.atmel.avr32.debug.AVR32DebugPlugin;
import com.atmel.avr32.managedbuilder.ManagedbuildPlugin;
import com.atmel.avr32.target.AbstractAdapterInterface;
import com.atmel.avr32.target.FuseRegisterSettings;
import com.atmel.avr32.target.ITarget;
import com.atmel.avr32.target.ITargetAction;
import com.atmel.avr32.target.ITargetFirmwareInterface;
import com.atmel.avr32.target.TargetCommandStatus;
import com.atmel.avr32.target.TargetPlugin;
import com.atmel.avr32.target.ToolRegistry;
import com.atmel.avr32.target.launch.ErrorStreamConsumer;
import com.atmel.avr32.target.launch.OutputStreamConsumer;
import com.atmel.avr32.target.tool.model.Clock;
import com.atmel.avr32.target.tool.model.IMemoryBlock;
import com.atmel.avr32.target.tool.model.Tool;
import com.atmel.avr32.target.tool.model.Voltage;
import com.atmel.avr32.target.ui.TargetAction;
import com.atmel.avr32.tool.avr32program.Messages;
import com.atmel.avr32.util.UtilPlugin;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.cdt.debug.mi.core.IGDBServerMILaunchConfigurationConstants;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.statushandlers.StatusManager;

public class AVR32ProgramAdapter
extends AbstractAdapterInterface {
    private static final String COLON = ":";
    private static final String COMMA = ",";
    private static final String HEX_PREFIX = "0x";
    private static final String EQUALS = "=";
    private static final String EMPTY = "";
    private static final int EXITCODE_PART_MISMATCH = 3;
    private static final int EXITCODE_UNSUPPORTED_VERSION = 5;
    private static final int EXITCODE_TOOL_NOT_SETUP_FOR_PART = 6;
    private static final String DETECTED_PART_DIFFERS_FROM_SPECIFIED_PART = "Detected part .* differs from specified part .*";
    public static final String INTERFACE_ID = "AVR32 Program/GDB-Proxy";
    private static final String USB_OPTION_SERIAL = "USB:";
    private static final String USB_OPTION = "USB";
    private static final String RS232 = "rs232";
    private static final String AVR32GDBPROXY = "avr32gdbproxy";
    public static String NEWLINE = System.getProperty("line.separator");
    private boolean ignoreToolSetupError = false;
    private static final String AVR32PROGRAM = "avr32program";
    private final String[] fFlashCommands = new String[]{"erase", "program", "readfuses", "writefuses", "avr32gdbproxy"};
    private final String[] fClocks = new String[]{"int", "xtal", "extclk"};

    private int getGDBPort() {
        Preferences p = TargetPlugin.getDefault().getPluginPreferences();
        return p.getInt("com.atmel.avr32.target.DEFAULT_GDB_PORT");
    }

    private int getTracePort() {
        Preferences p = TargetPlugin.getDefault().getPluginPreferences();
        return p.getInt("com.atmel.avr32.target.DEFAULT_TRACE_PORT");
    }

    private String getXMLPath() {
        Preferences p = TargetPlugin.getDefault().getPluginPreferences();
        return p.getString("com.atmel.avr32.target.PART_DESCRIPTION_LOCATION");
    }

    private String getGDbProxy() {
        Preferences p = TargetPlugin.getDefault().getPluginPreferences();
        return p.getString("com.atmel.avr32.target.DEFAULT_GDBPROXY");
    }

    public TargetCommandStatus execute(TargetAction action, IProgressMonitor monitor) {
        Object[] options;
        Assert.isNotNull((Object)this.getTarget(), (String)Messages.AVR32ProgramAdapter_NullTargetError);
        ArrayList<String> commandline = new ArrayList<String>();
        commandline.add(AVR32PROGRAM);
        this.buildCommandOptions(commandline, (ITargetAction)action);
        commandline.add(action.getCommand());
        this.buildFlashOptions(action.getCommand(), commandline);
        if (action.getCommand().equals("program") && action.getTarget().getPart().isClockable()) {
            commandline.add("-c" + this.fClocks[action.getTarget().getClockSource()]);
        }
        if ((options = action.getOptions()) != null) {
            Object[] objectArray = options;
            int n = options.length;
            int n2 = 0;
            while (n2 < n) {
                Object string = objectArray[n2];
                if (string == null) {
                    return new TargetCommandStatus(4, "com.atmel.avr32.tool.avr32program", 0, Messages.AVR32ProgramAdapter_NullArgumentsError, null, null);
                }
                commandline.add(string.toString());
                ++n2;
            }
        }
        int totalWork = action.getCommand().equals("erase") ? -1 : 200;
        monitor.beginTask(Messages.AVR32ProgramAdapter_Working, totalWork);
        TargetCommandStatus status = this.createProcess(commandline, AbstractAdapterInterface.WaitMode.WAIT, null, monitor);
        if (action.getActionDefinitionId() != null) {
            String actionId = action.getActionDefinitionId().substring(action.getActionDefinitionId().lastIndexOf(46) + 1);
            if (actionId.equals("erase") || actionId.equals("chiperase")) {
                this.updateTargetExecutable(EMPTY, -1L);
            }
        } else if (action.getCommand().equals("program") && status.isOK()) {
            String filename = options[options.length - 1].toString();
            File f = new File(filename);
            this.updateTargetExecutable(f.getAbsolutePath(), f.lastModified());
        }
        monitor.done();
        return status;
    }

    private void updateTargetExecutable(String pathOfExecutable, long timestamp) {
        this.getTarget().setLastBinary(pathOfExecutable);
        this.getTarget().setLastBinaryDateTime(timestamp);
        TargetPlugin.getTargetManager().updateTarget(this.getTarget());
    }

    protected TargetCommandStatus createProcess(ArrayList<String> args, AbstractAdapterInterface.WaitMode mode, ILaunch launch, IProgressMonitor monitor) {
        TargetCommandStatus status;
        while (true) {
            IStatus upgradeStatus;
            String message;
            ArrayList a;
            int exitCode;
            if ((exitCode = (status = super.createProcess(a = (ArrayList)args.clone(), mode, launch, monitor)).getCode()) == 3) {
                message = Messages.AVR32ProgramAdapter_MCUMismatchError;
                String[] stringArray = this.splitLines(status.getMessage());
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    if (Pattern.matches(DETECTED_PART_DIFFERS_FROM_SPECIFIED_PART, line)) {
                        message = String.valueOf(message) + NEWLINE + line;
                        break;
                    }
                    ++n2;
                }
                return new TargetCommandStatus(status.getSeverity(), "com.atmel.avr32.tool.avr32program", exitCode, message, status.getResult(), null);
            }
            if (exitCode == 6) {
                message = status.getMessage();
                ToolNotSetupDialog dialog = new ToolNotSetupDialog(message);
                this.getStandardDisplay().syncExec((Runnable)dialog);
                if (dialog.status == 9) {
                    this.addNoToolSetupCheckOption(args);
                    continue;
                }
                return TargetCommandStatus.CANCEL_STATUS;
            }
            if (exitCode != 5) break;
            ITarget target = this.getTarget();
            ITargetFirmwareInterface targetFirmwareInterface = TargetPlugin.getDefault().getTargetFirmwareInterface(target);
            if (targetFirmwareInterface == null || !(upgradeStatus = targetFirmwareInterface.upgrade(target, true)).isOK()) break;
        }
        return status;
    }

    private Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public IStatus launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        Assert.isNotNull((Object)this.getTarget(), (String)Messages.AVR32ProgramAdapter_NullTargetError);
        if (mode.equals("run")) {
            status = this.avr32program(configuration, launch, monitor);
        } else {
            try {
                if (configuration.getAttribute("AVR32_ATTR_START_PROXY", true)) {
                    monitor.subTask(Messages.AVR32ProgramAdapter_LaunchingGDBProxy);
                    status = this.avr32gdbproxy(configuration, launch, monitor);
                }
            }
            catch (CoreException e) {
                return new Status(4, "com.atmel.avr32.debug", Messages.AVR32ProgramAdapter_GDBProxyError, (Throwable)e);
            }
        }
        monitor.done();
        return status;
    }

    private IStatus avr32program(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) {
        LaunchOptions options = new LaunchOptions(configuration);
        ArrayList<String> commandline = new ArrayList<String>();
        commandline.add(AVR32PROGRAM);
        if (options.verbose) {
            commandline.add("--verbose");
            commandline.add("2");
        }
        IFile exec = ResourcesPlugin.getWorkspace().getRoot().getProject(options.project).getFile(options.file);
        ReprogramChoice choice = this.checkReprogramRequired((IResource)exec, options);
        switch (choice) {
            case CancelReprogram: {
                return new Status(8, "com.atmel.avr32.tool.avr32program", 0, Messages.AVR32ProgramAdapter_Cancelled, null);
            }
            case DoReprogram: {
                options.reprogram = true;
                break;
            }
            case DontReprogram: {
                options.reprogram = false;
            }
        }
        this.buildCommandOptions(commandline, null);
        if (options.reprogram) {
            commandline.add("program");
            this.buildFlashOptions("program", commandline);
            if (options.verify) {
                commandline.add("-v");
            }
            switch (options.eraseMethod) {
                case ERASE_SECTORS: {
                    commandline.add("-e");
                    break;
                }
                case ERASE_CHIP: {
                    commandline.add("-E");
                }
            }
            if (options.run) {
                if (options.resetvector) {
                    commandline.add("--run");
                } else {
                    commandline.add("--run=" + options.offset);
                }
            }
            this.addFlashVaultOptions(options, commandline);
            if (options.reset) {
                commandline.add("-R");
            }
        } else {
            commandline.add("run");
            this.buildFlashOptions("run", commandline);
            if (!options.resetvector) {
                commandline.add("-O" + options.offset);
            }
            if (options.reset) {
                commandline.add("-R");
            }
        }
        TargetCommandStatus status = null;
        if (options.reprogram) {
            if (this.getTarget().getPart().isClockable()) {
                commandline.add("-c" + this.fClocks[this.getTarget().getClockSource()]);
            }
            commandline.add(exec.getLocation().toOSString());
            monitor.beginTask("Programming...", 200);
            status = this.createProcess(commandline, AbstractAdapterInterface.WaitMode.WAIT, launch, monitor);
            if (status.isOK()) {
                this.updateTargetExecutable(exec.getLocation().toOSString(), exec.getLocalTimeStamp());
            } else {
                this.updateTargetExecutable(EMPTY, 0L);
            }
        } else {
            monitor.beginTask("Starting...", 100);
            status = this.createProcess(commandline, AbstractAdapterInterface.WaitMode.WAIT, launch, monitor);
        }
        return status;
    }

    private void addFlashVaultOptions(LaunchOptions options, ArrayList<String> commandline) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(options.project);
        if (options.flashvault || ManagedbuildPlugin.isSecured((IProject)project)) {
            StringBuilder fv = new StringBuilder();
            fv.append("--flashvault=");
            if (options.flashvault_nodebug) {
                fv.append("nodebug");
            } else {
                fv.append("debug");
            }
            if (ManagedbuildPlugin.isSecured((IProject)project)) {
                fv.append(",ramsize=");
                fv.append(ManagedbuildPlugin.getSecuredRAMLength((IProject)project));
                fv.append(",flashsize=");
                fv.append(ManagedbuildPlugin.getSecuredFlashLength((IProject)project));
            }
            commandline.add(fv.toString());
        }
    }

    private ReprogramChoice checkReprogramRequired(IResource exec, LaunchOptions options) {
        if (options.suppress) {
            return ReprogramChoice.DontReprogram;
        }
        if (exec.getLocation().toOSString().equals(this.getTarget().getLastBinary()) && this.getTarget().getLastBinaryDateTime() == exec.getLocalTimeStamp()) {
            String proceed = TargetPlugin.getDefault().getPluginPreferences().getString("com.atmel.avr32.target.PROGRAM_TARGET");
            if (proceed.equals("always")) {
                return ReprogramChoice.DoReprogram;
            }
            if (proceed.equals("never")) {
                return ReprogramChoice.DontReprogram;
            }
            Question q = new Question(Messages.AVR32ProgramAdapter_ReprogramTarget_Title, Messages.AVR32ProgramAdapter_ReprogramTarget_Text);
            this.getStandardDisplay().syncExec((Runnable)q);
            if (q.result == 2) {
                return ReprogramChoice.CancelReprogram;
            }
            if (q.result == 0) {
                return ReprogramChoice.DoReprogram;
            }
            return ReprogramChoice.DontReprogram;
        }
        return ReprogramChoice.DoReprogram;
    }

    public IStatus list(IProgressMonitor monitor) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(AVR32PROGRAM);
        args.add("-l");
        TargetCommandStatus status = this.createProcess(args, AbstractAdapterInterface.WaitMode.WAIT, null, monitor);
        if (status.isOK()) {
            String[] lines = this.splitLines(status.getResult());
            int count = 0;
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (!(line.startsWith("found") && line.endsWith("busses") || line.trim().length() <= 0)) {
                    ++count;
                    String[] strings = line.split("(\\s)+");
                    String serialNumber = strings[strings.length - 1];
                    String toolName = line.substring(0, line.length() - serialNumber.length()).trim();
                    Tool tool = ToolRegistry.getTool((String)toolName);
                    if (tool != null) {
                        ITarget target = TargetPlugin.getTargetManager().getTarget(toolName, serialNumber);
                        if (target == null) {
                            TargetPlugin.getTargetManager().addTarget(toolName, serialNumber);
                        } else {
                            target.setDetected(true);
                        }
                    } else {
                        StatusManager.getManager().handle((IStatus)new Status(2, "com.atmel.avr32.target", "Detected unsupported tool " + toolName + "."));
                    }
                }
                ++n2;
            }
            if (count == 0) {
                return new Status(2, "com.atmel.avr32.tool.avr32program", 0, Messages.AVR32ProgramAdapter_NoProgrammersError, null);
            }
            return new Status(0, "com.atmel.avr32.tool.avr32program", 0, "Targets were read OK", null);
        }
        return status;
    }

    private IStatus avr32gdbproxy(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) {
        String[] proxy;
        try {
            configuration.getAttribute("AVR32_ATTR_STK_ID", 0);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return new Status(4, "com.atmel.avr32.tool.avr32program", 0, Messages.AVR32ProgramAdapter_BadTargetError, (Throwable)e);
        }
        LaunchOptions options = new LaunchOptions(configuration);
        ArrayList<String> commandline = new ArrayList<String>();
        String[] stringArray = proxy = options.gdbproxy.split(" ");
        int n = proxy.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            commandline.add(string);
            ++n2;
        }
        commandline.add("-t");
        commandline.add(String.valueOf(options.proxyhost) + COLON + options.proxytraceport);
        commandline.add("-a");
        commandline.add(String.valueOf(options.proxyhost) + COLON + options.proxyport);
        this.buildProxyCommandOptions(commandline);
        if (!options.resetvector) {
            commandline.add("-p" + options.offset);
        }
        try {
            if (configuration.getAttribute("AVR32_AUX_PORT_OVERRIDE", false)) {
                commandline.add("--auxiliary-port=" + configuration.getAttribute("AVR32_AUX_PORT_CONFIGURATION", 0));
            }
        }
        catch (Exception e) {
            return new Status(4, "com.atmel.avr32.tool.avr32program", 0, "Could not specify nexus configuration", (Throwable)e);
        }
        if (options.verbose) {
            commandline.add("-d");
        }
        this.addFlashVaultOptions(options, commandline);
        IFile exec = ResourcesPlugin.getWorkspace().getRoot().getProject(options.project).getFile(options.file);
        ReprogramChoice choice = this.checkReprogramRequired((IResource)exec, options);
        switch (choice) {
            case CancelReprogram: {
                return new Status(8, "com.atmel.avr32.tool.avr32program", 0, Messages.AVR32ProgramAdapter_Cancelled, null);
            }
            case DoReprogram: {
                switch (options.eraseMethod) {
                    case ERASE_CHIP: {
                        commandline.add("-E");
                    }
                }
                commandline.add("--file");
                commandline.add(exec.getLocation().toOSString());
                if (this.getTarget().getPart().isClockable()) {
                    commandline.add("--clock");
                    commandline.add(this.fClocks[this.getTarget().getClockSource()]);
                }
                monitor.beginTask("Launching...", 300);
                break;
            }
            case DontReprogram: {
                monitor.beginTask("Launching...", 100);
            }
        }
        this.buildFlashOptions(AVR32GDBPROXY, commandline);
        TargetCommandStatus status = this.createProcess(commandline, AbstractAdapterInterface.WaitMode.PROGRESS, launch, monitor);
        if (status.isOK()) {
            int count = 0;
            while (count++ < 10) {
                try {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {}
                    UtilPlugin.debug((Object)("Pinging avr32gdbproxy at " + options.proxyhost + COLON + options.proxytraceport));
                    Socket skt = new Socket(options.proxyhost, Integer.parseInt(options.proxytraceport));
                    skt.close();
                    if (choice == ReprogramChoice.DoReprogram) {
                        this.updateTargetExecutable(exec.getLocation().toOSString(), exec.getLocalTimeStamp());
                    }
                    return status;
                }
                catch (UnknownHostException e) {
                    this.terminate(launch);
                    return new Status(4, "com.atmel.avr32.tool.avr32program", 0, Messages.AVR32ProgramAdapter_GDBProxyError, (Throwable)e);
                }
                catch (IOException iOException) {}
            }
            status = new Status(4, "com.atmel.avr32.tool.avr32program", 0, Messages.AVR32ProgramAdapter_GDBProxyCommError, null);
        } else {
            this.updateTargetExecutable(EMPTY, 0L);
        }
        return status;
    }

    private void terminate(ILaunch launch) {
        try {
            launch.terminate();
        }
        catch (DebugException e1) {
            e1.printStackTrace();
        }
    }

    private void buildCommandOptions(ArrayList<String> commandline, ITargetAction action) {
        Assert.isNotNull((Object)this.getTarget(), (String)Messages.AVR32ProgramAdapter_NullTargetError);
        if (this.getTarget().getConnectionType().equals(RS232)) {
            commandline.add("-c" + this.getTarget().getComport());
        } else if (this.getTarget().getSerial().equals(EMPTY)) {
            commandline.add("-c");
            commandline.add(USB_OPTION);
        } else {
            commandline.add("-c");
            commandline.add(USB_OPTION_SERIAL + this.getTarget().getSerial());
        }
        Tool tool = ToolRegistry.getTool((String)this.getTarget().getAdapterName());
        commandline.add("-p" + tool.getId());
        if (!this.getXMLPath().equals(EMPTY)) {
            commandline.add("-x");
            commandline.add(this.getXMLPath());
        }
        commandline.add("--gui");
        this.addDaisyChainOption(this.getTarget(), commandline);
        if (action != null) {
            if (action.getAppliesTo() == ITargetAction.TargetComponent.MCU) {
                this.addPartOption(this.getTarget(), commandline);
            }
        } else {
            this.addPartOption(this.getTarget(), commandline);
        }
        if (this.ignoreToolSetupError) {
            this.addNoToolSetupCheckOption(commandline);
        }
    }

    private void addNoToolSetupCheckOption(ArrayList<String> commandline) {
        commandline.add(1, "--no-tool-setup-check");
    }

    private void addDaisyChainOption(ITarget target, ArrayList<String> commandline) {
        if (target.isDaisyChainConfigured()) {
            commandline.add("-D" + String.valueOf(target.getDaisyDevsBefore()) + COMMA + String.valueOf(target.getDaisyDevsAfter()) + COMMA + String.valueOf(target.getDaisyBitsBefore()) + COMMA + String.valueOf(target.getDaisyBitsAfter()));
        }
    }

    private void addPartOption(ITarget target, ArrayList<String> commandline) {
        String mcu = target.getCpu();
        if (!EMPTY.equals(mcu)) {
            commandline.add("--part");
            commandline.add(mcu);
        }
    }

    private void buildProxyCommandOptions(ArrayList<String> commandline) {
        Assert.isNotNull((Object)this.getTarget(), (String)Messages.AVR32ProgramAdapter_NullTargetError);
        if (this.getTarget().getConnectionType().equals(RS232)) {
            commandline.add("-c" + this.getTarget().getComport());
        } else if (this.getTarget().getSerial().equals(EMPTY)) {
            commandline.add("-cUSB");
        } else {
            commandline.add("-cUSB:" + this.getTarget().getSerial());
        }
        Tool tool = ToolRegistry.getTool((String)this.getTarget().getAdapterName());
        commandline.add("-e" + tool.getId());
        if (!this.getXMLPath().equals(EMPTY)) {
            commandline.add("-x");
            commandline.add(this.getXMLPath());
        }
        this.addDaisyChainOption(this.getTarget(), commandline);
        this.addPartOption(this.getTarget(), commandline);
        commandline.add("--gui");
    }

    private void buildFlashOptions(String command, ArrayList<String> commandline) {
        boolean requiresFlashOptions = false;
        String[] stringArray = this.fFlashCommands;
        int n = this.fFlashCommands.length;
        int n2 = 0;
        while (n2 < n) {
            String cmd = stringArray[n2];
            if (cmd.equals(command)) {
                requiresFlashOptions = true;
            }
            ++n2;
        }
        if (!requiresFlashOptions) {
            return;
        }
        for (IMemoryBlock element : this.getTarget().getFlashList()) {
            String flashOption = "-f" + element.getType() + "@" + element.getAddress();
            commandline.add(flashOption);
        }
    }

    public IStatus applyClockFrequency(Clock clock) {
        ArrayList<String> commandline = new ArrayList<String>();
        commandline.add(AVR32PROGRAM);
        this.buildCommandOptions(commandline, null);
        commandline.add("getfreq");
        commandline.add(clock.getId());
        NullProgressMonitor monitor = new NullProgressMonitor();
        monitor.beginTask(Messages.AVR32ProgramAdapter_Executing, 1);
        TargetCommandStatus status = this.createProcess(commandline, AbstractAdapterInterface.WaitMode.WAIT, null, (IProgressMonitor)monitor);
        if (status.isOK()) {
            String[] stringArray = this.splitLines(status.getResult());
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (line.startsWith("Got frequency ")) {
                    int secondSpace;
                    String info = line.substring(14);
                    int firstSpace = info.indexOf(32);
                    if (firstSpace == -1 || (secondSpace = info.indexOf(32, firstSpace + 1)) == -1) {
                        return new Status(4, "com.atmel.avr32.tool.avr32program", 0, "Unrecognized output from avr32program getfreq: " + line, null);
                    }
                    String clockName = info.substring(0, firstSpace);
                    if (clockName.equals(clock.getId())) {
                        float value = Float.parseFloat(info.substring(firstSpace, secondSpace));
                        String unit = info.substring(secondSpace + 1, info.length() - 1);
                        if ("MHz".equals(unit)) {
                            clock.setValue((float)((double)value * 1000000.0));
                        } else if ("kHz".equals(unit)) {
                            clock.setValue((float)((double)value * 1000.0));
                        } else if ("Hz".equals(unit)) {
                            clock.setValue(value);
                        } else {
                            return new Status(4, "com.atmel.avr32.tool.avr32program", 1, "Unrecognized output from avr32program:" + line, null);
                        }
                    }
                }
                ++n2;
            }
        }
        return status;
    }

    public IStatus readVoltages(Voltage[] voltages) {
        ArrayList<String> commandline = new ArrayList<String>();
        commandline.add(AVR32PROGRAM);
        this.buildCommandOptions(commandline, null);
        commandline.add("getvtg");
        Voltage[] voltageArray = voltages;
        int n = voltages.length;
        int n2 = 0;
        while (n2 < n) {
            Voltage voltage = voltageArray[n2];
            commandline.add(voltage.getId());
            ++n2;
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        monitor.beginTask(Messages.AVR32ProgramAdapter_Executing, 1);
        TargetCommandStatus status = this.createProcess(commandline, AbstractAdapterInterface.WaitMode.WAIT, null, (IProgressMonitor)monitor);
        if (status.isOK()) {
            String[] lines = this.splitLines(status.getResult());
            Voltage[] voltageArray2 = voltages;
            int n3 = voltages.length;
            int n4 = 0;
            while (n4 < n3) {
                Voltage voltage = voltageArray2[n4];
                String[] stringArray = lines;
                int n5 = lines.length;
                int n6 = 0;
                while (n6 < n5) {
                    String line = stringArray[n6];
                    if (line.startsWith(voltage.getId())) {
                        int secondSpace;
                        int firstSpace = line.indexOf(32);
                        if (firstSpace == -1 || (secondSpace = line.indexOf(32, firstSpace + 1)) == -1) {
                            return new Status(4, "com.atmel.avr32.tool.avr32program", 0, String.valueOf(Messages.AVR32ProgramAdapter_UnrecognizedOutputError_Vtg) + line, null);
                        }
                        voltage.setValue(Float.parseFloat(line.substring(firstSpace + 1, secondSpace)));
                    }
                    ++n6;
                }
                ++n4;
            }
        }
        return status;
    }

    public IStatus setClockFrequency(Clock clock) {
        ArrayList<String> commandline = new ArrayList<String>();
        commandline.add(AVR32PROGRAM);
        this.buildCommandOptions(commandline, null);
        commandline.add("setfreq");
        commandline.add(String.valueOf(clock.getId()) + EQUALS + clock.getValue());
        NullProgressMonitor monitor = new NullProgressMonitor();
        monitor.beginTask(Messages.AVR32ProgramAdapter_Executing, 1);
        return this.createProcess(commandline, AbstractAdapterInterface.WaitMode.WAIT, null, (IProgressMonitor)monitor);
    }

    public IStatus applyVoltages(Voltage[] voltages) {
        ArrayList<String> commandline = new ArrayList<String>();
        commandline.add(AVR32PROGRAM);
        this.buildCommandOptions(commandline, null);
        commandline.add("setvtg");
        Voltage[] voltageArray = voltages;
        int n = voltages.length;
        int n2 = 0;
        while (n2 < n) {
            Voltage voltage = voltageArray[n2];
            commandline.add(String.valueOf(voltage.getId()) + EQUALS + voltage.getValue());
            ++n2;
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        monitor.beginTask(Messages.AVR32ProgramAdapter_Executing, 1);
        return this.createProcess(commandline, AbstractAdapterInterface.WaitMode.WAIT, null, (IProgressMonitor)monitor);
    }

    public IStatus applyFuseSettings(FuseRegisterSettings fuses, IProgressMonitor monitor) {
        ArrayList<String> commandline = new ArrayList<String>();
        commandline.add(AVR32PROGRAM);
        this.buildCommandOptions(commandline, null);
        commandline.add("writefuses");
        this.buildFlashOptions("writefuses", commandline);
        commandline.add(String.valueOf(fuses.getGroup()) + EQUALS + HEX_PREFIX + Long.toHexString(fuses.getRegisterValue()));
        monitor.beginTask(Messages.AVR32ProgramAdapter_Executing, 1);
        StringBuffer command = new StringBuffer();
        for (String string : commandline) {
            command.append(string);
            command.append(' ');
        }
        UtilPlugin.debug((Object)command.toString());
        try {
            Process process = Runtime.getRuntime().exec(commandline.toArray(new String[commandline.size()]));
            ErrorStreamConsumer isc = new ErrorStreamConsumer(process, monitor);
            process.waitFor();
            if (process.exitValue() != 0) {
                monitor.done();
                return new Status(4, "com.atmel.avr32.tool.avr32program", 0, isc.getResult(), null);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        monitor.done();
        return new Status(0, "com.atmel.avr32.tool.avr32program", 0, "Targets were read OK", null);
    }

    public IStatus readFuseSettings(FuseRegisterSettings fuses, IProgressMonitor monitor) {
        block7: {
            ArrayList<String> commandline = new ArrayList<String>();
            commandline.add(AVR32PROGRAM);
            this.buildCommandOptions(commandline, null);
            commandline.add("readfuses");
            this.buildFlashOptions("readfuses", commandline);
            commandline.add(fuses.getGroup());
            monitor.beginTask(Messages.AVR32ProgramAdapter_Executing, 1);
            StringBuffer command = new StringBuffer();
            for (String string : commandline) {
                command.append(string);
                command.append(' ');
            }
            UtilPlugin.debug((Object)command.toString());
            try {
                Process process = Runtime.getRuntime().exec(commandline.toArray(new String[commandline.size()]));
                OutputStreamConsumer esc = new OutputStreamConsumer(process, monitor);
                ErrorStreamConsumer isc = new ErrorStreamConsumer(process, monitor);
                process.waitFor();
                if (process.exitValue() == 0) {
                    String[] stringArray = this.splitLines(esc.getResult());
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string = stringArray[n2];
                        if (string.trim().startsWith(fuses.getGroup())) {
                            fuses.setRegisterValue(Long.decode(string.substring(string.indexOf(COLON) + 2)).longValue());
                        }
                        ++n2;
                    }
                    break block7;
                }
                monitor.done();
                return new Status(4, "com.atmel.avr32.tool.avr32program", 0, isc.getResult(), null);
            }
            catch (IOException e) {
                return new Status(4, "com.atmel.avr32.tool.avr32program", 0, Messages.AVR32ProgramAdapter_FusesError, (Throwable)e);
            }
            catch (InterruptedException e) {
                return new Status(4, "com.atmel.avr32.tool.avr32program", 0, Messages.AVR32ProgramAdapter_FusesError, (Throwable)e);
            }
        }
        monitor.done();
        return new Status(0, "com.atmel.avr32.tool.avr32program", 0, "Targets were read OK", null);
    }

    public TargetCommandStatus getStatus() {
        Assert.isNotNull((Object)this.getTarget(), (String)Messages.AVR32ProgramAdapter_NullTargetError);
        ArrayList<String> commandline = new ArrayList<String>();
        commandline.add(AVR32PROGRAM);
        this.buildCommandOptions(commandline, null);
        commandline.add("status");
        return this.createProcess(commandline, AbstractAdapterInterface.WaitMode.WAIT, null, (IProgressMonitor)new NullProgressMonitor());
    }

    private class LaunchOptions {
        private boolean reset = false;
        private boolean run = false;
        private boolean verify = false;
        private boolean reprogram = true;
        private boolean verbose = true;
        private boolean resetvector = true;
        private boolean suppress = false;
        private boolean flashvault = false;
        private boolean flashvault_nodebug = false;
        private String file = "";
        private String project = "";
        private String offset = "";
        private String gdbproxy = "";
        private String proxyhost = "";
        private String proxyport = "";
        private String proxytraceport = "";
        private AVR32DebugPlugin.EraseMethod eraseMethod = null;
        private String nexusConfiguration = null;
        int stk = 0;

        private LaunchOptions(ILaunchConfiguration configuration) {
            try {
                this.eraseMethod = AVR32DebugPlugin.EraseMethod.valueOf((String)configuration.getAttribute("AVR32_ATTR_ERASEMETHOD", AVR32DebugPlugin.EraseMethod.ERASE_SECTORS.toString()));
                this.reset = configuration.getAttribute("AVR32_ATTR_FILE_RESET", false);
                this.run = configuration.getAttribute("AVR32_ATTR_FILE_RUN", false);
                this.verify = configuration.getAttribute("AVR32_ATTR_FILE_VERIFY", false);
                this.resetvector = configuration.getAttribute("AVR32_ATTR_RESETVECTOR", true);
                this.file = configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", AVR32ProgramAdapter.EMPTY);
                this.project = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", AVR32ProgramAdapter.EMPTY);
                this.stk = configuration.getAttribute("AVR32_ATTR_STK_ID", 0);
                this.offset = configuration.getAttribute("AVR32_ATTR_OFFSET", AVR32ProgramAdapter.EMPTY);
                this.verbose = configuration.getAttribute("AVR32_ATTR_VERBOSE", false);
                this.gdbproxy = configuration.getAttribute("AVR32_ATTR_GDBPROXY", AVR32ProgramAdapter.this.getGDbProxy());
                this.proxytraceport = configuration.getAttribute("AVR32_ATTR_GDB_TRACE_PORT", String.valueOf(AVR32ProgramAdapter.this.getTracePort()));
                this.proxyport = configuration.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_PORT, String.valueOf(AVR32ProgramAdapter.this.getGDBPort()));
                this.proxyhost = configuration.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_HOST, "localhost");
                this.suppress = configuration.getAttribute("AVR32_ATTR_SUPPRESS_PROGRAMMING", false);
                this.flashvault = configuration.getAttribute("AVR32_ATTR_FLASHVAULT", false);
                this.flashvault_nodebug = configuration.getAttribute("AVR32_ATTR_DISABLE_DBG", false);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private class Question
    implements Runnable {
        String title;
        String message;
        int result;

        public Question(String title, String message) {
            this.title = title;
            this.message = message;
        }

        @Override
        public void run() {
            Shell shell = AVR32ProgramAdapter.this.getStandardDisplay().getActiveShell();
            if (shell == null) {
                shell = new Shell(new Display());
            }
            MessageDialog dialog = new MessageDialog(shell, this.title, null, this.message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 1);
            dialog.setBlockOnOpen(true);
            this.result = dialog.open();
        }
    }

    private static enum ReprogramChoice {
        DoReprogram,
        DontReprogram,
        CancelReprogram;

    }

    private class ToolNotSetupDialog
    implements Runnable {
        private final String message;
        int status;

        private ToolNotSetupDialog(String message) {
            this.message = message;
        }

        @Override
        public void run() {
            MessageDialogWithToggle dlg = new MessageDialogWithToggle(AVR32ProgramAdapter.this.getStandardDisplay().getActiveShell(), "Tool not set up for device", null, this.message, 0, new String[]{IDialogConstants.IGNORE_LABEL, IDialogConstants.CANCEL_LABEL}, 0, "Ignore from now on", false);
            this.status = dlg.open();
            AVR32ProgramAdapter.this.ignoreToolSetupError = dlg.getToggleState();
        }
    }
}

