/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.tool.batchisp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class HexParser {
    private Map<String, String> hexBuffer;
    private File hexFile;

    public HexParser(File hexFile) {
        this.hexFile = hexFile;
        this.hexBuffer = new HashMap<String, String>();
    }

    public HexParser(String hexFile) {
        this(new File(hexFile));
    }

    public String getData(String address) {
        String addr = address.toUpperCase().startsWith("0X") ? address.substring(2, address.length()).toUpperCase() : Integer.toHexString(Integer.parseInt(address)).toUpperCase();
        return this.hexBuffer.get(addr);
    }

    public int getData(int address) {
        return Integer.parseInt(this.getData(Integer.toString(address)));
    }

    public boolean parse() {
        boolean status = false;
        BufferedReader in = null;
        try {
            try {
                String hexLine;
                int addrMax = 0;
                int addrOffset = 0;
                boolean endRecord = false;
                in = new BufferedReader(new FileReader(this.hexFile));
                block14: while ((hexLine = in.readLine()) != null && !endRecord) {
                    if (!hexLine.startsWith(":")) {
                        System.err.println("HexParser: Illegal start of HEX line.");
                        break;
                    }
                    int recordType = Integer.parseInt(hexLine.substring(7, 9), 16);
                    switch (recordType) {
                        case 0: {
                            int recLen = Integer.parseInt(hexLine.substring(1, 3), 16);
                            int address = Integer.parseInt(hexLine.substring(3, 7), 16) + addrOffset;
                            if (address + recLen - 1 > addrMax) {
                                addrMax = address + recLen - 1;
                            }
                            int byteIdx = 1;
                            while (byteIdx <= recLen) {
                                String data = hexLine.substring(7 + 2 * byteIdx, 9 + 2 * byteIdx);
                                this.hexBuffer.put(Integer.toHexString(address).toUpperCase(), data.toUpperCase());
                                ++address;
                                ++byteIdx;
                            }
                            continue block14;
                        }
                        case 1: {
                            endRecord = true;
                            break;
                        }
                        case 2: {
                            addrOffset = Integer.parseInt(hexLine.substring(9, 13), 16);
                            addrOffset <<= 4;
                            break;
                        }
                        case 4: {
                            addrOffset = Integer.parseInt(hexLine.substring(9, 13), 16);
                            addrOffset <<= 16;
                            break;
                        }
                    }
                }
                status = true;
            }
            catch (NumberFormatException e) {
                System.err.println(e.getMessage());
            }
            catch (FileNotFoundException e) {
                System.err.println(e.getMessage());
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        try {
            in.close();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        return status;
    }

    public static void main(String[] args) {
        HexParser parser = new HexParser(args[0]);
        parser.parse();
        System.out.println(parser.getData("10"));
        System.out.println(parser.getData("0xa"));
    }
}

