/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.tool.batchisp;

import com.atmel.avr32.target.AbstractAdapterInterface;
import com.atmel.avr32.target.FuseRegisterSettings;
import com.atmel.avr32.target.ITarget;
import com.atmel.avr32.target.ITargetInterface;
import com.atmel.avr32.target.PartRegistry;
import com.atmel.avr32.target.TargetCommandStatus;
import com.atmel.avr32.target.part.model.Fuse;
import com.atmel.avr32.target.tool.model.Clock;
import com.atmel.avr32.target.tool.model.Voltage;
import com.atmel.avr32.target.ui.TargetAction;
import com.atmel.avr32.tool.batchisp.HexParser;
import com.atmel.avr32.tool.batchisp.ui.BatchISPPlugin;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.osgi.framework.Bundle;

public class BatchISPAdapter
extends AbstractAdapterInterface
implements ITargetInterface {
    private static final String EQUALS = "=";
    private static final String LD_LIBRARY_PATH = "LD_LIBRARY_PATH";
    private static final String JAVA_HOME = "JAVA_HOME";
    private static final String PATH = "PATH";
    public static final String CPU_NAME_PREFIX = "AT32";
    private static final String PLUGIN_ID = "com.atmel.avr32.tool.batchisp";
    private String cpuName;
    static final String PROPERTY_OS_NAME = "os.name";
    static final String PROPERTY_OS_VALUE = "windows";

    private void initEnvironment(ArrayList<String> environment, String path) throws IOException {
        Map<String, String> vars = System.getenv();
        for (String string : vars.keySet()) {
            if (string.equals(PATH)) {
                environment.add("PATH=" + new File(path).getParentFile().getCanonicalPath() + File.pathSeparator + System.getenv(PATH));
                continue;
            }
            if (string.equals(JAVA_HOME)) {
                environment.add("JAVA_HOME=" + System.getenv(JAVA_HOME) + File.separator + "jre");
                continue;
            }
            if (string.equals(LD_LIBRARY_PATH)) {
                environment.add("LD_LIBRARY_PATH=" + new File(path).getParentFile().getCanonicalPath() + File.pathSeparator + System.getenv(JAVA_HOME) + File.separator + "jre" + File.separator + "lib" + File.separator + "i386" + File.separator + "client");
                continue;
            }
            environment.add(String.valueOf(string) + EQUALS + vars.get(string));
        }
        environment.add("FLIP_HOME=" + new File(path).getParentFile().getCanonicalPath());
    }

    public static boolean isWindows() {
        return System.getProperty(PROPERTY_OS_NAME).toLowerCase().startsWith(PROPERTY_OS_VALUE);
    }

    public IStatus applyClockFrequency(Clock clock) {
        return Status.CANCEL_STATUS;
    }

    public IStatus applyFuseSettings(FuseRegisterSettings fuseSettings, IProgressMonitor monitor) {
        ArrayList<String> commandLine = new ArrayList<String>();
        ArrayList fuses = PartRegistry.getPart((String)fuseSettings.getFuseValue("MCU")).getFuses();
        int fuseOffset = 0;
        int fuseLength = 0;
        long fusesValue = fuseSettings.getRegisterValue();
        commandLine.add("-device");
        commandLine.add(CPU_NAME_PREFIX + this.getTarget().getCpu());
        commandLine.add("-hardware");
        commandLine.add(this.getTarget().getConnectionType());
        commandLine.add("-operation");
        commandLine.add("onfail");
        commandLine.add("abort");
        commandLine.add("memory");
        commandLine.add("configuration");
        for (Fuse fuse : fuses) {
            fuseOffset = (int)fuse.getOffset();
            fuseLength = fuse.getLength();
            int bit = 0;
            while (bit < fuseLength) {
                commandLine.add("addrange");
                commandLine.add("0x" + Integer.toHexString(bit + fuseOffset).toUpperCase());
                commandLine.add("0x" + Integer.toHexString(bit + fuseOffset).toUpperCase());
                commandLine.add("fillbuffer");
                long bitValue = (fusesValue & (long)(1 << fuseOffset + bit)) >>> fuseOffset + bit;
                commandLine.add("0x" + Long.toString(bitValue));
                commandLine.add("program");
                ++bit;
            }
        }
        monitor.beginTask("Executing", 1);
        TargetCommandStatus status = this.createProcess(commandLine, AbstractAdapterInterface.WaitMode.WAIT, null, monitor);
        monitor.done();
        return status;
    }

    public IStatus applyVoltages(Voltage[] voltages) {
        return Status.CANCEL_STATUS;
    }

    private boolean isBuiltInsAvailable() {
        return Platform.getFragments((Bundle)BatchISPPlugin.getDefault().getBundle()) != null;
    }

    protected TargetCommandStatus createProcess(ArrayList<String> args, AbstractAdapterInterface.WaitMode mode, ILaunch launch, IProgressMonitor monitor) {
        if (this.isBuiltInsAvailable() && BatchISPPlugin.getDefault().getPluginPreferences().getBoolean("PREF_EMBEDDED_BINARIES")) {
            try {
                ArrayList<String> environment = new ArrayList<String>();
                String path = this.getBatchISPPath();
                args.add(0, path);
                this.initEnvironment(environment, path);
                return super.createProcess(args, environment, mode, launch, monitor);
            }
            catch (IOException e) {
                return new TargetCommandStatus(4, PLUGIN_ID, "Could not execute batchisp", null, (Throwable)e);
            }
        }
        args.add(0, "batchisp");
        return super.createProcess(args, mode, launch, monitor);
    }

    public TargetCommandStatus execute(TargetAction action, IProgressMonitor monitor) {
        ITarget target = action.getTarget();
        this.cpuName = target.getCpu();
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add("-device");
        commandLine.add(CPU_NAME_PREFIX + this.cpuName);
        commandLine.add("-hardware");
        commandLine.add(target.getConnectionType());
        commandLine.add("-operation");
        commandLine.add("onfail");
        commandLine.add("abort");
        commandLine.add("memory");
        commandLine.add("FLASH");
        if (action.getCommand().length() > 0 && action.getCommand().equalsIgnoreCase("ERASE")) {
            commandLine.add(action.getCommand());
        }
        Object[] objectArray = action.getOptions();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object option = objectArray[n2];
            commandLine.add(option.toString());
            ++n2;
        }
        monitor.beginTask("Executing", 1);
        TargetCommandStatus status = this.createProcess(commandLine, AbstractAdapterInterface.WaitMode.WAIT, null, monitor);
        monitor.done();
        return status;
    }

    private int getAddrMax(FuseRegisterSettings fuseSettings) {
        int max = 0;
        ArrayList fuses = PartRegistry.getPart((String)fuseSettings.getFuseValue("MCU")).getFuses();
        for (Fuse fuse : fuses) {
            if (fuse.getOffset() + (long)fuse.getLength() - 1L <= (long)max) continue;
            max = (int)(fuse.getOffset() + (long)fuse.getLength() - 1L);
        }
        return max;
    }

    private int getAddrMin(FuseRegisterSettings fuseSettings) {
        int min = 65535;
        String mcu = fuseSettings.getFuseValue("MCU");
        ArrayList fuses = PartRegistry.getPart((String)mcu).getFuses();
        for (Fuse fuse : fuses) {
            if (fuse.getOffset() >= (long)min) continue;
            min = (int)fuse.getOffset();
        }
        return min;
    }

    private String getBatchISPPath() {
        String command = null;
        Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
        try {
            String path;
            File file;
            URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("$os$/flip/bin/batchisp3"), null);
            if (url != null && (file = new File(path = (url = FileLocator.resolve((URL)url)).getFile())).exists()) {
                command = file.getCanonicalPath();
            }
        }
        catch (IOException iOException) {}
        return command;
    }

    public String getLastResult() {
        return null;
    }

    public IStatus launch(ILaunchConfiguration settings, String mode, ILaunch launch, IProgressMonitor monitor) {
        return new Status(2, "com.atmel.avr32.target", 0, "Launching is currently not supported by batchisp.", (Throwable)new UnsupportedOperationException());
    }

    public IStatus list(IProgressMonitor monitor) {
        return Status.CANCEL_STATUS;
    }

    public IStatus readFuseSettings(FuseRegisterSettings fuseSettings, IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add("-device");
        commandLine.add(CPU_NAME_PREFIX + this.getTarget().getCpu());
        commandLine.add("-hardware");
        commandLine.add(this.getTarget().getConnectionType());
        commandLine.add("-operation");
        commandLine.add("onfail");
        commandLine.add("abort");
        commandLine.add("memory");
        commandLine.add("configuration");
        commandLine.add("addrange");
        commandLine.add("0x" + Integer.toHexString(this.getAddrMin(fuseSettings)).toUpperCase());
        commandLine.add("0x" + Integer.toHexString(this.getAddrMax(fuseSettings)).toUpperCase());
        commandLine.add("read");
        commandLine.add("savebuffer");
        try {
            File f = File.createTempFile("avr32-fuses", ".hex");
            commandLine.add(f.getAbsolutePath());
            commandLine.add("hex86");
            monitor.beginTask("Executing", 1);
            status = this.createProcess(commandLine, AbstractAdapterInterface.WaitMode.WAIT, null, monitor);
            monitor.done();
            HexParser hexParser = new HexParser(f.getAbsolutePath());
            if (hexParser.parse()) {
                int addrMin = this.getAddrMin(fuseSettings);
                int addrMax = this.getAddrMax(fuseSettings);
                long fuseValue = 0L;
                int i = addrMax;
                while (i >= addrMin) {
                    fuseValue += (long)(hexParser.getData(i) << i);
                    --i;
                }
                fuseSettings.setRegisterValue(fuseValue);
                status = new Status(0, PLUGIN_ID, 0, "Targets were read OK", null);
            } else {
                status = new Status(4, PLUGIN_ID, 4, "batchisp plug-in HEX file parser error.", null);
            }
            f.delete();
        }
        catch (IOException e) {
            return new Status(4, "com.atmel.avr32.target", "Could not parse fuse data", (Throwable)e);
        }
        return status;
    }

    public IStatus readVoltages(Voltage[] voltages) {
        return Status.CANCEL_STATUS;
    }

    public IStatus setClockFrequency(Clock clock) {
        return Status.CANCEL_STATUS;
    }
}

