/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.envvar;

import org.eclipse.cdt.core.envvar.EnvironmentVariable;
import org.eclipse.cdt.core.settings.model.ICStorageElement;

public class StorableEnvVar
extends EnvironmentVariable {
    public static final String VARIABLE_ELEMENT_NAME = "variable";
    public static final String NAME = "name";
    public static final String VALUE = "value";
    public static final String OPERATION = "operation";
    public static final String DELIMITER = "delimiter";
    public static final String REPLACE = "replace";
    public static final String REMOVE = "remove";
    public static final String APPEND = "append";
    public static final String PREPEND = "prepend";

    public StorableEnvVar(String name, String value, int op, String delimiter) {
        super(name, value, op, delimiter);
    }

    public StorableEnvVar(String name) {
        this(name, null, 1, null);
    }

    public StorableEnvVar(String name, String value) {
        this(name, value, 1, null);
    }

    public StorableEnvVar(String name, String value, String delimiter) {
        this(name, value, 1, delimiter);
    }

    public StorableEnvVar(ICStorageElement element) {
        this.load(element);
    }

    private void load(ICStorageElement element) {
        this.fName = element.getAttribute(NAME);
        this.fValue = element.getAttribute(VALUE);
        this.fOperation = this.opStringToInt(element.getAttribute(OPERATION));
        this.fDelimiter = element.getAttribute(DELIMITER);
        if ("".equals(this.fDelimiter)) {
            this.fDelimiter = null;
        }
    }

    private int opStringToInt(String op) {
        int operation = REMOVE.equals(op) ? 2 : (APPEND.equals(op) ? 4 : (PREPEND.equals(op) ? 3 : 1));
        return operation;
    }

    private String opIntToString(int op) {
        String operation = 2 == op ? REMOVE : (4 == op ? APPEND : (3 == op ? PREPEND : REPLACE));
        return operation;
    }

    public void serialize(ICStorageElement element) {
        if (this.fName != null) {
            element.setAttribute(NAME, this.fName);
        }
        if (this.fValue != null) {
            element.setAttribute(VALUE, this.fValue);
        }
        element.setAttribute(OPERATION, this.opIntToString(this.fOperation));
        if (this.fDelimiter != null) {
            element.setAttribute(DELIMITER, this.fDelimiter);
        }
    }
}

