/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.settings.model.extension.CDataObject;
import org.eclipse.cdt.internal.core.settings.model.CDataProxy;
import org.eclipse.cdt.internal.core.settings.model.ICDataScope;
import org.eclipse.cdt.internal.core.settings.model.IProxyCache;
import org.eclipse.cdt.internal.core.settings.model.IProxyFactory;
import org.eclipse.cdt.internal.core.settings.model.IProxyProvider;

public class ProxyProvider
implements IProxyProvider {
    private IProxyCache fCache;
    private ICDataScope fScope;
    private IProxyFactory fFactory;
    private boolean fProxiesCached;

    public ProxyProvider(ICDataScope scope, IProxyCache cache, IProxyFactory factory) {
        this.fScope = scope;
        this.fCache = cache;
        this.fFactory = factory;
    }

    public CDataProxy[] getProxies() {
        if (!this.fProxiesCached || !this.fScope.isStatic()) {
            this.fillCache();
            this.fProxiesCached = true;
        }
        return this.fCache.getCachedProxies();
    }

    public CDataProxy getProxy(String id) {
        if (!this.fProxiesCached || !this.fScope.isStatic()) {
            this.fillCache();
            this.fProxiesCached = true;
        }
        return this.fCache.getCachedProxy(id);
    }

    protected void fillCache() {
        Map map = this.fCache.getCachedProxiesMap();
        CDataObject[] datas = this.fScope.getChildren();
        int i = 0;
        while (i < datas.length) {
            CDataObject data = datas[i];
            CDataProxy proxy = this.fCache.getCachedProxy(data.getId());
            if (proxy == null || proxy.getType() != data.getType()) {
                proxy = this.fFactory.createProxy(data);
                if (proxy != null) {
                    this.fCache.addCachedProxy(proxy);
                }
            } else {
                proxy.setData(data);
                map.remove(data.getId());
            }
            ++i;
        }
        if (!map.isEmpty()) {
            Iterator iter = map.values().iterator();
            while (iter.hasNext()) {
                this.fCache.removeCachedProxy((CDataProxy)iter.next());
            }
        }
    }

    public CDataProxy getProxy(CDataObject data) {
        if (!this.fProxiesCached || !this.fScope.isStatic()) {
            this.fillCache();
            this.fProxiesCached = true;
        }
        return this.fCache.getCachedProxy(data);
    }

    public void removeCachedProxy(String id) {
        this.fCache.removeCachedProxy(id);
        this.fProxiesCached = true;
    }

    public void removeCachedProxy(CDataProxy proxy) {
        this.fCache.removeCachedProxy(proxy);
        this.fProxiesCached = true;
    }

    public CDataProxy[] getCachedProxies() {
        return this.fCache.getCachedProxies();
    }

    public CDataProxy[] getProxiesOfKind(int kind) {
        CDataProxy[] proxies = this.getProxies();
        if (proxies.length > 0) {
            CDataProxy[] tmp = new CDataProxy[proxies.length];
            int num = 0;
            int i = 0;
            while (i < proxies.length) {
                CDataProxy proxy = proxies[i];
                if ((proxy.getType() & kind) == proxy.getType()) {
                    tmp[num++] = proxy;
                }
                ++i;
            }
            if (num != proxies.length) {
                proxies = new CDataProxy[num];
                System.arraycopy(tmp, 0, proxies, 0, num);
            }
        }
        return proxies;
    }

    public void cacheValues() {
        if (!this.fProxiesCached || !this.fScope.isStatic()) {
            this.fillCache();
            this.fProxiesCached = true;
        }
    }

    public void invalidateCache() {
        this.fProxiesCached = false;
        CDataProxy[] proxies = this.fCache.getCachedProxies();
        int i = 0;
        while (i < proxies.length) {
            proxies[i].doClearData();
            ++i;
        }
    }
}

