/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import org.eclipse.cdt.internal.core.settings.model.AbstractCProjectDescriptionStorage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.osgi.framework.Version;

public interface ICProjectDescriptionStorageType {
    public static final String STORAGE_FILE_NAME = ".cproject";
    public static final String STORAGE_VERSION_NAME = "fileVersion";
    public static final String STORAGE_ROOT_ELEMENT_NAME = "cproject";
    public static final String STORAGE_TYPE_ATTRIBUTE = "storage_type_id";

    public AbstractCProjectDescriptionStorage getProjectDescriptionStorage(CProjectDescriptionStorageTypeProxy var1, IProject var2, Version var3);

    public boolean createsCProjectXMLFile();

    public static final class CProjectDescriptionStorageTypeProxy
    implements ICProjectDescriptionStorageType {
        private static final String ATTR_ID = "id";
        private static final String ATTR_CLASS = "class";
        private static final String ATTR_NAME = "name";
        private static final String ATTR_VERSION = "version";
        private static final String ATTR_MAX_VERSION = "max_version";
        private static final String ATTR_MIN_VERSION = "min_version";
        public final String id;
        public final String name;
        public final ICProjectDescriptionStorageType storageType;
        public final Version version;
        public final Version max_version;
        public final Version min_version;

        public CProjectDescriptionStorageTypeProxy(IConfigurationElement el) throws CoreException, IllegalArgumentException {
            this(String.valueOf(el.getNamespaceIdentifier()) + "." + CProjectDescriptionStorageTypeProxy.getString(el, ATTR_ID, null), CProjectDescriptionStorageTypeProxy.getString(el, ATTR_NAME, null), (ICProjectDescriptionStorageType)el.createExecutableExtension(ATTR_CLASS), CProjectDescriptionStorageTypeProxy.getVersion(el, ATTR_VERSION, null), CProjectDescriptionStorageTypeProxy.getVersion(el, ATTR_MIN_VERSION, Version.emptyVersion), CProjectDescriptionStorageTypeProxy.getVersion(el, ATTR_MAX_VERSION, Version.emptyVersion));
        }

        public CProjectDescriptionStorageTypeProxy(String id, String name, ICProjectDescriptionStorageType storageType, Version version, Version min_version, Version max_version) {
            this.id = id;
            this.name = name;
            this.storageType = storageType;
            this.version = version;
            this.min_version = min_version;
            Version version2 = this.max_version = max_version == Version.emptyVersion ? version : max_version;
            if (min_version != Version.emptyVersion && version.compareTo((Object)min_version) <= 0) {
                throw new IllegalArgumentException("CProjectDescriptionStorageType Version: " + version + " must be > that min_version: " + min_version);
            }
            if (max_version != Version.emptyVersion && version.compareTo((Object)max_version) > 0) {
                throw new IllegalArgumentException("CProjectDescriptionStorageType Version: " + version + " must be < that max_version: " + max_version);
            }
        }

        public boolean isCompatible(Version version) {
            if (version.compareTo((Object)this.max_version) > 0) {
                return false;
            }
            return version.compareTo((Object)this.min_version) > 0;
        }

        public boolean createsCProjectXMLFile() {
            return this.storageType.createsCProjectXMLFile();
        }

        public AbstractCProjectDescriptionStorage getProjectDescriptionStorage(CProjectDescriptionStorageTypeProxy type, IProject project, Version version) {
            return this.storageType.getProjectDescriptionStorage(type, project, version);
        }

        private static Version getVersion(IConfigurationElement element, String id, Version defaultValue) throws IllegalArgumentException {
            Version v;
            String value = element.getAttribute(id);
            if (value == null) {
                return defaultValue;
            }
            try {
                v = new Version(value);
            }
            catch (Exception exception) {
                v = defaultValue;
            }
            return v;
        }

        private static String getString(IConfigurationElement element, String id, String defaultValue) throws IllegalArgumentException {
            String val = element.getAttribute(id);
            if (val != null) {
                return val;
            }
            if (defaultValue != null) {
                return defaultValue;
            }
            throw new IllegalArgumentException("Couldn't find value for extension attribute " + id);
        }
    }
}

