/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.cdt.core.settings.model.CExternalSetting;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingsHolder;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingsManager;
import org.eclipse.cdt.internal.core.settings.model.CRefSettingsHolder;

class CSettingsRefInfo {
    static final String ELEMENT_REFERENCE_INFO = "referenceInfo";
    private HashMap fESHolderMap = new HashMap();

    CSettingsRefInfo() {
    }

    CSettingsRefInfo(ICStorageElement el) {
        ICStorageElement[] children = el.getChildren();
        int i = 0;
        while (i < children.length) {
            ICStorageElement child = children[i];
            String name = child.getName();
            if ("externalSettings".equals(name)) {
                CRefSettingsHolder h = new CRefSettingsHolder(child);
                CExternalSettingsManager.CContainerRef r = h.getContainerInfo();
                this.fESHolderMap.put(r, h);
            }
            ++i;
        }
    }

    CSettingsRefInfo(CSettingsRefInfo base) {
        this.fESHolderMap = (HashMap)base.fESHolderMap.clone();
        for (Map.Entry entry : this.fESHolderMap.entrySet()) {
            CRefSettingsHolder h = (CRefSettingsHolder)entry.getValue();
            h = new CRefSettingsHolder(h);
            entry.setValue(h);
        }
    }

    CExternalSettingsManager.CContainerRef[] getReferences(String factoryId) {
        ArrayList<CExternalSettingsManager.CContainerRef> list = new ArrayList<CExternalSettingsManager.CContainerRef>();
        for (CExternalSettingsManager.CContainerRef r : this.fESHolderMap.keySet()) {
            if (!r.getFactoryId().equals(factoryId)) continue;
            list.add(r);
        }
        return list.toArray(new CExternalSettingsManager.CContainerRef[list.size()]);
    }

    CExternalSettingsManager.CContainerRef[] getReferences() {
        return this.fESHolderMap.keySet().toArray(new CExternalSettingsManager.CContainerRef[this.fESHolderMap.size()]);
    }

    CRefSettingsHolder get(CExternalSettingsManager.CContainerRef cRef) {
        return (CRefSettingsHolder)this.fESHolderMap.get(cRef);
    }

    void serialize(ICStorageElement element) {
        for (Map.Entry entry : this.fESHolderMap.entrySet()) {
            CRefSettingsHolder h = (CRefSettingsHolder)entry.getValue();
            ICStorageElement child = element.createChild("externalSettings");
            h.serialize(child);
        }
    }

    void put(CRefSettingsHolder holder) {
        this.fESHolderMap.put(holder.getContainerInfo(), holder);
    }

    CRefSettingsHolder remove(CExternalSettingsManager.CContainerRef cRef) {
        return (CRefSettingsHolder)this.fESHolderMap.remove(cRef);
    }

    CExternalSetting[] createExternalSettings() {
        if (this.fESHolderMap.size() == 0) {
            return new CExternalSetting[0];
        }
        if (this.fESHolderMap.size() == 1) {
            return ((CRefSettingsHolder)this.fESHolderMap.values().iterator().next()).getExternalSettings();
        }
        CExternalSettingsHolder holder = new CExternalSettingsHolder();
        for (CExternalSettingsHolder h : this.fESHolderMap.values()) {
            holder.setExternalSettings(h.getExternalSettings(), true);
        }
        return holder.getExternalSettings();
    }

    ICSettingEntry[] getAllEntries(int kind) {
        LinkedHashMap map = new LinkedHashMap();
        for (Map.Entry entry : this.fESHolderMap.entrySet()) {
            CRefSettingsHolder h = (CRefSettingsHolder)entry.getValue();
            CExternalSetting[] settings = h.getExternalSettings();
            int i = 0;
            while (i < settings.length) {
                ICSettingEntry[] entries = settings[i].getEntries(kind);
                CDataUtil.fillEntriesMapByNameKey(map, entries);
                ++i;
            }
        }
        return map.values().toArray(new ICSettingEntry[map.size()]);
    }
}

