/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.core.settings.model.ICSettingContainer;
import org.eclipse.cdt.core.settings.model.ICSettingObject;
import org.eclipse.cdt.core.settings.model.WriteAccessException;
import org.eclipse.cdt.core.settings.model.extension.CFolderData;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.core.settings.model.extension.impl.CDefaultFolderData;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationDescriptionCache;
import org.eclipse.cdt.internal.core.settings.model.CLanguageSettingCache;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.cdt.internal.core.settings.model.ICachedData;
import org.eclipse.cdt.internal.core.settings.model.ResourceDescriptionHolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.content.IContentType;

public class CFolderDescriptionCache
extends CDefaultFolderData
implements ICFolderDescription,
ICachedData {
    private CConfigurationDescriptionCache fCfg;
    private ResourceDescriptionHolder fRcDesHolder;

    public CFolderDescriptionCache(CFolderData base, CConfigurationDescriptionCache cfg) {
        super(base.getId(), base.getPath(), cfg, null);
        this.fCfg = cfg;
        this.fCfg.addResourceDescription(this);
        this.copyDataFrom(base, true);
    }

    public ICLanguageSetting getLanguageSettingForFile(String fileName) {
        IProject project = this.getConfiguration().getProjectDescription().getProject();
        return CProjectDescriptionManager.getInstance().findLanguagSettingForFile(fileName, project, this.getLanguageSettings());
    }

    public ICLanguageSetting[] getLanguageSettings() {
        return this.fLanguageDatas.toArray(new CLanguageSettingCache[this.fLanguageDatas.size()]);
    }

    public ICResourceDescription getNestedResourceDescription(IPath relPath, boolean exactPath) {
        return this.getRcDesHolder().getResourceDescription(relPath, exactPath);
    }

    public ICResourceDescription[] getNestedResourceDescriptions(int kind) {
        return this.getRcDesHolder().getResourceDescriptions(kind);
    }

    public ICConfigurationDescription getConfiguration() {
        return this.fCfg;
    }

    public ICSettingContainer getParent() {
        return this.fCfg;
    }

    public ICSettingObject[] getChildSettings() {
        return this.getLanguageSettings();
    }

    protected CLanguageData copyLanguageData(CLanguageData base, boolean clone) {
        return new CLanguageSettingCache(base, this);
    }

    public void setExcluded(boolean excluded) {
        throw ExceptionFactory.createIsReadOnlyException();
    }

    public boolean canExclude(boolean exclude) {
        return exclude == this.isExcluded();
    }

    public void setPath(IPath path) throws WriteAccessException {
        throw ExceptionFactory.createIsReadOnlyException();
    }

    public void setName(String name) throws WriteAccessException {
        throw ExceptionFactory.createIsReadOnlyException();
    }

    public ICResourceDescription[] getNestedResourceDescriptions() {
        return this.getNestedResourceDescriptions(12);
    }

    private ResourceDescriptionHolder getRcDesHolder() {
        if (this.fRcDesHolder == null) {
            this.fRcDesHolder = this.fCfg.createHolderForRc(this.getPath());
        }
        return this.fRcDesHolder;
    }

    public boolean isReadOnly() {
        return true;
    }

    public ICFolderDescription getParentFolderDescription() {
        return this.getRcDesHolder().getParentFolderDescription();
    }

    public ICLanguageSetting createLanguageSetting(IContentType srcType) {
        throw ExceptionFactory.createIsReadOnlyException();
    }

    public ICLanguageSetting createLanguageSettingForContentTypes(String languageId, String[] typeIds) {
        throw ExceptionFactory.createIsReadOnlyException();
    }

    public ICLanguageSetting createLanguageSettingForExtensions(String languageId, String[] extensions) {
        throw ExceptionFactory.createIsReadOnlyException();
    }

    public CLanguageData createLanguageDataForContentTypes(String languageId, String[] typesIds) {
        throw ExceptionFactory.createIsReadOnlyException();
    }

    public CLanguageData createLanguageDataForExtensions(String languageId, String[] extensions) {
        throw ExceptionFactory.createIsReadOnlyException();
    }

    public boolean isRoot() {
        return this.getPath().segmentCount() == 0;
    }

    public IPath getPath() {
        return ResourceDescriptionHolder.normalizePath(super.getPath());
    }

    public boolean hasCustomSettings() {
        return true;
    }

    public boolean isExcluded() {
        return this.fCfg.isExcluded(this.getPath());
    }
}

