/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.export;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.export.ExternalExportProjectProvider;
import org.eclipse.cdt.core.index.export.IExportProjectProvider;
import org.eclipse.cdt.internal.core.pdom.export.CLIUtil;
import org.eclipse.cdt.internal.core.pdom.export.GeneratePDOM;
import org.eclipse.cdt.internal.core.pdom.export.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;

public class GeneratePDOMApplication
implements IApplication {
    private static final String EXPORT_PROJECT_PROVIDER = "ExportProjectProvider";
    private static final String DEFAULT_PROJECT_PROVIDER = ExternalExportProjectProvider.class.getName();
    public static final String OPT_PROJECTPROVIDER = "-pprovider";
    public static final String OPT_TARGET = "-target";
    public static final String OPT_QUIET = "-quiet";
    public static final String OPT_INDEXER_ID = "-indexer";
    public static final int ECODE_EXPECTED_FAILURE = 1;
    private static Map<String, IExportProjectProvider> projectInitializers;

    public Object start(IApplicationContext context) throws CoreException {
        Object result = IApplication.EXIT_OK;
        try {
            result = this.startImpl(context);
        }
        catch (CoreException ce) {
            IStatus s = ce.getStatus();
            if (s.getCode() == 1) {
                this.output(s.getMessage());
            }
            throw ce;
        }
        return result;
    }

    private Object startImpl(IApplicationContext context) throws CoreException {
        String pproviderFQN;
        String[] appArgs = (String[])context.getArguments().get("application.args");
        Map<String, List<String>> arguments = CLIUtil.parseToMap(appArgs);
        this.output(Messages.GeneratePDOMApplication_Initializing);
        this.setupCLIProgressProvider();
        if (!arguments.containsKey(OPT_PROJECTPROVIDER)) {
            this.output(MessageFormat.format((String)Messages.GeneratePDOMApplication_UsingDefaultProjectProvider, (Object[])new Object[]{DEFAULT_PROJECT_PROVIDER}));
            pproviderFQN = DEFAULT_PROJECT_PROVIDER;
        } else {
            pproviderFQN = CLIUtil.getArg(arguments, OPT_PROJECTPROVIDER, 1).get(0);
        }
        String target = CLIUtil.getArg(arguments, OPT_TARGET, 1).get(0);
        boolean quiet = arguments.get(OPT_QUIET) != null;
        String indexerID = "org.eclipse.cdt.core.fastIndexer";
        List<String> indexerIDs = arguments.get(OPT_INDEXER_ID);
        if (indexerIDs != null) {
            if (indexerIDs.size() == 1) {
                indexerID = indexerIDs.get(0);
            } else if (indexerIDs.size() > 1) {
                GeneratePDOMApplication.fail(MessageFormat.format((String)Messages.GeneratePDOMApplication_InvalidIndexerID, (Object[])new Object[]{OPT_INDEXER_ID}));
            }
        }
        String[] oldvals = null;
        if (!quiet) {
            oldvals = new String[]{System.getProperty("org.eclipse.cdt.core/debug/indexer/activity"), System.getProperty("org.eclipse.cdt.core/debug/indexer/problems"), System.getProperty("org.eclipse.cdt.core/debug/indexer/statistics")};
            System.setProperty("org.eclipse.cdt.core/debug/indexer/activity", Boolean.TRUE.toString());
            System.setProperty("org.eclipse.cdt.core/debug/indexer/problems", Boolean.TRUE.toString());
            System.setProperty("org.eclipse.cdt.core/debug/indexer/statistics", Boolean.TRUE.toString());
        }
        try {
            IExportProjectProvider pprovider = GeneratePDOMApplication.getExportProjectProvider(pproviderFQN);
            if (pprovider == null) {
                GeneratePDOMApplication.fail(MessageFormat.format((String)Messages.GeneratePDOMApplication_CouldNotFindInitializer, (Object[])new Object[]{pproviderFQN}));
            }
            File targetLocation = new File(target);
            GeneratePDOM generate = new GeneratePDOM(pprovider, appArgs, targetLocation, indexerID);
            this.output(Messages.GeneratePDOMApplication_GenerationStarts);
            IStatus status = generate.run();
            if (!status.isOK()) {
                this.output(status.getMessage());
            }
            this.output(Messages.GeneratePDOMApplication_GenerationEnds);
        }
        finally {
            if (oldvals != null) {
                this.restoreSystemProperty("org.eclipse.cdt.core/debug/indexer/activity", oldvals[0]);
                this.restoreSystemProperty("org.eclipse.cdt.core/debug/indexer/problems", oldvals[1]);
                this.restoreSystemProperty("org.eclipse.cdt.core/debug/indexer/statistics", oldvals[2]);
            }
        }
        return null;
    }

    private void restoreSystemProperty(String key, String value) {
        if (value == null) {
            System.clearProperty(key);
        } else {
            System.setProperty(key, value);
        }
    }

    protected void output(String s) {
        System.out.println(s);
    }

    public void stop() {
    }

    public static final void fail(String message) throws CoreException {
        Status status = new Status(4, "org.eclipse.cdt.core", 1, message, null);
        CCorePlugin.log((IStatus)status);
        throw new CoreException((IStatus)status);
    }

    private static synchronized IExportProjectProvider getExportProjectProvider(String fqn) {
        if (projectInitializers == null) {
            IExtension[] extensions;
            projectInitializers = new HashMap<String, IExportProjectProvider>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint indexExtensions = registry.getExtensionPoint("org.eclipse.cdt.core.CIndex");
            IExtension[] iExtensionArray = extensions = indexExtensions.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] ce;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = ce = extension.getConfigurationElements();
                int n3 = ce.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().equals(EXPORT_PROJECT_PROVIDER)) {
                        try {
                            IExportProjectProvider epp = (IExportProjectProvider)element.createExecutableExtension("class");
                            projectInitializers.put(epp.getClass().getName(), epp);
                        }
                        catch (CoreException cee) {
                            CCorePlugin.log(cee);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        IExportProjectProvider initer = projectInitializers.get(fqn);
        return initer;
    }

    private void setupCLIProgressProvider() {
        ProgressProvider pp = new ProgressProvider(){

            public IProgressMonitor createMonitor(Job job) {
                return new IndexingStreamProgressMonitor(System.out);
            }

            public IProgressMonitor createMonitor(Job job, IProgressMonitor group, int ticks) {
                return new NullProgressMonitor();
            }

            public IProgressMonitor createProgressGroup() {
                return new NullProgressMonitor();
            }

            class IndexingStreamProgressMonitor
            extends StreamProgressMonitor {
                public IndexingStreamProgressMonitor(PrintStream writer) {
                    super(writer);
                }

                protected boolean shouldOutput() {
                    return this.taskName != null && this.taskName.equals(CCorePlugin.getResourceString("pdom.indexer.task"));
                }
            }
        };
        Job.getJobManager().setProgressProvider(pp);
    }

    static class StreamProgressMonitor
    implements IProgressMonitor {
        volatile boolean canceled;
        volatile int totalWork;
        volatile double worked;
        final PrintStream writer;
        volatile String taskName;
        volatile String subTask;
        Object mutex = new Object();

        StreamProgressMonitor(PrintStream writer) {
            this.writer = writer;
            this.totalWork = -1;
        }

        protected boolean shouldOutput() {
            return true;
        }

        public void done() {
        }

        public void worked(int work) {
            this.internalWorked(work);
        }

        public void beginTask(String name, int total) {
            this.taskName = name;
            this.totalWork = total;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void internalWorked(double work) {
            Object object = this.mutex;
            synchronized (object) {
                int pc;
                this.worked += work;
                int n = pc = this.totalWork < 1 ? 0 : (int)(this.worked * 100.0 / (double)this.totalWork);
                if (this.shouldOutput()) {
                    this.writer.println(String.valueOf(pc) + "% " + this.subTask);
                }
            }
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public void setCanceled(boolean value) {
            this.canceled = value;
        }

        public void setTaskName(String name) {
            this.taskName = name;
        }

        public void subTask(String name) {
            this.subTask = name;
        }
    }
}

