/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.export;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.core.index.IIndexManager;
import org.eclipse.cdt.core.index.export.IExportProjectProvider;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.internal.core.CCoreInternals;
import org.eclipse.cdt.internal.core.pdom.WritablePDOM;
import org.eclipse.cdt.internal.core.pdom.export.GeneratePDOMApplication;
import org.eclipse.cdt.internal.core.pdom.export.Messages;
import org.eclipse.cdt.internal.core.pdom.indexer.IndexerPreferences;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;

public class GeneratePDOM {
    protected IExportProjectProvider pm;
    protected String[] applicationArguments;
    protected File targetLocation;
    protected String indexerID;
    protected boolean deleteOnExit;

    public GeneratePDOM(IExportProjectProvider pm, String[] applicationArguments, File targetLocation, String indexerID) {
        this.pm = pm;
        this.applicationArguments = applicationArguments;
        this.targetLocation = targetLocation;
        this.indexerID = indexerID;
    }

    public void setDeleteOnExit(boolean deleteOnExit) {
        this.deleteOnExit = deleteOnExit;
    }

    public final IStatus run() throws CoreException {
        boolean isContentSynced;
        block15: {
            isContentSynced = false;
            this.pm.setApplicationArguments(this.applicationArguments);
            ICProject cproject = this.pm.createProject();
            if (cproject == null) {
                this.fail(MessageFormat.format((String)Messages.GeneratePDOM_ProjectProviderReturnedNullCProject, (Object[])new Object[]{this.pm.getClass().getName()}));
                return null;
            }
            IIndexLocationConverter converter = this.pm.getLocationConverter(cproject);
            if (converter == null) {
                this.fail(MessageFormat.format((String)Messages.GeneratePDOM_NullLocationConverter, (Object[])new Object[]{this.pm.getClass().getName()}));
            }
            IndexerPreferences.set(cproject.getProject(), "indexerId", this.indexerID);
            try {
                try {
                    IIndexManager im = CCorePlugin.getIndexManager();
                    int i = 0;
                    while (i < 20) {
                        if (CCoreInternals.getPDOMManager().isProjectRegistered(cproject)) {
                            im.joinIndexer(Integer.MAX_VALUE, (IProgressMonitor)new NullProgressMonitor());
                            if (!im.isIndexerSetupPostponed(cproject)) break;
                        }
                        Thread.sleep(200L);
                        ++i;
                    }
                    isContentSynced = CCoreInternals.getPDOMManager().isProjectContentSynced(cproject);
                    if (!isContentSynced) break block15;
                    CCoreInternals.getPDOMManager().exportProjectPDOM(cproject, this.targetLocation, converter);
                    WritablePDOM exportedPDOM = new WritablePDOM(this.targetLocation, converter, LanguageManager.getInstance().getPDOMLinkageFactoryMappings());
                    exportedPDOM.acquireWriteLock(0);
                    try {
                        Map<String, String> exportProperties = this.pm.getExportProperties();
                        if (exportProperties != null) {
                            for (Map.Entry<String, String> entry : exportProperties.entrySet()) {
                                exportedPDOM.setProperty(entry.getKey(), entry.getValue());
                            }
                        }
                        exportedPDOM.close();
                    }
                    finally {
                        exportedPDOM.releaseWriteLock();
                    }
                }
                catch (InterruptedException ie) {
                    String msg = MessageFormat.format((String)Messages.GeneratePDOM_GenericGenerationFailed, (Object[])new Object[]{ie.getMessage()});
                    throw new CoreException(CCorePlugin.createStatus(msg, ie));
                }
            }
            finally {
                if (this.deleteOnExit) {
                    cproject.getProject().delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
        return isContentSynced ? new Status(0, "org.eclipse.cdt.core", Messages.GeneratePDOM_Success) : new Status(4, "org.eclipse.cdt.core", Messages.GeneratePDOM_Incomplete);
    }

    private void fail(String message) throws CoreException {
        GeneratePDOMApplication.fail(message);
    }
}

