/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.c;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCAnnotation;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCFunctionType;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCParameter;
import org.eclipse.core.runtime.CoreException;

class PDOMCFunction
extends PDOMBinding
implements IFunction {
    public static final int NUM_PARAMS = 28;
    public static final int FIRST_PARAM = 32;
    private static final int FUNCTION_TYPE = 36;
    private static final int ANNOTATIONS = 40;
    public static final int RECORD_SIZE = 41;

    public PDOMCFunction(PDOMLinkage linkage, long record) {
        super(linkage, record);
    }

    public PDOMCFunction(PDOMLinkage linkage, PDOMNode parent, IFunction function) throws CoreException {
        super(linkage, parent, function.getNameCharArray());
        byte annotations;
        IParameter[] parameters;
        IFunctionType type;
        try {
            type = function.getType();
            parameters = function.getParameters();
            annotations = PDOMCAnnotation.encodeAnnotation(function);
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus(e));
        }
        this.setType((PDOMLinkage)this.getLinkage(), type);
        this.setParameters(parameters);
        this.getDB().putByte(this.record + 40L, annotations);
    }

    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (newBinding instanceof IFunction) {
            byte newAnnotation;
            IParameter[] newParams;
            IFunctionType newType;
            IFunction func = (IFunction)newBinding;
            try {
                newType = func.getType();
                newParams = func.getParameters();
                newAnnotation = PDOMCAnnotation.encodeAnnotation(func);
            }
            catch (DOMException e) {
                throw new CoreException(Util.createStatus(e));
            }
            IFunctionType oldType = this.getType();
            this.setType(linkage, newType);
            PDOMCParameter oldParams = this.getFirstParameter();
            this.setParameters(newParams);
            if (oldType != null) {
                linkage.deleteType(oldType, this.record);
            }
            if (oldParams != null) {
                oldParams.delete(linkage);
            }
            this.getDB().putByte(this.record + 40L, newAnnotation);
        }
    }

    private void setType(PDOMLinkage linkage, IFunctionType ft) throws CoreException {
        PDOMNode typeNode;
        long rec = 0L;
        if (ft != null && (typeNode = linkage.addType(this, ft)) != null) {
            rec = typeNode.getRecord();
        }
        this.getDB().putRecPtr(this.record + 36L, rec);
    }

    private void setParameters(IParameter[] params) throws CoreException {
        this.getDB().putInt(this.record + 28L, params.length);
        this.getDB().putRecPtr(this.record + 32L, 0L);
        int i = 0;
        while (i < params.length) {
            this.setFirstParameter(new PDOMCParameter((PDOMLinkage)this.getLinkage(), (PDOMNode)this, params[i]));
            ++i;
        }
    }

    public PDOMCParameter getFirstParameter() throws CoreException {
        long rec = this.getDB().getRecPtr(this.record + 32L);
        return rec != 0L ? new PDOMCParameter((PDOMLinkage)this.getLinkage(), rec) : null;
    }

    public void setFirstParameter(PDOMCParameter param) throws CoreException {
        if (param != null) {
            param.setNextParameter(this.getFirstParameter());
        }
        long rec = param != null ? param.getRecord() : 0L;
        this.getDB().putRecPtr(this.record + 32L, rec);
    }

    protected int getRecordSize() {
        return 41;
    }

    public int getNodeType() {
        return 7;
    }

    public IFunctionType getType() {
        try {
            long offset = this.getDB().getRecPtr(this.record + 36L);
            return offset == 0L ? null : new PDOMCFunctionType((PDOMLinkage)this.getLinkage(), offset);
        }
        catch (CoreException ce) {
            CCorePlugin.log(ce);
            return null;
        }
    }

    public boolean isStatic() throws DOMException {
        return this.getBit(this.getByte(this.record + 40L), 4);
    }

    public boolean isExtern() throws DOMException {
        return this.getBit(this.getByte(this.record + 40L), 1);
    }

    public IParameter[] getParameters() throws DOMException {
        try {
            int n = this.getDB().getInt(this.record + 28L);
            IParameter[] params = new IParameter[n];
            PDOMCParameter param = this.getFirstParameter();
            while (param != null) {
                params[--n] = param;
                param = param.getNextParameter();
            }
            return params;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new IParameter[0];
        }
    }

    public boolean isAuto() throws DOMException {
        return false;
    }

    public boolean isRegister() throws DOMException {
        return false;
    }

    public boolean isInline() throws DOMException {
        return this.getBit(this.getByte(this.record + 40L), 2);
    }

    public boolean takesVarArgs() throws DOMException {
        return this.getBit(this.getByte(this.record + 40L), 5);
    }

    public IScope getFunctionScope() throws DOMException {
        return null;
    }
}

