/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacroContainer;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public final class MacroContainerPatternCollector
implements IBTreeVisitor {
    private final PDOMLinkage fLinkage;
    private final List<PDOMMacroContainer> macros = new ArrayList<PDOMMacroContainer>();
    private final Pattern fPattern;
    private final IProgressMonitor fMonitor;
    private int fMonitorCheckCounter = 0;

    public MacroContainerPatternCollector(PDOMLinkage linkage, Pattern pattern, IProgressMonitor monitor) {
        this.fLinkage = linkage;
        this.fPattern = pattern;
        this.fMonitor = monitor;
    }

    public final int compare(long record) throws CoreException {
        if (this.fMonitor != null) {
            this.checkCancelled();
        }
        return 0;
    }

    public final boolean visit(long record) throws CoreException {
        if (record == 0L) {
            return true;
        }
        String name = PDOMNamedNode.getDBName(this.fLinkage.getDB(), record).getString();
        if (this.fPattern.matcher(name).matches()) {
            this.macros.add(new PDOMMacroContainer(this.fLinkage, record));
        }
        return true;
    }

    public final PDOMMacroContainer[] getMacroContainers() {
        return this.macros.toArray(new PDOMMacroContainer[this.macros.size()]);
    }

    private void checkCancelled() {
        if (++this.fMonitorCheckCounter % 4096 == 0 && this.fMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }
}

