/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.internal.core.parser.scanner.Lexer;
import org.eclipse.cdt.internal.core.parser.scanner.MacroExpander;
import org.eclipse.cdt.internal.core.parser.scanner.PreprocessorMacro;
import org.eclipse.cdt.internal.core.parser.scanner.Token;
import org.eclipse.cdt.internal.core.parser.scanner.TokenList;
import org.eclipse.text.edits.ReplaceEdit;

public class MacroExpansionTracker {
    private final int fStepToTrack;
    private int fStepCount;
    private String fPreStep;
    private ReplaceEdit fReplacement;
    private IMacroBinding fMacroDefinition;
    private Lexer fLexer;
    private String fReplacementText = "";
    private LinkedList<MacroInfo> fMacroStack = new LinkedList();
    private IToken fReplaceFrom;
    private IToken fReplaceTo;

    public MacroExpansionTracker(int stepToTrack) {
        this.fStepToTrack = stepToTrack;
    }

    public boolean isDone() {
        return this.fStepCount > this.fStepToTrack;
    }

    public boolean isRequestedStep() {
        return this.fStepCount == this.fStepToTrack;
    }

    public int getStepCount() {
        return this.fStepCount;
    }

    public String getCodeBeforeStep() {
        return this.fPreStep;
    }

    public ReplaceEdit getReplacement() {
        return this.fReplacement;
    }

    public IMacroBinding getExpandedMacro() {
        return this.fMacroDefinition;
    }

    void start(Lexer lexer) {
        this.fLexer = lexer;
    }

    void finish(TokenList result, int endOffset) {
        char[] lexInput = this.fLexer.getInput();
        if (!this.isDone()) {
            StringBuilder replacementText = new StringBuilder();
            this.toString(result, lexInput, replacementText, replacementText, replacementText);
            this.fPreStep = new String(lexInput);
            this.fReplacement = new ReplaceEdit(0, endOffset, replacementText.toString());
        } else {
            StringBuilder before = new StringBuilder();
            StringBuilder replace = new StringBuilder();
            StringBuilder after = new StringBuilder();
            this.toString(result, lexInput, before, replace, after);
            int offset = before.length();
            StringBuilder csr = replace;
            StringBuilder csa = after;
            before.append((CharSequence)csr).append((CharSequence)csa);
            before.append(lexInput, endOffset, lexInput.length - endOffset);
            this.fPreStep = before.toString();
            this.fReplacement = new ReplaceEdit(offset, replace.length(), this.fReplacementText);
        }
    }

    void fail() {
        this.fPreStep = new String(this.fLexer.getInput());
        this.fReplacement = new ReplaceEdit(0, 0, "");
    }

    private void toString(TokenList tokenList, char[] rootInput, StringBuilder before, StringBuilder replace, StringBuilder after) {
        StringBuilder buf = before;
        Token t = tokenList.first();
        if (t == null) {
            return;
        }
        Token l = null;
        while (t != null) {
            char[] input;
            Token n = (Token)t.getNext();
            if (l != null && MacroExpander.hasImplicitSpace(l, t)) {
                input = this.getInputForSource(l.fSource, rootInput);
                if (input == null) {
                    buf.append(' ');
                } else {
                    int from = l.getEndOffset();
                    int to = t.getOffset();
                    buf.append(input, from, to - from);
                }
            }
            if (t == this.fReplaceFrom) {
                buf = replace;
            }
            if ((input = this.getInputForSource(t.fSource, rootInput)) == null) {
                buf.append(t.getCharImage());
            } else {
                buf.append(input, t.getOffset(), t.getLength());
            }
            if (t == this.fReplaceTo) {
                buf = after;
            }
            l = t;
            t = n;
        }
    }

    private char[] getInputForSource(Object source, char[] rootInput) {
        PreprocessorMacro pm;
        if (source instanceof MacroExpander) {
            return rootInput;
        }
        if (source instanceof PreprocessorMacro && !(pm = (PreprocessorMacro)source).isDynamic()) {
            return pm.getExpansionImage();
        }
        return null;
    }

    public void startFunctionStyleMacro(Token identifier) {
        this.fMacroStack.add(new MacroInfo(identifier));
    }

    public void addFunctionStyleMacroExpansionToken(Token t) {
        this.fMacroStack.getLast().fMacroCall.append(t);
    }

    public void setExpandedMacroArgument(TokenList tokenList) {
        this.fMacroStack.getLast().setArgument(tokenList);
    }

    public void storeFunctionStyleMacroReplacement(PreprocessorMacro macro, TokenList replacement, TokenList result) {
        MacroInfo minfo = this.fMacroStack.getLast();
        this.fMacroDefinition = macro;
        this.fReplaceFrom = minfo.fMacroCall.first();
        this.appendFunctionStyleMacro(result);
        this.fReplaceTo = result.last();
        StringBuilder buf = new StringBuilder();
        this.toString(replacement, this.fLexer.getInput(), buf, buf, buf);
        this.fReplacementText = buf.toString();
    }

    public void appendFunctionStyleMacro(TokenList result) {
        MacroInfo minfo = this.fMacroStack.getLast();
        boolean active = true;
        int nesting = -1;
        int pcount = 0;
        Token l = null;
        Token t = minfo.fMacroCall.first();
        while (t != null) {
            Token n = (Token)t.getNext();
            switch (t.getType()) {
                case 8: {
                    TokenList p;
                    if (active) {
                        result.append(t);
                    }
                    if (++nesting != 0 || pcount >= minfo.fArguments.size() || (p = (TokenList)minfo.fArguments.get(pcount)) == null) break;
                    active = false;
                    if (n == null || n.getType() == 6 || n.getType() == 9) break;
                    MacroExpander.addSpacemarker(t, n, result);
                    result.appendAll(p);
                    break;
                }
                case 9: {
                    if (!active && nesting == 0) {
                        MacroExpander.addSpacemarker(l, t, result);
                        active = true;
                    }
                    if (active) {
                        result.append(t);
                    }
                    if (nesting <= 0) break;
                    --nesting;
                    break;
                }
                case 6: {
                    TokenList p;
                    if (nesting == 0) {
                        if (++pcount >= minfo.fArguments.size()) break;
                        if (!active) {
                            MacroExpander.addSpacemarker(l, t, result);
                        }
                        result.append(t);
                        p = (TokenList)minfo.fArguments.get(pcount);
                        boolean bl = active = p == null;
                        if (active || n == null || n.getType() == 6 || n.getType() == 9) break;
                        MacroExpander.addSpacemarker(t, n, result);
                        result.appendAll(p);
                        break;
                    }
                    if (!active) break;
                    result.append(t);
                    break;
                }
                default: {
                    if (!active) break;
                    result.append(t);
                }
            }
            l = t;
            t = n;
        }
    }

    public void endFunctionStyleMacro() {
        ++this.fStepCount;
        this.fMacroStack.removeLast();
    }

    public void storeObjectStyleMacroReplacement(PreprocessorMacro macro, Token identifier, TokenList replacement, TokenList result) {
        this.fMacroDefinition = macro;
        this.fReplaceFrom = this.fReplaceTo = identifier;
        result.append(identifier);
        StringBuilder buf = new StringBuilder();
        this.toString(replacement, this.fLexer.getInput(), buf, buf, buf);
        this.fReplacementText = buf.toString();
    }

    public void endObjectStyleMacro() {
        ++this.fStepCount;
    }

    public class MacroInfo {
        private TokenList fMacroCall = new TokenList();
        private ArrayList<TokenList> fArguments = new ArrayList();

        public MacroInfo(Token identifier) {
            this.fMacroCall.append(identifier);
        }

        public void setArgument(TokenList tokenList) {
            this.fArguments.add(tokenList);
        }
    }
}

