/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.dom.rewrite.MacroExpansionExplorer;
import org.eclipse.text.edits.ReplaceEdit;

public class MacroExpansionStep
implements MacroExpansionExplorer.IMacroExpansionStep {
    private final String fBefore;
    private final IMacroBinding fMacroDefinition;
    private final ReplaceEdit[] fReplacements;
    private final IASTFileLocation fMacroLocation;

    public MacroExpansionStep(String before, IMacroBinding def, IASTFileLocation macroLoc, ReplaceEdit[] replacements) {
        this.fBefore = before;
        this.fReplacements = replacements;
        this.fMacroDefinition = def;
        this.fMacroLocation = macroLoc;
    }

    public String getCodeBeforeStep() {
        return this.fBefore;
    }

    public String getCodeAfterStep() {
        StringBuilder result = new StringBuilder();
        int offset = 0;
        int i = 0;
        while (i < this.fReplacements.length) {
            ReplaceEdit r = this.fReplacements[i];
            result.append(this.fBefore, offset, r.getOffset());
            result.append(r.getText());
            offset = r.getExclusiveEnd();
            ++i;
        }
        result.append(this.fBefore, offset, this.fBefore.length());
        return result.toString();
    }

    public IMacroBinding getExpandedMacro() {
        return this.fMacroDefinition;
    }

    public ReplaceEdit[] getReplacements() {
        return this.fReplacements;
    }

    public IASTFileLocation getLocationOfExpandedMacroDefinition() {
        return this.fMacroLocation;
    }
}

