/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model.ext;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.internal.core.model.FunctionDeclaration;
import org.eclipse.cdt.internal.core.model.ext.CElementHandle;

public class FunctionDeclarationHandle
extends CElementHandle
implements IFunctionDeclaration {
    private String[] fParameterTypes;
    private boolean fIsStatic;

    public FunctionDeclarationHandle(ICElement parent, IFunction func) throws DOMException {
        this(parent, 73, func);
    }

    protected FunctionDeclarationHandle(ICElement parent, int type, IFunction func) throws DOMException {
        super(parent, type, func.getName());
        this.fParameterTypes = this.extractParameterTypes(func);
        try {
            this.fIsStatic = func.isStatic();
        }
        catch (DOMException e) {
            CCorePlugin.log(e);
            this.fIsStatic = false;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof IFunctionDeclaration) {
            return FunctionDeclaration.equals(this, (IFunctionDeclaration)obj);
        }
        return false;
    }

    public int getNumberOfParameters() {
        return this.fParameterTypes.length;
    }

    public String[] getParameterTypes() {
        return this.fParameterTypes;
    }

    public String getSignature() throws CModelException {
        return FunctionDeclaration.getSignature(this);
    }

    public boolean isStatic() throws CModelException {
        return this.fIsStatic;
    }
}

